/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.el;

import jakarta.el.ArrayELResolver;
import jakarta.el.BeanELResolver;
import jakarta.el.CompositeELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.el.FunctionMapper;
import jakarta.el.ListELResolver;
import jakarta.el.MapELResolver;
import jakarta.el.ResourceBundleELResolver;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.bval.el.MessageEvaluator;
import org.apache.bval.jsr.util.LookBehindRegexHolder;

public final class ELFacade
implements MessageEvaluator {
    private static final ELResolver RESOLVER = ELFacade.initResolver();
    private final ExpressionFactory expressionFactory = ExpressionFactory.newInstance();

    @Override
    public String interpolate(String message, Map<String, Object> annotationParameters, Object validatedValue) {
        if (message.contains("${")) {
            try {
                BValELContext context = new BValELContext();
                VariableMapper variables = context.getVariableMapper();
                annotationParameters.forEach((k, v) -> variables.setVariable(k, this.expressionFactory.createValueExpression(v, Object.class)));
                variables.setVariable("validatedValue", this.expressionFactory.createValueExpression(validatedValue, Object.class));
                return this.expressionFactory.createValueExpression((ELContext)context, EvaluationType.DEFERRED.regex.matcher(message).replaceAll("\\$0"), String.class).getValue((ELContext)context).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return message;
    }

    private static ELResolver initResolver() {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)new MapELResolver());
        resolver.add((ELResolver)new ListELResolver());
        resolver.add((ELResolver)new ArrayELResolver());
        resolver.add((ELResolver)new ResourceBundleELResolver());
        resolver.add((ELResolver)new BeanELResolver());
        return resolver;
    }

    public static class BValFormatter {
        private final Formatter formatter = new Formatter();

        public Formatter format(String format, Object ... args) {
            return this.formatter.format(format, args);
        }
    }

    private class BValVariableMapper
    extends VariableMapper {
        private final Map<String, ValueExpression> variables = new HashMap<String, ValueExpression>();

        private BValVariableMapper() {
        }

        public ValueExpression resolveVariable(String variable) {
            if ("formatter".equals(variable)) {
                return ELFacade.this.expressionFactory.createValueExpression((Object)new BValFormatter(), Object.class);
            }
            return this.variables.get(variable);
        }

        public ValueExpression setVariable(String variable, ValueExpression expression) {
            this.variables.put(variable, expression);
            return expression;
        }
    }

    private static class BValFunctionMapper
    extends FunctionMapper {
        private BValFunctionMapper() {
        }

        public Method resolveFunction(String prefix, String localName) {
            return null;
        }
    }

    private class BValELContext
    extends ELContext {
        private final FunctionMapper functions = new BValFunctionMapper();
        private final VariableMapper variables = new BValVariableMapper();

        private BValELContext() {
        }

        public ELResolver getELResolver() {
            return RESOLVER;
        }

        public FunctionMapper getFunctionMapper() {
            return this.functions;
        }

        public VariableMapper getVariableMapper() {
            return this.variables;
        }
    }

    private static enum EvaluationType {
        IMMEDIATE("\\$"),
        DEFERRED("#");

        private final LookBehindRegexHolder regex;

        private EvaluationType(String trigger) {
            this.regex = new LookBehindRegexHolder(String.format("(?<!(?:^|[^\\\\])(?:\\\\\\\\){0,%%d}\\\\)%s\\{", trigger), n -> (n - 3) / 2);
        }
    }
}

