/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.openapi;

import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SysPropConfigSource;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import io.smallrye.openapi.api.OpenApiDocument;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.microprofile.openapi.MicroProfileOpenApiEndpoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;

public class MicroProfileOpenApiRegistration
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.MICROPROFILE, MicroProfileOpenApiRegistration.class);

    public void onStartup(Set<Class<?>> c, ServletContext servletContext) throws ServletException {
        if ("none".equals(SystemInstance.get().getOptions().get("tomee.mp.scan", "none"))) {
            return;
        }
        LOGGER.info("Registering OpenAPI servlet on /openapi for application " + servletContext.getContextPath());
        ServletRegistration.Dynamic servletRegistration = servletContext.addServlet("mp-openapi-servlet", MicroProfileOpenApiEndpoint.class);
        servletRegistration.addMapping(new String[]{"/openapi/*"});
    }

    public static void registerOpenApiServlet(ServletContext servletContext, IndexView indexView) {
        Optional<OpenAPI> openAPI = MicroProfileOpenApiRegistration.generateOpenAPI(servletContext, indexView);
        openAPI.ifPresent(openApi -> MicroProfileOpenApiRegistration.setOpenApi(servletContext, (OpenAPI)openAPI.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<OpenAPI> generateOpenAPI(ServletContext servletContext, IndexView indexView) {
        OpenApiConfig openApiConfig = MicroProfileOpenApiRegistration.config(servletContext);
        FilteredIndexView filteredIndexView = new FilteredIndexView(indexView, openApiConfig);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Optional<OpenAPI> readerModel = Optional.ofNullable(OpenApiProcessor.modelFromReader((OpenApiConfig)openApiConfig, (ClassLoader)contextClassLoader));
        Optional<OpenAPI> staticFileModel = MicroProfileOpenApiRegistration.openApiFromStaticFile(servletContext);
        Optional<OpenAPI> annotationModel = Optional.ofNullable(OpenApiProcessor.modelFromAnnotations((OpenApiConfig)openApiConfig, (ClassLoader)contextClassLoader, (IndexView)filteredIndexView));
        OpenApiDocument document = OpenApiDocument.INSTANCE;
        try {
            document.reset();
            document.config(openApiConfig);
            readerModel.ifPresent(arg_0 -> ((OpenApiDocument)document).modelFromReader(arg_0));
            staticFileModel.ifPresent(arg_0 -> ((OpenApiDocument)document).modelFromStaticFile(arg_0));
            annotationModel.ifPresent(arg_0 -> ((OpenApiDocument)document).modelFromAnnotations(arg_0));
            document.filter(OpenApiProcessor.getFilter((OpenApiConfig)openApiConfig, (ClassLoader)contextClassLoader));
            document.initialize();
            Optional<OpenAPI> optional = Optional.ofNullable(document.get());
            return optional;
        }
        finally {
            document.reset();
        }
    }

    private static OpenApiConfig config(ServletContext servletContext) {
        try {
            Optional microprofileConfig = Stream.of(Optional.ofNullable(servletContext.getResource("/META-INF/microprofile-config.properties")), Optional.ofNullable(servletContext.getResource("/WEB-INF/classes/META-INF/microprofile-config.properties"))).filter(Optional::isPresent).findFirst().flatMap(url -> url);
            if (microprofileConfig.isEmpty()) {
                LOGGER.debug("Could not find OpenAPI config from MicroProfile Config files. Using default configuration.");
                return new OpenApiConfigImpl(ConfigProvider.getConfig());
            }
            LOGGER.debug("Building OpenAPI config from MicroProfile Config file " + ((URL)microprofileConfig.get()).toExternalForm());
            Properties properties = IO.readProperties((URL)((URL)microprofileConfig.get()));
            SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new EnvConfigSource(MicroProfileOpenApiRegistration.getEnvProperties(), 300)}).withSources(new ConfigSource[]{new SysPropConfigSource()}).withSources(new ConfigSource[]{new PropertiesConfigSource(properties, "microprofile-config.properties")}).addDefaultInterceptors().build();
            return new OpenApiConfigImpl((Config)config);
        }
        catch (IOException e) {
            LOGGER.error("Failed loading OpenAPI config from MicroProfile config file. Using default configuration", (Throwable)e);
            return new OpenApiConfigImpl(ConfigProvider.getConfig());
        }
    }

    private static Optional<OpenAPI> openApiFromStaticFile(ServletContext servletContext) {
        try {
            Optional<OpenAPI> staticOpenApi = Stream.of(MicroProfileOpenApiRegistration.readOpenApiFile(servletContext, "/META-INF/openapi.json", Format.JSON), MicroProfileOpenApiRegistration.readOpenApiFile(servletContext, "/META-INF/openapi.yaml", Format.YAML), MicroProfileOpenApiRegistration.readOpenApiFile(servletContext, "/META-INF/openapi.yml", Format.YAML)).filter(Optional::isPresent).findFirst().flatMap(file -> file);
            if (staticOpenApi.isEmpty()) {
                LOGGER.debug("Could not find any static OpenAPI file in application " + servletContext.getContextPath());
            }
            return staticOpenApi;
        }
        catch (Exception e) {
            LOGGER.error("Failed loading static OpenAPI files in application " + servletContext.getContextPath(), (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<OpenAPI> readOpenApiFile(ServletContext servletContext, String location, Format format) throws Exception {
        URL resource = servletContext.getResource(location);
        if (resource == null) {
            LOGGER.debug("Could not find static OpenAPI file " + location);
            return Optional.empty();
        }
        LOGGER.debug("Found static OpenAPI file " + location);
        try (OpenApiStaticFile staticFile = new OpenApiStaticFile(resource.openStream(), format);){
            Optional<OpenAPI> optional = Optional.of(OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
            return optional;
        }
    }

    public static void setOpenApi(ServletContext servletContext, OpenAPI openAPI) {
        Objects.requireNonNull(servletContext);
        Objects.requireNonNull(openAPI);
        servletContext.setAttribute(MicroProfileOpenApiRegistration.class.getName() + ".OpenAPI", (Object)openAPI);
    }

    public static OpenAPI getOpenApi(ServletContext servletContext) {
        Objects.requireNonNull(servletContext);
        return (OpenAPI)servletContext.getAttribute(MicroProfileOpenApiRegistration.class.getName() + ".OpenAPI");
    }

    private static Map<String, String> getEnvProperties() {
        return Collections.unmodifiableMap(AccessController.doPrivileged(() -> new HashMap<String, String>(System.getenv())));
    }
}

