/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.RecordComponentInfo;

public interface AnnotationTransformation {
    public static final int DEFAULT_PRIORITY_VALUE = 1000;

    default public int priority() {
        return 1000;
    }

    default public boolean supports(AnnotationTarget.Kind kind) {
        return true;
    }

    public void apply(TransformationContext var1);

    default public boolean requiresCompatibleMode() {
        return false;
    }

    public static DeclarationBuilder builder() {
        return new DeclarationBuilder();
    }

    public static ClassBuilder forClasses() {
        return new ClassBuilder();
    }

    public static FieldBuilder forFields() {
        return new FieldBuilder();
    }

    public static MethodBuilder forMethods() {
        return new MethodBuilder();
    }

    public static MethodParameterBuilder forMethodParameters() {
        return new MethodParameterBuilder();
    }

    public static RecordComponentBuilder forRecordComponents() {
        return new RecordComponentBuilder();
    }

    public static class DeclarationBuilder
    extends Builder<DeclarationBuilder> {
        DeclarationBuilder() {
            super(null);
        }

        public DeclarationBuilder whenDeclaration(Predicate<Declaration> predicate) {
            Objects.requireNonNull(predicate);
            return (DeclarationBuilder)this.when(ctx -> predicate.test(ctx.declaration()));
        }
    }

    public static class ClassBuilder
    extends Builder<ClassBuilder> {
        ClassBuilder() {
            super(AnnotationTarget.Kind.CLASS);
        }

        public ClassBuilder whenClass(Class<?> clazz) {
            Objects.requireNonNull(clazz);
            return this.whenClass(DotName.createSimple(clazz));
        }

        public ClassBuilder whenClass(DotName name) {
            Objects.requireNonNull(name);
            return this.whenClass((ClassInfo clazz) -> clazz.name().equals(name));
        }

        public ClassBuilder whenClass(Predicate<ClassInfo> predicate) {
            Objects.requireNonNull(predicate);
            return (ClassBuilder)this.when(ctx -> predicate.test(ctx.declaration().asClass()));
        }
    }

    public static class FieldBuilder
    extends Builder<FieldBuilder> {
        FieldBuilder() {
            super(AnnotationTarget.Kind.FIELD);
        }

        public FieldBuilder whenField(Class<?> clazz, String name) {
            Objects.requireNonNull(clazz);
            return this.whenField(DotName.createSimple(clazz), name);
        }

        public FieldBuilder whenField(DotName clazz, String name) {
            Objects.requireNonNull(clazz);
            Objects.requireNonNull(name);
            return this.whenField(field -> field.name().equals(name) && field.declaringClass().name().equals(clazz));
        }

        public FieldBuilder whenField(Predicate<FieldInfo> predicate) {
            Objects.requireNonNull(predicate);
            return (FieldBuilder)this.when(ctx -> predicate.test(ctx.declaration().asField()));
        }
    }

    public static class MethodBuilder
    extends Builder<MethodBuilder> {
        MethodBuilder() {
            super(AnnotationTarget.Kind.METHOD);
        }

        public MethodBuilder whenMethod(Class<?> clazz, String name) {
            Objects.requireNonNull(clazz);
            return this.whenMethod(DotName.createSimple(clazz), name);
        }

        public MethodBuilder whenMethod(DotName clazz, String name) {
            Objects.requireNonNull(clazz);
            Objects.requireNonNull(name);
            return this.whenMethod(method -> method.name().equals(name) && method.declaringClass().name().equals(clazz));
        }

        public MethodBuilder whenMethod(Predicate<MethodInfo> predicate) {
            Objects.requireNonNull(predicate);
            return (MethodBuilder)this.when(ctx -> predicate.test(ctx.declaration().asMethod()));
        }
    }

    public static class MethodParameterBuilder
    extends Builder<MethodParameterBuilder> {
        MethodParameterBuilder() {
            super(AnnotationTarget.Kind.METHOD_PARAMETER);
        }

        public MethodParameterBuilder whenMethodParameter(Class<?> clazz, String name) {
            Objects.requireNonNull(clazz);
            return this.whenMethodParameter(DotName.createSimple(clazz), name);
        }

        public MethodParameterBuilder whenMethodParameter(DotName clazz, String name) {
            Objects.requireNonNull(clazz);
            Objects.requireNonNull(name);
            return this.whenMethodParameter(param -> param.method().name().equals(name) && param.method().declaringClass().name().equals(clazz));
        }

        public MethodParameterBuilder whenMethodParameter(Predicate<MethodParameterInfo> predicate) {
            Objects.requireNonNull(predicate);
            return (MethodParameterBuilder)this.when(ctx -> predicate.test(ctx.declaration().asMethodParameter()));
        }
    }

    public static class RecordComponentBuilder
    extends Builder<RecordComponentBuilder> {
        RecordComponentBuilder() {
            super(AnnotationTarget.Kind.RECORD_COMPONENT);
        }

        public RecordComponentBuilder whenRecordComponent(Class<?> clazz, String name) {
            Objects.requireNonNull(clazz);
            return this.whenRecordComponent(DotName.createSimple(clazz), name);
        }

        public RecordComponentBuilder whenRecordComponent(DotName clazz, String name) {
            Objects.requireNonNull(clazz);
            Objects.requireNonNull(name);
            return this.whenRecordComponent(component -> component.name().equals(name) && component.declaringClass().name().equals(clazz));
        }

        public RecordComponentBuilder whenRecordComponent(Predicate<RecordComponentInfo> predicate) {
            Objects.requireNonNull(predicate);
            return (RecordComponentBuilder)this.when(ctx -> predicate.test(ctx.declaration().asRecordComponent()));
        }
    }

    public static abstract class Builder<THIS extends Builder<THIS>> {
        private final AnnotationTarget.Kind kind;
        private int priority;
        private Predicate<TransformationContext> predicate;

        Builder(AnnotationTarget.Kind kind) {
            this.kind = kind;
            this.priority = 1000;
        }

        public final THIS priority(int priority) {
            this.priority = priority;
            return this.self();
        }

        @SafeVarargs
        private static Predicate<AnnotationInstance> annotationPredicate(Class<? extends Annotation> ... classes) {
            Objects.requireNonNull(classes);
            return annotation -> {
                String annotationName = annotation.name().toString();
                for (Class clazz : classes) {
                    if (!annotationName.equals(clazz.getName())) continue;
                    return true;
                }
                return false;
            };
        }

        private static Predicate<AnnotationInstance> annotationPredicate(DotName ... classes) {
            Objects.requireNonNull(classes);
            return annotation -> {
                DotName annotationName = annotation.name();
                for (DotName clazz : classes) {
                    if (!annotationName.equals(clazz)) continue;
                    return true;
                }
                return false;
            };
        }

        @SafeVarargs
        public final THIS whenAnyMatch(Class<? extends Annotation> ... classes) {
            Objects.requireNonNull(classes);
            return this.whenAnyMatch(Builder.annotationPredicate(classes));
        }

        public final THIS whenAnyMatch(DotName ... classes) {
            Objects.requireNonNull(classes);
            return this.whenAnyMatch(Builder.annotationPredicate(classes));
        }

        public final THIS whenAnyMatch(List<DotName> classes) {
            Objects.requireNonNull(classes);
            return this.whenAnyMatch(classes.toArray(new DotName[0]));
        }

        public final THIS whenAnyMatch(Predicate<AnnotationInstance> predicate) {
            Objects.requireNonNull(predicate);
            return this.when(ctx -> {
                Collection<AnnotationInstance> annotations = ctx.annotations();
                for (AnnotationInstance annotation : annotations) {
                    if (!predicate.test(annotation)) continue;
                    return true;
                }
                return false;
            });
        }

        @SafeVarargs
        public final THIS whenAllMatch(Class<? extends Annotation> ... classes) {
            Objects.requireNonNull(classes);
            return this.whenAllMatch(Builder.annotationPredicate(classes));
        }

        public final THIS whenAllMatch(DotName ... classes) {
            Objects.requireNonNull(classes);
            return this.whenAllMatch(Builder.annotationPredicate(classes));
        }

        public final THIS whenAllMatch(List<DotName> classes) {
            Objects.requireNonNull(classes);
            return this.whenAllMatch(classes.toArray(new DotName[0]));
        }

        public final THIS whenAllMatch(Predicate<AnnotationInstance> predicate) {
            Objects.requireNonNull(predicate);
            return this.when(ctx -> {
                Collection<AnnotationInstance> annotations = ctx.annotations();
                for (AnnotationInstance annotation : annotations) {
                    if (predicate.test(annotation)) continue;
                    return false;
                }
                return true;
            });
        }

        @SafeVarargs
        public final THIS whenNoneMatch(Class<? extends Annotation> ... classes) {
            Objects.requireNonNull(classes);
            return this.whenNoneMatch(Builder.annotationPredicate(classes));
        }

        public final THIS whenNoneMatch(DotName ... classes) {
            Objects.requireNonNull(classes);
            return this.whenNoneMatch(Builder.annotationPredicate(classes));
        }

        public final THIS whenNoneMatch(List<DotName> classes) {
            Objects.requireNonNull(classes);
            return this.whenNoneMatch(classes.toArray(new DotName[0]));
        }

        public final THIS whenNoneMatch(Predicate<AnnotationInstance> predicate) {
            Objects.requireNonNull(predicate);
            return this.when(ctx -> {
                Collection<AnnotationInstance> annotations = ctx.annotations();
                for (AnnotationInstance annotation : annotations) {
                    if (!predicate.test(annotation)) continue;
                    return false;
                }
                return true;
            });
        }

        public THIS when(Predicate<TransformationContext> predicate) {
            Objects.requireNonNull(predicate);
            this.predicate = this.predicate == null ? predicate : this.predicate.and(predicate);
            return this.self();
        }

        public AnnotationTransformation transform(final Consumer<TransformationContext> transformation) {
            Objects.requireNonNull(transformation);
            return new AnnotationTransformation(){

                @Override
                public int priority() {
                    return priority;
                }

                @Override
                public boolean supports(AnnotationTarget.Kind kind) {
                    return kind == null || kind == kind;
                }

                @Override
                public void apply(TransformationContext context) {
                    if (predicate == null || predicate.test(context)) {
                        transformation.accept(context);
                    }
                }
            };
        }

        THIS self() {
            return (THIS)this;
        }
    }

    public static interface TransformationContext {
        public Declaration declaration();

        public Collection<AnnotationInstance> annotations();

        public boolean hasAnnotation(Class<? extends Annotation> var1);

        public boolean hasAnnotation(DotName var1);

        public boolean hasAnnotation(Predicate<AnnotationInstance> var1);

        public void add(Class<? extends Annotation> var1);

        public void add(AnnotationInstance var1);

        public void addAll(AnnotationInstance ... var1);

        public void addAll(Collection<AnnotationInstance> var1);

        public void remove(Predicate<AnnotationInstance> var1);

        public void removeAll();
    }
}

