/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.ResourceVisitOption;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.MappingMatch;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.myfaces.resource.ResourceLoader;
import org.apache.myfaces.resource.ResourceLoaderWrapper;
import org.apache.myfaces.resource.ResourceMeta;
import org.apache.myfaces.util.ExternalContextUtils;

public class FacesJSResourceLoader
extends ResourceLoaderWrapper {
    public static final String SOURCE_MAP_MARKER = "//# sourceMappingURL=";
    private final ResourceLoader delegate;

    public FacesJSResourceLoader(ResourceLoader delegate) {
        this.delegate = delegate;
    }

    public ResourceLoader getWrapped() {
        return this.delegate;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        String extMap = ".map";
        String resourceName = resourceMeta.getResourceName();
        String libraryName = resourceMeta.getLibraryName();
        String mappingLongName = "faces-development.js.map";
        String facesJsShortName = "faces.js";
        String facesJsLongName = "faces-development.js";
        HttpServletRequest req = ExternalContextUtils.getHttpServletRequest(FacesContext.getCurrentInstance().getExternalContext());
        if (!"jakarta.faces".equals(libraryName) || !resourceName.contains("faces.js") && !resourceName.contains("faces-development.js") || resourceName.contains("faces-development.js.map") || req == null) {
            return this.delegate.getResourceInputStream(resourceMeta);
        }
        try (InputStream inputStream = this.delegate.getResourceInputStream(resourceMeta);){
            ByteArrayInputStream byteArrayInputStream;
            try (ByteArrayOutputStream writer = new ByteArrayOutputStream();){
                new BufferedReader(new InputStreamReader(inputStream)).lines().forEach(line -> {
                    if (line.contains(SOURCE_MAP_MARKER)) {
                        return;
                    }
                    try {
                        writer.write(line.getBytes());
                        writer.write("\n".getBytes());
                    }
                    catch (IOException e) {
                        throw new FacesException((Throwable)e);
                    }
                });
                if (FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development)) {
                    Object mappedResourceName = "faces-development.js.map";
                    if (req.getHttpServletMapping().getMappingMatch() == MappingMatch.EXTENSION) {
                        String pattern = req.getHttpServletMapping().getPattern();
                        String extension = pattern.substring(pattern.lastIndexOf("*.") + 1);
                        mappedResourceName = (String)mappedResourceName + extension;
                    }
                    writer.write("\n".getBytes());
                    writer.write(SOURCE_MAP_MARKER.getBytes());
                    writer.write(((String)mappedResourceName).getBytes());
                    writer.write(("?ln=" + libraryName).getBytes());
                }
                byteArrayInputStream = new ByteArrayInputStream(writer.toByteArray());
            }
            return byteArrayInputStream;
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    @Override
    public String getResourceVersion(String path) {
        return this.delegate.getResourceVersion(path);
    }

    @Override
    public String getLibraryVersion(String path) {
        return this.delegate.getLibraryVersion(path);
    }

    @Override
    public URL getResourceURL(ResourceMeta resourceMeta) {
        return this.delegate.getResourceURL(resourceMeta);
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion) {
        return this.delegate.createResourceMeta(prefix, libraryName, libraryVersion, resourceName, resourceVersion);
    }

    @Override
    public ResourceMeta createResourceMeta(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, String contractName) {
        return this.delegate.createResourceMeta(prefix, libraryName, libraryVersion, resourceName, resourceVersion, contractName);
    }

    @Override
    public boolean libraryExists(String libraryName) {
        return this.delegate.libraryExists(libraryName);
    }

    @Override
    public boolean resourceExists(ResourceMeta resourceMeta) {
        return this.delegate.resourceExists(resourceMeta);
    }

    @Override
    public Iterator<String> iterator(FacesContext facesContext, String path, int maxDepth, ResourceVisitOption ... options) {
        return this.delegate.iterator(facesContext, path, maxDepth, options);
    }

    @Override
    public Comparator<String> getVersionComparator() {
        return this.delegate.getVersionComparator();
    }

    @Override
    public void setVersionComparator(Comparator<String> versionComparator) {
        this.delegate.setVersionComparator(versionComparator);
    }

    @Override
    public String getPrefix() {
        return this.delegate.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) {
        this.delegate.setPrefix(prefix);
    }
}

