/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeConstants;

public final class FormatUtils {
    private static final String NO_CONVERSION_PATTERN = "#,##0.###";
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = ThreadLocal.withInitial(() -> {
        DecimalFormat df = new DecimalFormat(NO_CONVERSION_PATTERN);
        df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        return df;
    });
    public static final ZoneOffset DEFAULT_OFFSET = OffsetDateTime.now().getOffset();

    public static String format(TemporalAccessor temporal) {
        return OffsetDateTime.from(temporal).truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static String format(TemporalAccessor temporal, String conversionPattern) {
        return OffsetDateTime.from(temporal).format(DateTimeFormatter.ofPattern(conversionPattern));
    }

    public static String format(long number) {
        return FormatUtils.format(number, NO_CONVERSION_PATTERN);
    }

    public static String format(long number, String conversionPattern) {
        DecimalFormat df = DECIMAL_FORMAT.get();
        String previous = df.toPattern();
        if (!previous.equals(conversionPattern)) {
            df.applyPattern(conversionPattern);
        }
        String formatted = df.format(number);
        if (!previous.equals(conversionPattern)) {
            df.applyPattern(previous);
        }
        return formatted;
    }

    public static String format(double number) {
        return FormatUtils.format(number, NO_CONVERSION_PATTERN);
    }

    public static String format(double number, String conversionPattern) {
        DecimalFormat df = DECIMAL_FORMAT.get();
        String previous = df.toPattern();
        if (!previous.equals(conversionPattern)) {
            df.applyPattern(conversionPattern);
        }
        String formatted = df.format(number);
        if (!previous.equals(conversionPattern)) {
            df.applyPattern(previous);
        }
        return formatted;
    }

    public static OffsetDateTime parseDate(String source) throws DateTimeParseException {
        for (String pattern : SyncopeConstants.DATE_PATTERNS) {
            try {
                return FormatUtils.parseDate(source, pattern);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new DateTimeParseException("Could not parse with any of " + String.valueOf(Arrays.asList(SyncopeConstants.DATE_PATTERNS)), source, 0);
    }

    public static OffsetDateTime parseDate(String source, String conversionPattern) throws DateTimeParseException {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(conversionPattern);
        try {
            if (StringUtils.containsIgnoreCase((CharSequence)conversionPattern, (CharSequence)"Z")) {
                return OffsetDateTime.parse(source, dtf);
            }
            return LocalDateTime.parse(source, dtf).atZone(DEFAULT_OFFSET).toOffsetDateTime();
        }
        catch (DateTimeParseException e) {
            DateTimeParseException dtpe = e;
            try {
                return LocalDate.parse(source, dtf).atStartOfDay(ZoneOffset.UTC).toOffsetDateTime();
            }
            catch (DateTimeParseException e2) {
                dtpe = e2;
                throw dtpe;
            }
        }
    }

    public static Number parseNumber(String source, String conversionPattern) throws ParseException {
        DecimalFormat df = DECIMAL_FORMAT.get();
        df.applyPattern(conversionPattern);
        return df.parse(source);
    }

    public static void clear() {
        DECIMAL_FORMAT.remove();
    }

    private FormatUtils() {
    }
}

