/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.tomcat;

import lombok.Generated;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.x509.X509WebflowAutoConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;

public class X509TomcatServletWebServiceFactoryCustomizer
extends ServletWebServerFactoryCustomizer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509TomcatServletWebServiceFactoryCustomizer.class);
    private final CasConfigurationProperties casProperties;
    private final ServerProperties serverProperties;

    public X509TomcatServletWebServiceFactoryCustomizer(ServerProperties serverProperties, CasConfigurationProperties casProperties) {
        super(serverProperties);
        this.casProperties = casProperties;
        this.serverProperties = serverProperties;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        X509WebflowAutoConfigurationProperties webflow = this.casProperties.getAuthn().getX509().getWebflow();
        if (factory instanceof TomcatServletWebServerFactory && webflow.getPort() > 0) {
            TomcatServletWebServerFactory tomcat = (TomcatServletWebServerFactory)factory;
            LOGGER.debug("Creating X509 configuration for the tomcat container...");
            Connector connector = new Connector("HTTP/1.1");
            connector.setPort(webflow.getPort());
            connector.setScheme("https");
            connector.setSecure(true);
            connector.setAllowTrace(true);
            AbstractHttp11JsseProtocol protocol = (AbstractHttp11JsseProtocol)connector.getProtocolHandler();
            protocol.setSSLEnabled(true);
            protocol.setSslProtocol("TLS");
            protocol.setClientAuth(webflow.getClientAuth());
            protocol.setKeystoreFile(this.serverProperties.getSsl().getKeyStore());
            protocol.setKeystorePass(this.serverProperties.getSsl().getKeyStorePassword());
            protocol.setTruststoreFile(this.serverProperties.getSsl().getTrustStore());
            protocol.setTruststorePass(this.serverProperties.getSsl().getTrustStorePassword());
            tomcat.addAdditionalTomcatConnectors(new Connector[]{connector});
        }
    }
}

