/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.X509CertificateExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.X509CertificateCredentialsNonInteractiveAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class X509CertificateCredentialsRequestHeaderAction
extends X509CertificateCredentialsNonInteractiveAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509CertificateCredentialsRequestHeaderAction.class);
    private final X509CertificateExtractor x509CertificateExtractor;

    public X509CertificateCredentialsRequestHeaderAction(CasDelegatingWebflowEventResolver eventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, X509CertificateExtractor x509CertificateExtractor, CasConfigurationProperties casProperties) {
        super(eventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy, casProperties);
        this.x509CertificateExtractor = x509CertificateExtractor;
    }

    @Override
    protected Credential constructCredentialsFromRequest(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        if (context.getRequestScope().contains("X509CertificateAuthenticationError")) {
            LOGGER.debug("Not getting certificates from header because error found in the request.");
            return null;
        }
        Credential x509Credential = super.constructCredentialsFromRequest(context);
        if (x509Credential != null) {
            return x509Credential;
        }
        if (this.x509CertificateExtractor != null) {
            X509Certificate[] certFromHeader = this.x509CertificateExtractor.extract(request);
            if (certFromHeader != null) {
                LOGGER.debug("Certificate found in HTTP request via [{}]", (Object)this.x509CertificateExtractor.getClass().getName());
                return new X509CertificateCredential(certFromHeader);
            }
            LOGGER.debug("Certificates not found in request header.");
        } else {
            LOGGER.trace("No certificate extractor was configured");
        }
        return null;
    }

    @Override
    protected void onError(RequestContext requestContext) {
        WebUtils.putCasLoginFormViewable((RequestContext)requestContext, (WebUtils.isCasLoginFormSetToViewable((RequestContext)requestContext) || this.casProperties.getAuthn().getX509().isMixedMode() ? 1 : 0) != 0);
        requestContext.getRequestScope().put("X509CertificateAuthenticationError", (Object)"true");
    }
}

