/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDoubleBits;
import com.upokecenter.cbor.CBOREInteger;
import com.upokecenter.cbor.CBORExtendedDecimal;
import com.upokecenter.cbor.CBORExtendedFloat;
import com.upokecenter.cbor.CBORExtendedRational;
import com.upokecenter.cbor.CBORInteger;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

public final class CBORNumber
implements Comparable<CBORNumber> {
    private static final ICBORNumber[] NumberInterfaces = new ICBORNumber[]{new CBORInteger(), new CBORDoubleBits(), new CBOREInteger(), new CBORExtendedDecimal(), new CBORExtendedFloat(), new CBORExtendedRational()};
    private final NumberKind kind;
    private final Object value;

    CBORNumber(NumberKind kind, Object value) {
        this.kind = kind;
        this.value = value;
    }

    ICBORNumber GetNumberInterface() {
        return CBORNumber.GetNumberInterface(this.kind);
    }

    static ICBORNumber GetNumberInterface(CBORObject obj) {
        CBORNumber num = CBORNumber.FromCBORObject(obj);
        return num == null ? null : num.GetNumberInterface();
    }

    Object GetValue() {
        return this.value;
    }

    static ICBORNumber GetNumberInterface(NumberKind kind) {
        switch (kind) {
            case Integer: {
                return NumberInterfaces[0];
            }
            case Double: {
                return NumberInterfaces[1];
            }
            case EInteger: {
                return NumberInterfaces[2];
            }
            case EDecimal: {
                return NumberInterfaces[3];
            }
            case EFloat: {
                return NumberInterfaces[4];
            }
            case ERational: {
                return NumberInterfaces[5];
            }
        }
        throw new IllegalStateException();
    }

    public CBORObject ToCBORObject() {
        return CBORObject.FromObject(this.value);
    }

    public final int signum() {
        return this.IsNaN() ? (this.IsNegative() ? -1 : 1) : this.GetNumberInterface().Sign(this.value);
    }

    static boolean IsNumber(CBORObject o) {
        if (CBORNumber.IsUntaggedInteger(o)) {
            return true;
        }
        if (!o.isTagged() && o.getType() == CBORType.FloatingPoint) {
            return true;
        }
        if (o.HasOneTag(2) || o.HasOneTag(3)) {
            return o.getType() == CBORType.ByteString;
        }
        if (o.HasOneTag(4) || o.HasOneTag(5) || o.HasOneTag(264) || o.HasOneTag(265) || o.HasOneTag(268) || o.HasOneTag(269)) {
            return CBORNumber.CheckBigFracToNumber(o, o.getMostOuterTag().ToInt32Checked());
        }
        if (o.HasOneTag(30) || o.HasOneTag(270)) {
            return CBORNumber.CheckRationalToNumber(o, o.getMostOuterTag().ToInt32Checked());
        }
        return false;
    }

    public static CBORNumber FromCBORObject(CBORObject o) {
        if (o == null) {
            return null;
        }
        if (CBORNumber.IsUntaggedInteger(o)) {
            if (o.CanValueFitInInt64()) {
                return new CBORNumber(NumberKind.Integer, o.AsInt64Value());
            }
            return new CBORNumber(NumberKind.EInteger, o.AsEIntegerValue());
        }
        if (!o.isTagged() && o.getType() == CBORType.FloatingPoint) {
            return CBORNumber.FromDoubleBits(o.AsDoubleBits());
        }
        if (o.HasOneTag(2) || o.HasOneTag(3)) {
            return CBORNumber.BignumToNumber(o);
        }
        if (o.HasOneTag(4) || o.HasOneTag(5) || o.HasOneTag(264) || o.HasOneTag(265) || o.HasOneTag(268) || o.HasOneTag(269)) {
            return CBORNumber.BigFracToNumber(o, o.getMostOuterTag().ToInt32Checked());
        }
        if (o.HasOneTag(30) || o.HasOneTag(270)) {
            return CBORNumber.RationalToNumber(o, o.getMostOuterTag().ToInt32Checked());
        }
        return null;
    }

    private static boolean IsUntaggedInteger(CBORObject o) {
        return !o.isTagged() && o.getType() == CBORType.Integer;
    }

    private static boolean IsUntaggedIntegerOrBignum(CBORObject o) {
        return CBORNumber.IsUntaggedInteger(o) || (o.HasOneTag(2) || o.HasOneTag(3)) && o.getType() == CBORType.ByteString;
    }

    private static EInteger IntegerOrBignum(CBORObject o) {
        if (CBORNumber.IsUntaggedInteger(o)) {
            return o.AsEIntegerValue();
        }
        CBORNumber n = CBORNumber.BignumToNumber(o);
        return n.GetNumberInterface().AsEInteger(n.GetValue());
    }

    private static CBORNumber RationalToNumber(CBORObject o, int tagName) {
        if (o.getType() != CBORType.Array) {
            return null;
        }
        if (tagName == 270) {
            if (o.size() != 3) {
                return null;
            }
            if (!CBORNumber.IsUntaggedInteger(o.get(2))) {
                return null;
            }
        } else if (o.size() != 2) {
            return null;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(0))) {
            return null;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(1))) {
            return null;
        }
        EInteger numerator = CBORNumber.IntegerOrBignum(o.get(0));
        EInteger denominator = CBORNumber.IntegerOrBignum(o.get(1));
        if (denominator.signum() <= 0) {
            return null;
        }
        ERational erat = ERational.Create((EInteger)numerator, (EInteger)denominator);
        if (tagName == 270) {
            if (numerator.signum() < 0) {
                return null;
            }
            if (!o.get(2).CanValueFitInInt32()) {
                return null;
            }
            int options = o.get(2).AsInt32Value();
            switch (options) {
                case 0: {
                    break;
                }
                case 1: {
                    erat = erat.Negate();
                    break;
                }
                case 2: {
                    if (!numerator.isZero() || denominator.compareTo(1) != 0) {
                        return null;
                    }
                    erat = ERational.PositiveInfinity;
                    break;
                }
                case 3: {
                    if (!numerator.isZero() || denominator.compareTo(1) != 0) {
                        return null;
                    }
                    erat = ERational.NegativeInfinity;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (denominator.compareTo(1) != 0) {
                        return null;
                    }
                    erat = ERational.CreateNaN((EInteger)numerator, (options >= 6 ? 1 : 0) != 0, (options == 5 || options == 7 ? 1 : 0) != 0);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return CBORNumber.FromObject(erat);
    }

    private static boolean CheckRationalToNumber(CBORObject o, int tagName) {
        if (o.getType() != CBORType.Array) {
            return false;
        }
        if (tagName == 270) {
            if (o.size() != 3) {
                return false;
            }
            if (!CBORNumber.IsUntaggedInteger(o.get(2))) {
                return false;
            }
        } else if (o.size() != 2) {
            return false;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(0))) {
            return false;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(1))) {
            return false;
        }
        EInteger denominator = CBORNumber.IntegerOrBignum(o.get(1));
        if (denominator.signum() <= 0) {
            return false;
        }
        if (tagName == 270) {
            EInteger numerator = CBORNumber.IntegerOrBignum(o.get(0));
            if (numerator.signum() < 0 || !o.get(2).CanValueFitInInt32()) {
                return false;
            }
            int options = o.get(2).AsInt32Value();
            switch (options) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: 
                case 3: {
                    return numerator.isZero() && denominator.compareTo(1) == 0;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return denominator.compareTo(1) == 0;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean CheckBigFracToNumber(CBORObject o, int tagName) {
        if (o.getType() != CBORType.Array) {
            return false;
        }
        if (tagName == 268 || tagName == 269) {
            if (o.size() != 3) {
                return false;
            }
            if (!CBORNumber.IsUntaggedInteger(o.get(2))) {
                return false;
            }
        } else if (o.size() != 2) {
            return false;
        }
        if (tagName == 4 || tagName == 5 ? !CBORNumber.IsUntaggedInteger(o.get(0)) : !CBORNumber.IsUntaggedIntegerOrBignum(o.get(0))) {
            return false;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(1))) {
            return false;
        }
        if (tagName == 268 || tagName == 269) {
            EInteger exponent = CBORNumber.IntegerOrBignum(o.get(0));
            EInteger mantissa = CBORNumber.IntegerOrBignum(o.get(1));
            if (mantissa.signum() < 0 || !o.get(2).CanValueFitInInt32()) {
                return false;
            }
            int options = o.get(2).AsInt32Value();
            switch (options) {
                case 0: 
                case 1: {
                    return true;
                }
                case 2: 
                case 3: {
                    return exponent.isZero() && mantissa.isZero();
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return exponent.isZero();
                }
            }
            return false;
        }
        return true;
    }

    private static CBORNumber BigFracToNumber(CBORObject o, int tagName) {
        EFloat efloat;
        if (o.getType() != CBORType.Array) {
            return null;
        }
        if (tagName == 268 || tagName == 269) {
            if (o.size() != 3) {
                return null;
            }
            if (!CBORNumber.IsUntaggedInteger(o.get(2))) {
                return null;
            }
        } else if (o.size() != 2) {
            return null;
        }
        if (tagName == 4 || tagName == 5 ? !CBORNumber.IsUntaggedInteger(o.get(0)) : !CBORNumber.IsUntaggedIntegerOrBignum(o.get(0))) {
            return null;
        }
        if (!CBORNumber.IsUntaggedIntegerOrBignum(o.get(1))) {
            return null;
        }
        EInteger exponent = CBORNumber.IntegerOrBignum(o.get(0));
        EInteger mantissa = CBORNumber.IntegerOrBignum(o.get(1));
        boolean isdec = tagName == 4 || tagName == 264 || tagName == 268;
        EDecimal edec = isdec ? EDecimal.Create((EInteger)mantissa, (EInteger)exponent) : null;
        EFloat eFloat = efloat = !isdec ? EFloat.Create((EInteger)mantissa, (EInteger)exponent) : null;
        if (tagName == 268 || tagName == 269) {
            if (mantissa.signum() < 0) {
                return null;
            }
            if (!o.get(2).CanValueFitInInt32()) {
                return null;
            }
            int options = o.get(2).AsInt32Value();
            switch (options) {
                case 0: {
                    break;
                }
                case 1: {
                    if (isdec) {
                        edec = edec.Negate();
                        break;
                    }
                    efloat = efloat.Negate();
                    break;
                }
                case 2: {
                    if (!exponent.isZero() || !mantissa.isZero()) {
                        return null;
                    }
                    if (isdec) {
                        edec = EDecimal.PositiveInfinity;
                        break;
                    }
                    efloat = EFloat.PositiveInfinity;
                    break;
                }
                case 3: {
                    if (!exponent.isZero() || !mantissa.isZero()) {
                        return null;
                    }
                    if (isdec) {
                        edec = EDecimal.NegativeInfinity;
                        break;
                    }
                    efloat = EFloat.NegativeInfinity;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (!exponent.isZero()) {
                        return null;
                    }
                    if (isdec) {
                        edec = EDecimal.CreateNaN((EInteger)mantissa, (options >= 6 ? 1 : 0) != 0, (options == 5 || options == 7 ? 1 : 0) != 0, null);
                        break;
                    }
                    efloat = EFloat.CreateNaN((EInteger)mantissa, (options >= 6 ? 1 : 0) != 0, (options == 5 || options == 7 ? 1 : 0) != 0, null);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        if (isdec) {
            return CBORNumber.FromObject(edec);
        }
        return CBORNumber.FromObject(efloat);
    }

    public final NumberKind getKind() {
        return this.kind;
    }

    public boolean CanTruncatedIntFitInInt32() {
        return this.GetNumberInterface().CanTruncatedIntFitInInt32(this.GetValue());
    }

    public boolean CanTruncatedIntFitInInt64() {
        switch (this.kind) {
            case Integer: {
                return true;
            }
        }
        return this.GetNumberInterface().CanTruncatedIntFitInInt64(this.GetValue());
    }

    public boolean CanTruncatedIntFitInUInt64() {
        return this.GetNumberInterface().CanTruncatedIntFitInUInt64(this.GetValue());
    }

    public boolean CanFitInSingle() {
        return this.GetNumberInterface().CanFitInSingle(this.GetValue());
    }

    public boolean CanFitInDouble() {
        return this.GetNumberInterface().CanFitInDouble(this.GetValue());
    }

    public boolean IsFinite() {
        switch (this.kind) {
            case Integer: 
            case EInteger: {
                return true;
            }
        }
        return !this.IsInfinity() && !this.IsNaN();
    }

    public boolean IsInteger() {
        switch (this.kind) {
            case Integer: 
            case EInteger: {
                return true;
            }
        }
        return this.GetNumberInterface().IsIntegral(this.GetValue());
    }

    public boolean IsNegative() {
        return this.GetNumberInterface().IsNegative(this.GetValue());
    }

    public boolean IsZero() {
        switch (this.kind) {
            case Integer: {
                long thisValue = (Long)this.value;
                return thisValue == 0L;
            }
        }
        return this.GetNumberInterface().IsNumberZero(this.GetValue());
    }

    public EInteger ToEInteger() {
        return this.GetNumberInterface().AsEInteger(this.GetValue());
    }

    public EInteger ToEIntegerIfExact() {
        if (!this.IsInteger()) {
            throw new ArithmeticException("Not an integer");
        }
        return this.ToEInteger();
    }

    public byte ToByteChecked() {
        if (!this.IsFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.ToEInteger().ToByteChecked();
    }

    public byte ToByteUnchecked() {
        return this.IsFinite() ? this.ToEInteger().ToByteUnchecked() : (byte)0;
    }

    public byte ToByteIfExact() {
        if (!this.IsFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.IsZero()) {
            return 0;
        }
        if (this.IsNegative()) {
            throw new ArithmeticException("Value out of range");
        }
        return this.ToEIntegerIfExact().ToByteChecked();
    }

    public static CBORNumber FromByte(byte inputByte) {
        int val = inputByte & 0xFF;
        return CBORNumber.FromObject((long)val);
    }

    public short ToInt16Checked() {
        if (!this.IsFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.ToEInteger().ToInt16Checked();
    }

    public short ToInt16Unchecked() {
        return this.IsFinite() ? this.ToEInteger().ToInt16Unchecked() : (short)0;
    }

    public short ToInt16IfExact() {
        if (!this.IsFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.IsZero() ? (short)0 : this.ToEIntegerIfExact().ToInt16Checked();
    }

    public static CBORNumber FromInt16(short inputInt16) {
        short val = inputInt16;
        return CBORNumber.FromObject((long)val);
    }

    public int ToInt32Checked() {
        if (!this.IsFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.ToEInteger().ToInt32Checked();
    }

    public int ToInt32Unchecked() {
        return this.IsFinite() ? this.ToEInteger().ToInt32Unchecked() : 0;
    }

    public int ToInt32IfExact() {
        if (!this.IsFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.IsZero() ? 0 : this.ToEIntegerIfExact().ToInt32Checked();
    }

    public long ToInt64Checked() {
        if (!this.IsFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.ToEInteger().ToInt64Checked();
    }

    public long ToInt64Unchecked() {
        return this.IsFinite() ? this.ToEInteger().ToInt64Unchecked() : 0L;
    }

    public long ToInt64IfExact() {
        if (!this.IsFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.IsZero() ? 0L : this.ToEIntegerIfExact().ToInt64Checked();
    }

    private static CBORNumber BignumToNumber(CBORObject o) {
        EInteger bi;
        if (o.getType() != CBORType.ByteString) {
            return null;
        }
        boolean negative = o.HasMostInnerTag(3);
        byte[] data = o.GetByteString();
        if (data.length <= 7) {
            long x = 0L;
            for (int i = 0; i < data.length; ++i) {
                x <<= 8;
                x |= (long)data[i] & 0xFFL;
            }
            if (negative) {
                x = -x;
                --x;
            }
            return new CBORNumber(NumberKind.Integer, x);
        }
        int neededLength = data.length;
        boolean extended = false;
        if ((data[0] >> 7 & 1) != 0) {
            ++neededLength;
            extended = true;
        }
        if (extended || negative) {
            byte[] bytes = new byte[neededLength];
            System.arraycopy(data, 0, bytes, neededLength - data.length, data.length);
            if (negative) {
                int i = neededLength - data.length;
                while (i < neededLength) {
                    int n = i++;
                    bytes[n] = ~bytes[n];
                }
            }
            if (extended) {
                bytes[0] = negative ? -1 : 0;
            }
            bi = EInteger.FromBytes((byte[])bytes, (boolean)false);
        } else {
            bi = EInteger.FromBytes((byte[])data, (boolean)false);
        }
        if (bi.CanFitInInt64()) {
            return new CBORNumber(NumberKind.Integer, bi.ToInt64Checked());
        }
        return new CBORNumber(NumberKind.EInteger, bi);
    }

    public String toString() {
        switch (this.kind) {
            case Integer: {
                long longItem = (Long)this.value;
                return CBORUtilities.LongToString(longItem);
            }
            case Double: {
                long longItem = (Long)this.value;
                return CBORUtilities.DoubleBitsToString(longItem);
            }
        }
        return this.value == null ? "" : this.value.toString();
    }

    String ToJSONString() {
        switch (this.kind) {
            case Double: {
                long f = (Long)this.value;
                if (!CBORUtilities.DoubleBitsFinite(f)) {
                    return "null";
                }
                String dblString = CBORUtilities.DoubleBitsToString(f);
                return CBORUtilities.TrimDotZero(dblString);
            }
            case Integer: {
                long longItem = (Long)this.value;
                return CBORUtilities.LongToString(longItem);
            }
            case EInteger: {
                Object eiobj = this.value;
                return ((EInteger)eiobj).toString();
            }
            case EDecimal: {
                EDecimal dec = (EDecimal)this.value;
                if (dec.IsInfinity() || dec.IsNaN()) {
                    return "null";
                }
                return dec.toString();
            }
            case EFloat: {
                EFloat flo = (EFloat)this.value;
                if (flo.IsInfinity() || flo.IsNaN()) {
                    return "null";
                }
                if (flo.isFinite() && flo.getExponent().Abs().compareTo(EInteger.FromInt64((long)2500L)) > 0) {
                    long f = flo.ToDoubleBits();
                    if (!CBORUtilities.DoubleBitsFinite(f)) {
                        return "null";
                    }
                    String dblString = CBORUtilities.DoubleBitsToString(f);
                    return CBORUtilities.TrimDotZero(dblString);
                }
                return flo.toString();
            }
            case ERational: {
                ERational dec = (ERational)this.value;
                EDecimal f = dec.ToEDecimalExactIfPossible(EContext.Decimal128.WithUnlimitedExponents());
                if (!f.isFinite()) {
                    return "null";
                }
                return f.toString();
            }
        }
        throw new IllegalStateException();
    }

    static CBORNumber FromObject(int intValue) {
        return new CBORNumber(NumberKind.Integer, intValue);
    }

    static CBORNumber FromObject(long longValue) {
        return new CBORNumber(NumberKind.Integer, longValue);
    }

    static CBORNumber FromDoubleBits(long doubleBits) {
        return new CBORNumber(NumberKind.Double, doubleBits);
    }

    static CBORNumber FromObject(EInteger eivalue) {
        return new CBORNumber(NumberKind.EInteger, eivalue);
    }

    static CBORNumber FromObject(EFloat value) {
        return new CBORNumber(NumberKind.EFloat, value);
    }

    static CBORNumber FromObject(EDecimal value) {
        return new CBORNumber(NumberKind.EDecimal, value);
    }

    static CBORNumber FromObject(ERational value) {
        return new CBORNumber(NumberKind.ERational, value);
    }

    public boolean CanFitInInt32() {
        Object gv;
        ICBORNumber icn = this.GetNumberInterface();
        if (!icn.CanFitInInt64(gv = this.GetValue())) {
            return false;
        }
        long v = icn.AsInt64(gv);
        return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE;
    }

    public boolean CanFitInInt64() {
        return this.GetNumberInterface().CanFitInInt64(this.GetValue());
    }

    public boolean CanFitInUInt64() {
        return this.GetNumberInterface().CanFitInUInt64(this.GetValue());
    }

    public boolean IsInfinity() {
        return this.GetNumberInterface().IsInfinity(this.GetValue());
    }

    public boolean IsPositiveInfinity() {
        return this.GetNumberInterface().IsPositiveInfinity(this.GetValue());
    }

    public boolean IsNegativeInfinity() {
        return this.GetNumberInterface().IsNegativeInfinity(this.GetValue());
    }

    public boolean IsNaN() {
        return this.GetNumberInterface().IsNaN(this.GetValue());
    }

    public EDecimal ToEDecimal() {
        return this.GetNumberInterface().AsEDecimal(this.GetValue());
    }

    public EFloat ToEFloat() {
        return this.GetNumberInterface().AsEFloat(this.GetValue());
    }

    public ERational ToERational() {
        return this.GetNumberInterface().AsERational(this.GetValue());
    }

    public CBORNumber Abs() {
        switch (this.kind) {
            case Integer: {
                long longValue = (Long)this.value;
                if (longValue == Long.MIN_VALUE) {
                    return CBORNumber.FromObject(EInteger.FromInt64((long)longValue).Negate());
                }
                return longValue >= 0L ? this : new CBORNumber(this.kind, Math.abs(longValue));
            }
            case EInteger: {
                EInteger eivalue = (EInteger)this.value;
                return eivalue.signum() >= 0 ? this : CBORNumber.FromObject(eivalue.Abs());
            }
        }
        return new CBORNumber(this.kind, this.GetNumberInterface().Abs(this.GetValue()));
    }

    public CBORNumber Negate() {
        switch (this.kind) {
            case Integer: {
                long longValue = (Long)this.value;
                if (longValue == 0L) {
                    return CBORNumber.FromObject(EDecimal.NegativeZero);
                }
                if (longValue == Long.MIN_VALUE) {
                    return CBORNumber.FromObject(EInteger.FromInt64((long)longValue).Negate());
                }
                return new CBORNumber(this.kind, -longValue);
            }
            case EInteger: {
                EInteger eiValue = (EInteger)this.value;
                if (eiValue.isZero()) {
                    return CBORNumber.FromObject(EDecimal.NegativeZero);
                }
                return CBORNumber.FromObject(eiValue.Negate());
            }
        }
        return new CBORNumber(this.kind, this.GetNumberInterface().Negate(this.GetValue()));
    }

    private static ERational CheckOverflow(ERational e1, ERational e2, ERational eresult) {
        if (e1.isFinite() && e2.isFinite() && eresult.IsNaN()) {
            throw new OutOfMemoryError("Result might be too big to fit in memory");
        }
        return eresult;
    }

    private static EDecimal CheckOverflow(EDecimal e1, EDecimal e2, EDecimal eresult) {
        if (e1.isFinite() && e2.isFinite() && eresult.IsNaN()) {
            throw new OutOfMemoryError("Result might be too big to fit in memory");
        }
        return eresult;
    }

    private static EFloat CheckOverflow(EFloat e1, EFloat e2, EFloat eresult) {
        if (e1.isFinite() && e2.isFinite() && eresult.IsNaN()) {
            throw new OutOfMemoryError("Result might be too big to fit in memory");
        }
        return eresult;
    }

    private static NumberKind GetConvertKind(CBORNumber a, CBORNumber b) {
        NumberKind typeA = a.kind;
        NumberKind typeB = b.kind;
        NumberKind convertKind = NumberKind.EInteger;
        convertKind = !a.IsFinite() ? (typeB == NumberKind.Integer || typeB == NumberKind.EInteger ? (typeA == NumberKind.Double ? NumberKind.EFloat : typeA) : (typeB == NumberKind.Double ? NumberKind.EFloat : typeB)) : (!b.IsFinite() ? (typeA == NumberKind.Integer || typeA == NumberKind.EInteger ? (typeB == NumberKind.Double ? NumberKind.EFloat : typeB) : (typeA == NumberKind.Double ? NumberKind.EFloat : typeA)) : (typeA == NumberKind.ERational || typeB == NumberKind.ERational ? NumberKind.ERational : (typeA == NumberKind.EDecimal || typeB == NumberKind.EDecimal ? NumberKind.EDecimal : (typeA == NumberKind.EFloat || typeB == NumberKind.EFloat || typeA == NumberKind.Double || typeB == NumberKind.Double ? NumberKind.EFloat : NumberKind.EInteger))));
        return convertKind;
    }

    public CBORNumber Add(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        CBORNumber a = this;
        Object objA = a.value;
        Object objB = b.value;
        NumberKind typeA = a.kind;
        NumberKind typeB = b.kind;
        if (typeA == NumberKind.Integer && typeB == NumberKind.Integer) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueA < 0L && valueB < Long.MIN_VALUE - valueA || valueA > 0L && valueB > Long.MAX_VALUE - valueA) {
                return CBORNumber.FromObject(EInteger.FromInt64((long)valueA).Add(EInteger.FromInt64((long)valueB)));
            }
            return new CBORNumber(NumberKind.Integer, valueA + valueB);
        }
        NumberKind convertKind = CBORNumber.GetConvertKind(a, b);
        if (convertKind == NumberKind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsERational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsERational(objB);
            return new CBORNumber(NumberKind.ERational, CBORNumber.CheckOverflow(e1, e2, e1.Add(e2)));
        }
        if (convertKind == NumberKind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsEDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsEDecimal(objB);
            return new CBORNumber(NumberKind.EDecimal, CBORNumber.CheckOverflow(e1, e2, e1.Add(e2)));
        }
        if (convertKind == NumberKind.EFloat) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsEFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsEFloat(objB);
            return new CBORNumber(NumberKind.EFloat, CBORNumber.CheckOverflow(e1, e2, e1.Add(e2)));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        return new CBORNumber(NumberKind.EInteger, b1.Add(b2));
    }

    public CBORNumber Subtract(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        CBORNumber a = this;
        Object objA = a.value;
        Object objB = b.value;
        NumberKind typeA = a.kind;
        NumberKind typeB = b.kind;
        if (typeA == NumberKind.Integer && typeB == NumberKind.Integer) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueB < 0L && Long.MAX_VALUE + valueB < valueA || valueB > 0L && Long.MIN_VALUE + valueB > valueA) {
                return CBORNumber.FromObject(EInteger.FromInt64((long)valueA).Subtract(EInteger.FromInt64((long)valueB)));
            }
            return new CBORNumber(NumberKind.Integer, valueA - valueB);
        }
        NumberKind convertKind = CBORNumber.GetConvertKind(a, b);
        if (convertKind == NumberKind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsERational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsERational(objB);
            return new CBORNumber(NumberKind.ERational, CBORNumber.CheckOverflow(e1, e2, e1.Subtract(e2)));
        }
        if (convertKind == NumberKind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsEDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsEDecimal(objB);
            return new CBORNumber(NumberKind.EDecimal, CBORNumber.CheckOverflow(e1, e2, e1.Subtract(e2)));
        }
        if (convertKind == NumberKind.EFloat) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsEFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsEFloat(objB);
            return new CBORNumber(NumberKind.EFloat, CBORNumber.CheckOverflow(e1, e2, e1.Subtract(e2)));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        return new CBORNumber(NumberKind.EInteger, b1.Subtract(b2));
    }

    public CBORNumber Multiply(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        CBORNumber a = this;
        Object objA = a.value;
        Object objB = b.value;
        NumberKind typeA = a.kind;
        NumberKind typeB = b.kind;
        if (typeA == NumberKind.Integer && typeB == NumberKind.Integer) {
            boolean bpos;
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            boolean apos = valueA > 0L;
            boolean bl = bpos = valueB > 0L;
            if (apos && (!bpos && Long.MIN_VALUE / valueA > valueB || bpos && valueA > Long.MAX_VALUE / valueB) || !apos && (!bpos && valueA != 0L && Long.MAX_VALUE / valueA > valueB || bpos && valueA < Long.MIN_VALUE / valueB)) {
                EInteger bvalueA = EInteger.FromInt64((long)valueA);
                EInteger bvalueB = EInteger.FromInt64((long)valueB);
                return CBORNumber.FromObject(bvalueA.Multiply(bvalueB));
            }
            return CBORNumber.FromObject(valueA * valueB);
        }
        NumberKind convertKind = CBORNumber.GetConvertKind(a, b);
        if (convertKind == NumberKind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsERational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsERational(objB);
            return CBORNumber.FromObject(CBORNumber.CheckOverflow(e1, e2, e1.Multiply(e2)));
        }
        if (convertKind == NumberKind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsEDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsEDecimal(objB);
            return CBORNumber.FromObject(CBORNumber.CheckOverflow(e1, e2, e1.Multiply(e2)));
        }
        if (convertKind == NumberKind.EFloat) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsEFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsEFloat(objB);
            return new CBORNumber(NumberKind.EFloat, CBORNumber.CheckOverflow(e1, e2, e1.Multiply(e2)));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        return new CBORNumber(NumberKind.EInteger, b1.Multiply(b2));
    }

    public CBORNumber Divide(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        CBORNumber a = this;
        Object objA = a.value;
        Object objB = b.value;
        NumberKind typeA = a.kind;
        NumberKind typeB = b.kind;
        if (typeA == NumberKind.Integer && typeB == NumberKind.Integer) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            if (valueB == 0L) {
                return valueA == 0L ? CBORNumber.FromObject(EDecimal.NaN) : (valueA < 0L ? CBORNumber.FromObject(EDecimal.NegativeInfinity) : CBORNumber.FromObject(EDecimal.PositiveInfinity));
            }
            if (valueA == Long.MIN_VALUE && valueB == -1L) {
                return new CBORNumber(NumberKind.Integer, valueA).Negate();
            }
            long quo = valueA / valueB;
            long rem = valueA - quo * valueB;
            return rem == 0L ? new CBORNumber(NumberKind.Integer, quo) : new CBORNumber(NumberKind.ERational, ERational.Create((EInteger)EInteger.FromInt64((long)valueA), (EInteger)EInteger.FromInt64((long)valueB)));
        }
        NumberKind convertKind = CBORNumber.GetConvertKind(a, b);
        if (convertKind == NumberKind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsERational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsERational(objB);
            return new CBORNumber(NumberKind.ERational, CBORNumber.CheckOverflow(e1, e2, e1.Divide(e2)));
        }
        if (convertKind == NumberKind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsEDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsEDecimal(objB);
            if (e1.isZero() && e2.isZero()) {
                return new CBORNumber(NumberKind.EDecimal, EDecimal.NaN);
            }
            EDecimal eret = e1.Divide(e2, null);
            if (!e1.isFinite() || !e2.isFinite() || eret.isFinite()) {
                return new CBORNumber(NumberKind.EDecimal, eret);
            }
            ERational er1 = CBORNumber.GetNumberInterface(typeA).AsERational(objA);
            ERational er2 = CBORNumber.GetNumberInterface(typeB).AsERational(objB);
            return new CBORNumber(NumberKind.ERational, CBORNumber.CheckOverflow(er1, er2, er1.Divide(er2)));
        }
        if (convertKind == NumberKind.EFloat) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsEFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsEFloat(objB);
            if (e1.isZero() && e2.isZero()) {
                return CBORNumber.FromObject(EDecimal.NaN);
            }
            EFloat eret = e1.Divide(e2, null);
            if (!e1.isFinite() || !e2.isFinite() || eret.isFinite()) {
                return CBORNumber.FromObject(eret);
            }
            ERational er1 = CBORNumber.GetNumberInterface(typeA).AsERational(objA);
            ERational er2 = CBORNumber.GetNumberInterface(typeB).AsERational(objB);
            return new CBORNumber(NumberKind.ERational, CBORNumber.CheckOverflow(er1, er2, er1.Divide(er2)));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        if (b2.isZero()) {
            return b1.isZero() ? CBORNumber.FromObject(EDecimal.NaN) : (b1.signum() < 0 ? CBORNumber.FromObject(EDecimal.NegativeInfinity) : CBORNumber.FromObject(EDecimal.PositiveInfinity));
        }
        EInteger[] divrem = b1.DivRem(b2);
        EInteger bigquo = divrem[0];
        EInteger bigrem = divrem[1];
        return bigrem.isZero() ? CBORNumber.FromObject(bigquo) : new CBORNumber(NumberKind.ERational, ERational.Create((EInteger)b1, (EInteger)b2));
    }

    public CBORNumber Remainder(CBORNumber b) {
        if (b == null) {
            throw new NullPointerException("b");
        }
        Object objA = this.value;
        Object objB = b.value;
        NumberKind typeA = this.kind;
        NumberKind typeB = b.kind;
        if (typeA == NumberKind.Integer && typeB == NumberKind.Integer) {
            long valueA = (Long)objA;
            long valueB = (Long)objB;
            return valueA == Long.MIN_VALUE && valueB == -1L ? CBORNumber.FromObject(0) : CBORNumber.FromObject(valueA % valueB);
        }
        NumberKind convertKind = CBORNumber.GetConvertKind(this, b);
        if (convertKind == NumberKind.ERational) {
            ERational e1 = CBORNumber.GetNumberInterface(typeA).AsERational(objA);
            ERational e2 = CBORNumber.GetNumberInterface(typeB).AsERational(objB);
            return CBORNumber.FromObject(CBORNumber.CheckOverflow(e1, e2, e1.Remainder(e2)));
        }
        if (convertKind == NumberKind.EDecimal) {
            EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsEDecimal(objA);
            EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsEDecimal(objB);
            return CBORNumber.FromObject(CBORNumber.CheckOverflow(e1, e2, e1.Remainder(e2, null)));
        }
        if (convertKind == NumberKind.EFloat) {
            EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsEFloat(objA);
            EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsEFloat(objB);
            return CBORNumber.FromObject(CBORNumber.CheckOverflow(e1, e2, e1.Remainder(e2, null)));
        }
        EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
        EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
        return CBORNumber.FromObject(b1.Remainder(b2));
    }

    @Override
    public int compareTo(int other) {
        return this.compareTo(CBORObject.FromObject(other).AsNumber());
    }

    @Override
    public int compareTo(long other) {
        return this.compareTo(CBORObject.FromObject(other).AsNumber());
    }

    @Override
    public int compareTo(CBORNumber other) {
        int cmp;
        block32: {
            int s2;
            Object objB;
            Object objA;
            NumberKind typeB;
            NumberKind typeA;
            block31: {
                if (other == null) {
                    return 1;
                }
                if (this == other) {
                    return 0;
                }
                cmp = 0;
                typeA = this.kind;
                typeB = other.kind;
                objA = this.value;
                objB = other.value;
                if (typeA != typeB) break block31;
                switch (typeA) {
                    case Integer: {
                        long a = (Long)objA;
                        long b = (Long)objB;
                        cmp = a == b ? 0 : (a < b ? -1 : 1);
                        break block32;
                    }
                    case EInteger: {
                        EInteger bigintA = (EInteger)objA;
                        EInteger bigintB = (EInteger)objB;
                        cmp = bigintA.compareTo(bigintB);
                        break block32;
                    }
                    case Double: {
                        long a = (Long)objA;
                        long b = (Long)objB;
                        cmp = CBORUtilities.DoubleBitsNaN(a) ? (CBORUtilities.DoubleBitsNaN(b) ? 0 : 1) : (CBORUtilities.DoubleBitsNaN(b) ? -1 : (a < 0L != b < 0L ? (a < b ? -1 : 1) : (a == b ? 0 : (a < b ^ a < 0L ? -1 : 1))));
                        break block32;
                    }
                    case EDecimal: {
                        cmp = ((EDecimal)objA).compareTo((EDecimal)objB);
                        break block32;
                    }
                    case EFloat: {
                        cmp = ((EFloat)objA).compareTo((EFloat)objB);
                        break block32;
                    }
                    case ERational: {
                        cmp = ((ERational)objA).compareTo((ERational)objB);
                        break block32;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected data type");
                    }
                }
            }
            int s1 = CBORNumber.GetNumberInterface(typeA).Sign(objA);
            if (s1 != (s2 = CBORNumber.GetNumberInterface(typeB).Sign(objB)) && s1 != 2 && s2 != 2) {
                return s1 < s2 ? -1 : 1;
            }
            if (s1 == 2 && s2 == 2) {
                cmp = 0;
            } else {
                if (s1 == 2) {
                    return 1;
                }
                if (s2 == 2) {
                    return -1;
                }
                if (typeA == NumberKind.ERational) {
                    ERational e1 = CBORNumber.GetNumberInterface(typeA).AsERational(objA);
                    if (typeB == NumberKind.EDecimal) {
                        EDecimal e2 = CBORNumber.GetNumberInterface(typeB).AsEDecimal(objB);
                        cmp = e1.CompareToDecimal(e2);
                    } else {
                        EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsEFloat(objB);
                        cmp = e1.CompareToBinary(e2);
                    }
                } else if (typeB == NumberKind.ERational) {
                    ERational e2 = CBORNumber.GetNumberInterface(typeB).AsERational(objB);
                    if (typeA == NumberKind.EDecimal) {
                        EDecimal e1 = CBORNumber.GetNumberInterface(typeA).AsEDecimal(objA);
                        cmp = e2.CompareToDecimal(e1);
                        cmp = -cmp;
                    } else {
                        EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsEFloat(objA);
                        cmp = e2.CompareToBinary(e1);
                        cmp = -cmp;
                    }
                } else if (typeA == NumberKind.EDecimal || typeB == NumberKind.EDecimal) {
                    EDecimal e1 = null;
                    EDecimal e2 = null;
                    if (typeA == NumberKind.EFloat) {
                        EFloat ef1 = (EFloat)objA;
                        e2 = (EDecimal)objB;
                        cmp = e2.CompareToBinary(ef1);
                        cmp = -cmp;
                    } else if (typeB == NumberKind.EFloat) {
                        EFloat ef1 = (EFloat)objB;
                        e2 = (EDecimal)objA;
                        cmp = e2.CompareToBinary(ef1);
                    } else {
                        e1 = CBORNumber.GetNumberInterface(typeA).AsEDecimal(objA);
                        e2 = CBORNumber.GetNumberInterface(typeB).AsEDecimal(objB);
                        cmp = e1.compareTo(e2);
                    }
                } else if (typeA == NumberKind.EFloat || typeB == NumberKind.EFloat || typeA == NumberKind.Double || typeB == NumberKind.Double) {
                    EFloat e1 = CBORNumber.GetNumberInterface(typeA).AsEFloat(objA);
                    EFloat e2 = CBORNumber.GetNumberInterface(typeB).AsEFloat(objB);
                    cmp = e1.compareTo(e2);
                } else {
                    EInteger b1 = CBORNumber.GetNumberInterface(typeA).AsEInteger(objA);
                    EInteger b2 = CBORNumber.GetNumberInterface(typeB).AsEInteger(objB);
                    cmp = b1.compareTo(b2);
                }
            }
        }
        return cmp;
    }

    public static enum NumberKind {
        Integer,
        Double,
        EInteger,
        EDecimal,
        EFloat,
        ERational;

    }
}

