/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoManagerImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoManagerImpl;

public class ConnectorInfoManagerFactoryImpl
extends ConnectorInfoManagerFactory {
    private final Map<LocalManagerKey, ConnectorInfoManager> localManagerCache = new HashMap<LocalManagerKey, ConnectorInfoManager>();
    private final Map<RemoteManagerKey, RemoteConnectorInfoManagerImpl> remoteManagerCache = new HashMap<RemoteManagerKey, RemoteConnectorInfoManagerImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLocalCache() {
        Map<LocalManagerKey, ConnectorInfoManager> map = this.localManagerCache;
        synchronized (map) {
            this.localManagerCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRemoteCache() {
        Map<RemoteManagerKey, RemoteConnectorInfoManagerImpl> map = this.remoteManagerCache;
        synchronized (map) {
            this.remoteManagerCache.clear();
        }
    }

    public ConnectorInfoManager getLocalManager(URL ... urls) throws ConfigurationException {
        return this.getLocalManager(Arrays.asList(urls), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorInfoManager getLocalManager(List<URL> urls, ClassLoader bundleParentClassLoader) throws ConfigurationException {
        Assertions.nullCheck(urls, (String)"urls");
        for (URL url : urls) {
            Assertions.nullCheck((Object)url, (String)"urls");
        }
        if (bundleParentClassLoader == null) {
            bundleParentClassLoader = ConnectorInfoManagerFactory.class.getClassLoader();
        }
        LocalManagerKey key = new LocalManagerKey(urls, bundleParentClassLoader);
        Map<LocalManagerKey, ConnectorInfoManager> map = this.localManagerCache;
        synchronized (map) {
            ConnectorInfoManager rv = this.localManagerCache.get(key);
            if (rv == null) {
                rv = new LocalConnectorInfoManagerImpl(urls, bundleParentClassLoader);
            }
            this.localManagerCache.put(key, rv);
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorInfoManager getRemoteManager(RemoteFrameworkConnectionInfo info) throws ConfigurationException {
        RemoteManagerKey key = new RemoteManagerKey(info);
        Map<RemoteManagerKey, RemoteConnectorInfoManagerImpl> map = this.remoteManagerCache;
        synchronized (map) {
            RemoteConnectorInfoManagerImpl rv = this.remoteManagerCache.get(key);
            if (rv == null) {
                rv = new RemoteConnectorInfoManagerImpl(info);
            }
            this.remoteManagerCache.put(key, rv);
            return rv.derive(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorInfoManager getUnCheckedRemoteManager(RemoteFrameworkConnectionInfo info) {
        RemoteManagerKey key = new RemoteManagerKey(info);
        Map<RemoteManagerKey, RemoteConnectorInfoManagerImpl> map = this.remoteManagerCache;
        synchronized (map) {
            RemoteConnectorInfoManagerImpl rv = this.remoteManagerCache.get(key);
            if (rv == null) {
                rv = new RemoteConnectorInfoManagerImpl(info, false);
            }
            this.remoteManagerCache.put(key, rv);
            return rv;
        }
    }

    private static final class RemoteManagerKey {
        private final String host;
        private final int port;

        public RemoteManagerKey(RemoteFrameworkConnectionInfo info) {
            this.host = info.getHost();
            this.port = info.getPort();
        }

        public boolean equals(Object o) {
            if (o instanceof RemoteManagerKey) {
                RemoteManagerKey other = (RemoteManagerKey)o;
                if (!this.host.equals(other.host)) {
                    return false;
                }
                return this.port == other.port;
            }
            return false;
        }

        public int hashCode() {
            return this.host.hashCode() ^ this.port;
        }
    }

    private static final class LocalManagerKey {
        private final List<URL> urls;
        private final ClassLoader bundleParentClassLoader;

        public LocalManagerKey(List<URL> urls, ClassLoader bundleParentClassLoader) {
            this.urls = CollectionUtil.newReadOnlyList(urls);
            this.bundleParentClassLoader = bundleParentClassLoader;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LocalManagerKey) {
                LocalManagerKey other = (LocalManagerKey)obj;
                if (!this.urls.equals(other.urls)) {
                    return false;
                }
                return this.bundleParentClassLoader.equals(other.bundleParentClassLoader);
            }
            return false;
        }

        public int hashCode() {
            return this.urls.hashCode() ^ this.bundleParentClassLoader.hashCode();
        }
    }
}

