/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.spinner;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.form.spinner.ISpinnerListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public class SpinnerBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "spinner";
    private final ISpinnerListener listener;
    private JQueryAjaxBehavior onSpinAjaxBehavior = null;
    private JQueryAjaxBehavior onStopAjaxBehavior = null;

    public SpinnerBehavior(String selector, ISpinnerListener listener) {
        this(selector, listener, new Options());
    }

    public SpinnerBehavior(String selector, ISpinnerListener listener, Options options) {
        this(selector, METHOD, listener, options);
    }

    SpinnerBehavior(String selector, String method, ISpinnerListener listener, Options options) {
        super(selector, method, options);
        this.listener = (ISpinnerListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isOnSpinEventEnabled()) {
            this.onSpinAjaxBehavior = this.newOnSpinAjaxBehavior(this);
            component.add(new Behavior[]{this.onSpinAjaxBehavior});
        }
        if (this.listener.isOnStopEventEnabled()) {
            this.onStopAjaxBehavior = this.newOnStopAjaxBehavior(this);
            component.add(new Behavior[]{this.onStopAjaxBehavior});
        }
    }

    protected JQueryAjaxBehavior newOnSpinAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSpinAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnStopAjaxBehavior(IJQueryAjaxAware source) {
        return new OnStopAjaxBehavior(source);
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onSpinAjaxBehavior != null) {
            this.setOption("spin", this.onSpinAjaxBehavior.getCallbackFunction());
        }
        if (this.onStopAjaxBehavior != null) {
            this.setOption("stop", this.onStopAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SpinEvent) {
            this.listener.onSpin(target, ((SpinEvent)event).getValue());
        }
        if (event instanceof StopEvent) {
            this.listener.onStop(target);
        }
    }

    protected static class StopEvent
    extends JQueryEvent {
        protected StopEvent() {
        }
    }

    protected static class SpinEvent
    extends JQueryEvent {
        private final String value = RequestCycleUtils.getQueryParameterValue((String)"value").toOptionalString();

        public String getValue() {
            return this.value;
        }
    }

    protected static class OnStopAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnStopAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.context((String)"ui")};
        }

        protected JQueryEvent newEvent() {
            return new StopEvent();
        }
    }

    protected static class OnSpinAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSpinAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"value", (String)"ui.value")};
        }

        protected JQueryEvent newEvent() {
            return new SpinEvent();
        }
    }
}

