/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import com.microsoft.alm.oauth2.useragent.AuthorizationException;
import com.microsoft.alm.oauth2.useragent.AuthorizationResponse;
import com.microsoft.alm.oauth2.useragent.Provider;
import com.microsoft.alm.oauth2.useragent.ProviderScanner;
import com.microsoft.alm.oauth2.useragent.UserAgent;
import com.microsoft.alm.oauth2.useragent.subprocess.DefaultProcessFactory;
import com.microsoft.alm.oauth2.useragent.subprocess.ProcessCoordinator;
import com.microsoft.alm.oauth2.useragent.subprocess.TestableProcess;
import com.microsoft.alm.oauth2.useragent.subprocess.TestableProcessFactory;
import com.microsoft.alm.oauth2.useragent.utils.PackageLocator;
import com.microsoft.alm.oauth2.useragent.utils.StringHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class UserAgentImpl
implements UserAgent,
ProviderScanner {
    static final String REQUEST_AUTHORIZATION_CODE = "requestAuthorizationCode";
    static final String JAVA_VERSION_STRING = System.getProperty("java.version");
    static final String JAVA_HOME = System.getProperty("java.home");
    static final String PATH_SEPARATOR = System.getProperty("path.separator");
    static final String NEW_LINE = System.getProperty("line.separator");
    static final String UTF_8 = "UTF-8";
    static final String USER_AGENT_PROVIDER_PROPERTY_NAME = "userAgentProvider";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Set<String> NETWORKING_PROPERTY_NAMES;
    private static final Map<String, String> SAFE_REPLACEMENTS;
    private final TestableProcessFactory processFactory;
    private final List<Provider> candidateProviders;
    private final LinkedHashMap<Provider, List<String>> requirementsByProvider = new LinkedHashMap();
    private Provider provider;
    private boolean hasScannedAtLeastOnce = false;
    private String userAgentProvider = null;

    public UserAgentImpl() {
        this(new DefaultProcessFactory(), null, Provider.PROVIDERS);
    }

    UserAgentImpl(TestableProcessFactory processFactory, Provider provider, List<Provider> candidateProviders) {
        this.processFactory = processFactory;
        this.candidateProviders = candidateProviders;
        this.provider = provider;
    }

    @Override
    public Provider findCompatibleProvider() {
        String userAgentProvider = System.getProperty(USER_AGENT_PROVIDER_PROPERTY_NAME);
        return this.findCompatibleProvider(userAgentProvider, true);
    }

    @Override
    public Provider findCompatibleProvider(String userAgentProvider) {
        return this.findCompatibleProvider(userAgentProvider, true);
    }

    Provider findCompatibleProvider(String userAgentProvider, boolean checkOverrideIsCompatible) {
        if (this.provider == null || !StringHelper.equal(this.userAgentProvider, userAgentProvider)) {
            this.requirementsByProvider.clear();
            this.provider = UserAgentImpl.scanProviders(userAgentProvider, this.candidateProviders, this.requirementsByProvider, checkOverrideIsCompatible);
            this.hasScannedAtLeastOnce = true;
            this.userAgentProvider = userAgentProvider;
        }
        return this.provider;
    }

    @Override
    public Map<Provider, List<String>> getUnmetProviderRequirements() {
        if (!this.hasScannedAtLeastOnce) {
            this.findCompatibleProvider();
        }
        LinkedHashMap<Provider, List<String>> copy = new LinkedHashMap<Provider, List<String>>(this.requirementsByProvider);
        Map<Provider, List<String>> result = Collections.unmodifiableMap(copy);
        return result;
    }

    @Override
    public boolean hasCompatibleProvider() {
        this.findCompatibleProvider();
        return this.provider != null;
    }

    @Override
    public boolean hasCompatibleProvider(String userAgentProvider) {
        this.findCompatibleProvider(userAgentProvider);
        return this.provider != null;
    }

    @Override
    public AuthorizationResponse requestAuthorizationCode(URI authorizationEndpoint, URI redirectUri) throws AuthorizationException {
        return this.encode(REQUEST_AUTHORIZATION_CODE, authorizationEndpoint.toString(), redirectUri.toString());
    }

    AuthorizationResponse encode(String methodName, String ... parameters) throws AuthorizationException {
        ArrayList<String> command = new ArrayList<String>();
        ArrayList<String> classPath = new ArrayList<String>();
        command.add(new File(JAVA_HOME, "bin/java").getAbsolutePath());
        command.add("-Djava.protocol.handler.pkgs=com.microsoft.alm.oauth2.useragent");
        String userAgentProvider = System.getProperty(USER_AGENT_PROVIDER_PROPERTY_NAME);
        this.findCompatibleProvider(userAgentProvider, false);
        if (this.provider == null) {
            UserAgentImpl.throwUnsupported(this.requirementsByProvider);
        }
        this.provider.augmentProcessParameters(command, classPath);
        UserAgentImpl.relayProperties(System.getProperties(), NETWORKING_PROPERTY_NAMES, command);
        PackageLocator locator = new PackageLocator();
        File classPathEntryFile = locator.locatePackage(UserAgentImpl.class);
        String classPathEntry = classPathEntryFile.getAbsolutePath();
        classPath.add(classPathEntry);
        this.addClassPathToCommand(classPath, command, PATH_SEPARATOR);
        command.add("com.microsoft.alm.oauth2.useragent." + this.provider.getClassName());
        command.add(methodName);
        String[] args = command.toArray(EMPTY_STRING_ARRAY);
        try {
            TestableProcess process = this.processFactory.create(args);
            ProcessCoordinator coordinator = new ProcessCoordinator(process);
            for (String parameter : parameters) {
                coordinator.println(parameter);
            }
            coordinator.waitFor();
            String response = coordinator.getStdOut();
            String errorContents = coordinator.getStdErr();
            return AuthorizationResponse.fromString(response, errorContents);
        }
        catch (IOException e) {
            throw new AuthorizationException("io_exception", e.getMessage(), null, e);
        }
        catch (InterruptedException e) {
            throw new AuthorizationException("interrupted_exception", e.getMessage(), null, e);
        }
    }

    static void relayProperties(Properties properties, Set<String> propertyNames, List<String> destinationCommand) {
        for (String propertyName : propertyNames) {
            String propertyValue = properties.getProperty(propertyName);
            if (propertyValue == null) continue;
            destinationCommand.add("-D" + propertyName + "=" + propertyValue);
        }
    }

    void addClassPathToCommand(List<String> classPath, List<String> command, String pathSeparator) {
        command.add("-classpath");
        String[] classPathComponents = classPath.toArray(EMPTY_STRING_ARRAY);
        String classPathString = StringHelper.join(pathSeparator, classPathComponents);
        command.add(classPathString);
    }

    static void throwUnsupported(Map<Provider, List<String>> unmetRequirements) {
        StringBuilder sb = UserAgentImpl.buildUnsupportedMessage(unmetRequirements);
        throw new IllegalStateException(sb.toString());
    }

    public static StringBuilder buildUnsupportedMessage(Map<Provider, List<String>> unmetRequirements) {
        StringBuilder sb = new StringBuilder("I don't support your platform yet.");
        UserAgentImpl.describeUnmetRequirements(unmetRequirements, sb);
        sb.append(NEW_LINE);
        sb.append("Please send details about your operating system version, Java version, 32- vs. 64-bit, etc.");
        sb.append(NEW_LINE);
        sb.append("The following System Properties and Environment Variables would be very useful.");
        sb.append(NEW_LINE);
        Properties properties = System.getProperties();
        UserAgentImpl.appendProperties(properties, sb);
        sb.append(NEW_LINE);
        Map<String, String> variables = System.getenv();
        UserAgentImpl.appendVariables(variables, sb);
        return sb;
    }

    static Provider scanProviders(String userAgentProvider, List<Provider> providers, Map<Provider, List<String>> destinationUnmetRequirements, boolean checkOverrideIsCompatible) {
        List<String> requirements;
        Provider result = null;
        if (userAgentProvider != null) {
            for (Provider provider : providers) {
                if (!provider.getClassName().equals(userAgentProvider)) continue;
                if (checkOverrideIsCompatible) {
                    requirements = provider.checkRequirements();
                    if (requirements != null && requirements.size() != 0) break;
                    result = provider;
                    break;
                }
                result = provider;
                break;
            }
        }
        for (Provider provider : providers) {
            requirements = provider.checkRequirements();
            if (requirements == null || requirements.size() == 0) {
                if (result != null) continue;
                result = provider;
                continue;
            }
            destinationUnmetRequirements.put(provider, requirements);
        }
        return result;
    }

    public static void describeUnmetRequirements(Map<Provider, List<String>> unmetRequirements, StringBuilder destination) {
        for (Map.Entry<Provider, List<String>> pair : unmetRequirements.entrySet()) {
            Provider provider = pair.getKey();
            List<String> requirements = pair.getValue();
            if (requirements == null || requirements.size() <= 0) continue;
            destination.append(NEW_LINE);
            destination.append("Unmet requirements for the '").append(provider.getClassName()).append("' provider:").append(NEW_LINE);
            for (String requirement : requirements) {
                destination.append(" - ").append(requirement).append(NEW_LINE);
            }
        }
    }

    static void appendProperties(Properties properties, StringBuilder destination) {
        String header = "# --- BEGIN SYSTEM PROPERTIES ---";
        String footer = "# ---- END SYSTEM PROPERTIES ----";
        Set<String> keys = properties.stringPropertyNames();
        UserAgentImpl.appendPairs(keys, properties, destination, "# --- BEGIN SYSTEM PROPERTIES ---", "# ---- END SYSTEM PROPERTIES ----");
    }

    static void appendVariables(Map<String, String> variables, StringBuilder destination) {
        String header = "# --- BEGIN ENVIRONMENT VARIABLES ---";
        String footer = "# ---- END ENVIRONMENT VARIABLES ----";
        Set<String> keys = variables.keySet();
        UserAgentImpl.appendPairs(keys, variables, destination, "# --- BEGIN ENVIRONMENT VARIABLES ---", "# ---- END ENVIRONMENT VARIABLES ----");
    }

    static void appendPairs(Set<String> keys, Map pairs, StringBuilder destination, String header, String footer) {
        destination.append(header).append(NEW_LINE).append(NEW_LINE);
        Object[] keyArray = new String[keys.size()];
        keys.toArray(keyArray);
        Arrays.sort(keyArray);
        for (Object key : keyArray) {
            String encodedKey = UserAgentImpl.sortOfUrlEncode((String)key);
            String value = (String)pairs.get(key);
            String encodedValue = value == null ? "" : UserAgentImpl.sortOfUrlEncode(value);
            destination.append(encodedKey).append('=').append(encodedValue).append(NEW_LINE);
        }
        destination.append(NEW_LINE).append(footer).append(NEW_LINE);
    }

    static String sortOfUrlEncode(String s) {
        try {
            String encoded;
            String result = encoded = URLEncoder.encode(s, UTF_8);
            for (Map.Entry<String, String> entry : SAFE_REPLACEMENTS.entrySet()) {
                result = result.replace(entry.getKey(), entry.getValue());
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    static void decode(UserAgent target, String[] args, InputStream inputStream, OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String methodName = args[0];
            if (REQUEST_AUTHORIZATION_CODE.equals(methodName)) {
                URI authorizationEndpoint = new URI(bufferedReader.readLine());
                URI redirectUri = new URI(bufferedReader.readLine());
                AuthorizationResponse result = target.requestAuthorizationCode(authorizationEndpoint, redirectUri);
                printStream.println(result.toString());
            }
        }
        catch (AuthorizationException e) {
            printStream.println(AuthorizationException.toString(e.getCode(), e.getDescription(), e.getUri()));
        }
        catch (IOException e) {
            printStream.println(AuthorizationException.toString("io_exception", e.getMessage(), null));
        }
        catch (URISyntaxException e) {
            printStream.println(AuthorizationException.toString("uri_syntax_exception", e.getMessage(), null));
        }
        printStream.flush();
    }

    static String extractResponseFromRedirectUri(String redirectedUri) {
        try {
            URL uri = new URL(redirectedUri);
            return uri.getQuery();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static {
        HashSet<String> networkingPropertyNames = new HashSet<String>();
        networkingPropertyNames.add("http.proxyHost");
        networkingPropertyNames.add("http.proxyPort");
        networkingPropertyNames.add("http.nonProxyHosts");
        networkingPropertyNames.add("https.proxyHost");
        networkingPropertyNames.add("https.proxyPort");
        networkingPropertyNames.add("socksProxyHost");
        networkingPropertyNames.add("socksProxyPort");
        networkingPropertyNames.add("socksProxyVersion");
        networkingPropertyNames.add("java.net.socks.username");
        networkingPropertyNames.add("java.net.socks.password");
        networkingPropertyNames.add("java.net.useSystemProxies");
        networkingPropertyNames.add("http.auth.ntlm.domain");
        NETWORKING_PROPERTY_NAMES = Collections.unmodifiableSet(networkingPropertyNames);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("+", " ");
        map.put("%28", "(");
        map.put("%29", ")");
        map.put("%2F", "/");
        map.put("%3A", ":");
        map.put("%3B", ";");
        map.put("%5C", "\\");
        map.put("%7C", "|");
        SAFE_REPLACEMENTS = Collections.unmodifiableMap(map);
    }
}

