/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.DynRealmCheck;

public class DynRealmValidator
extends AbstractValidator<DynRealmCheck, DynRealm> {
    private static final Pattern REALM_KEY_PATTERN = Pattern.compile("^[A-Za-z0-9]+");

    public boolean isValid(DynRealm dynRealm, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (dynRealm.getKey().startsWith("/") || !REALM_KEY_PATTERN.matcher(dynRealm.getKey()).matches()) {
            isValid = false;
            context.buildConstraintViolationWithTemplate(DynRealmValidator.getTemplate(EntityViolationType.InvalidDynRealm, "Only letters and numbers are allowed in dynamic realm key, and must not start with /")).addPropertyNode("key").addConstraintViolation();
        }
        return isValid;
    }
}

