/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Size;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.AnyTemplateRealm;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.TicketExpirationPolicy;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAAnyTemplateRealm;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccessPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAttrReleasePolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAAuthPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy;
import org.apache.syncope.core.persistence.jpa.entity.policy.JPATicketExpirationPolicy;
import org.apache.syncope.core.persistence.jpa.validation.entity.RealmCheck;

@Entity
@Table(name="Realm", uniqueConstraints={@UniqueConstraint(columnNames={"name", "parent_id"})})
@Cacheable
@RealmCheck
public class JPARealm
extends AbstractGeneratedKeyEntity
implements Realm,
PersistenceCapable {
    private static final long serialVersionUID = 5533247460239909964L;
    public static final String TABLE = "Realm";
    @Size(min=1)
    private @Size(min=1) String name;
    @ManyToOne
    private JPARealm parent;
    @Column(nullable=false, unique=true)
    private String fullPath;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAPasswordPolicy passwordPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAAccountPolicy accountPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAAuthPolicy authPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAAccessPolicy accessPolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAAttrReleasePolicy attrReleasePolicy;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPATicketExpirationPolicy ticketExpirationPolicy;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="RealmAction", joinColumns={@JoinColumn(name="realm_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"realm_id", "implementation_id"})})
    private List<JPAImplementation> actions = new ArrayList<JPAImplementation>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="realm")
    private List<JPAAnyTemplateRealm> templates = new ArrayList<JPAAnyTemplateRealm>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(joinColumns={@JoinColumn(name="realm_id")}, inverseJoinColumns={@JoinColumn(name="resource_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"realm_id", "resource_id"})})
    private List<JPAExternalResource> resources = new ArrayList<JPAExternalResource>();
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccessPolicy;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAttrReleasePolicy;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAuthPolicy;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPATicketExpirationPolicy;

    public String getName() {
        return JPARealm.pcGetname(this);
    }

    public Realm getParent() {
        return JPARealm.pcGetparent(this);
    }

    public String getFullPath() {
        return JPARealm.pcGetfullPath(this);
    }

    public AccountPolicy getAccountPolicy() {
        return JPARealm.pcGetaccountPolicy(this) == null && this.getParent() != null ? this.getParent().getAccountPolicy() : JPARealm.pcGetaccountPolicy(this);
    }

    public PasswordPolicy getPasswordPolicy() {
        return JPARealm.pcGetpasswordPolicy(this) == null && this.getParent() != null ? this.getParent().getPasswordPolicy() : JPARealm.pcGetpasswordPolicy(this);
    }

    public void setName(String name) {
        JPARealm.pcSetname(this, name);
    }

    public void setParent(Realm parent) {
        this.checkType(parent, JPARealm.class);
        JPARealm.pcSetparent(this, (JPARealm)parent);
    }

    public void setFullPath(String fullPath) {
        JPARealm.pcSetfullPath(this, fullPath);
    }

    public void setAccountPolicy(AccountPolicy accountPolicy) {
        this.checkType(accountPolicy, JPAAccountPolicy.class);
        JPARealm.pcSetaccountPolicy(this, (JPAAccountPolicy)accountPolicy);
    }

    public void setPasswordPolicy(PasswordPolicy passwordPolicy) {
        this.checkType(passwordPolicy, JPAPasswordPolicy.class);
        JPARealm.pcSetpasswordPolicy(this, (JPAPasswordPolicy)passwordPolicy);
    }

    public AuthPolicy getAuthPolicy() {
        return JPARealm.pcGetauthPolicy(this);
    }

    public void setAuthPolicy(AuthPolicy authPolicy) {
        this.checkType(authPolicy, JPAAuthPolicy.class);
        JPARealm.pcSetauthPolicy(this, (JPAAuthPolicy)authPolicy);
    }

    public AccessPolicy getAccessPolicy() {
        return JPARealm.pcGetaccessPolicy(this);
    }

    public void setAccessPolicy(AccessPolicy accessPolicy) {
        this.checkType(accessPolicy, JPAAccessPolicy.class);
        JPARealm.pcSetaccessPolicy(this, (JPAAccessPolicy)accessPolicy);
    }

    public boolean add(Implementation action) {
        this.checkType(action, JPAImplementation.class);
        this.checkImplementationType(action, "LOGIC_ACTIONS");
        return JPARealm.pcGetactions(this).contains((JPAImplementation)action) || JPARealm.pcGetactions(this).add((JPAImplementation)action);
    }

    public List<? extends Implementation> getActions() {
        return JPARealm.pcGetactions(this);
    }

    public boolean add(AnyTemplateRealm template) {
        this.checkType(template, JPAAnyTemplateRealm.class);
        return JPARealm.pcGettemplates(this).add((JPAAnyTemplateRealm)template);
    }

    public Optional<? extends AnyTemplateRealm> getTemplate(AnyType anyType) {
        return JPARealm.pcGettemplates(this).stream().filter(template -> anyType != null && anyType.equals(template.getAnyType())).findFirst();
    }

    public List<? extends AnyTemplateRealm> getTemplates() {
        return JPARealm.pcGettemplates(this);
    }

    public void setAttrReleasePolicy(AttrReleasePolicy policy) {
        this.checkType(policy, JPAAttrReleasePolicy.class);
        JPARealm.pcSetattrReleasePolicy(this, (JPAAttrReleasePolicy)policy);
    }

    public AttrReleasePolicy getAttrReleasePolicy() {
        return JPARealm.pcGetattrReleasePolicy(this);
    }

    public TicketExpirationPolicy getTicketExpirationPolicy() {
        return JPARealm.pcGetticketExpirationPolicy(this);
    }

    public void setTicketExpirationPolicy(TicketExpirationPolicy policy) {
        this.checkType(policy, JPATicketExpirationPolicy.class);
        JPARealm.pcSetticketExpirationPolicy(this, (JPATicketExpirationPolicy)policy);
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPARealm.pcGetresources(this).contains((JPAExternalResource)resource) || JPARealm.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public List<String> getResourceKeys() {
        return this.getResources().stream().map(org.apache.syncope.core.persistence.api.entity.Entity::getKey).collect(Collectors.toList());
    }

    public List<? extends ExternalResource> getResources() {
        return JPARealm.pcGetresources(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"accessPolicy", "accountPolicy", "actions", "attrReleasePolicy", "authPolicy", "fullPath", "name", "parent", "passwordPolicy", "resources", "templates", "ticketExpirationPolicy"};
        Class[] classArray = new Class[12];
        Class clazz2 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccessPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccessPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccessPolicy = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccessPolicy"));
        classArray[0] = clazz2;
        Class clazz3 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAccountPolicy = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAAccountPolicy"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPARealm.class$("java.util.List"));
        classArray[2] = clazz4;
        Class clazz5 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAttrReleasePolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAttrReleasePolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAttrReleasePolicy = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAAttrReleasePolicy"));
        classArray[3] = clazz5;
        Class clazz6 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAuthPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAuthPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAAuthPolicy = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAAuthPolicy"));
        classArray[4] = clazz6;
        Class clazz7 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPARealm.class$("java.lang.String"));
        classArray[5] = clazz7;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPARealm.class$("java.lang.String"));
        Class clazz8 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.JPARealm"));
        classArray[7] = clazz8;
        Class clazz9 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPAPasswordPolicy = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPAPasswordPolicy"));
        classArray[8] = clazz9;
        classArray[9] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPARealm.class$("java.util.List"));
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPARealm.class$("java.util.List"));
        Class clazz10 = class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPATicketExpirationPolicy != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPATicketExpirationPolicy : (class$Lorg$apache$syncope$core$persistence$jpa$entity$policy$JPATicketExpirationPolicy = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.policy.JPATicketExpirationPolicy"));
        classArray[11] = clazz10;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 26, 26, 26, 26, 26, 26, 5, 10, 26};
        PCRegistry.register((Class)(class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.JPARealm"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPARealm", (PersistenceCapable)new JPARealm());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.accessPolicy = null;
        this.accountPolicy = null;
        this.actions = null;
        this.attrReleasePolicy = null;
        this.authPolicy = null;
        this.fullPath = null;
        this.name = null;
        this.parent = null;
        this.passwordPolicy = null;
        this.resources = null;
        this.templates = null;
        this.ticketExpirationPolicy = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPARealm jPARealm = new JPARealm();
        if (bl) {
            jPARealm.pcClearFields();
        }
        jPARealm.pcStateManager = stateManager;
        jPARealm.pcCopyKeyFieldsFromObjectId(object);
        return jPARealm;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPARealm jPARealm = new JPARealm();
        if (bl) {
            jPARealm.pcClearFields();
        }
        jPARealm.pcStateManager = stateManager;
        return jPARealm;
    }

    protected static int pcGetManagedFieldCount() {
        return 12 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.accessPolicy = (JPAAccessPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.accountPolicy = (JPAAccountPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.actions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.attrReleasePolicy = (JPAAttrReleasePolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.authPolicy = (JPAAuthPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.fullPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.parent = (JPARealm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.passwordPolicy = (JPAPasswordPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.templates = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.ticketExpirationPolicy = (JPATicketExpirationPolicy)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.accessPolicy);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.accountPolicy);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.actions);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.attrReleasePolicy);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.authPolicy);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.fullPath);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.parent);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.passwordPolicy);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.templates);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ticketExpirationPolicy);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPARealm jPARealm, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPARealm, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.accessPolicy = jPARealm.accessPolicy;
                return;
            }
            case 1: {
                this.accountPolicy = jPARealm.accountPolicy;
                return;
            }
            case 2: {
                this.actions = jPARealm.actions;
                return;
            }
            case 3: {
                this.attrReleasePolicy = jPARealm.attrReleasePolicy;
                return;
            }
            case 4: {
                this.authPolicy = jPARealm.authPolicy;
                return;
            }
            case 5: {
                this.fullPath = jPARealm.fullPath;
                return;
            }
            case 6: {
                this.name = jPARealm.name;
                return;
            }
            case 7: {
                this.parent = jPARealm.parent;
                return;
            }
            case 8: {
                this.passwordPolicy = jPARealm.passwordPolicy;
                return;
            }
            case 9: {
                this.resources = jPARealm.resources;
                return;
            }
            case 10: {
                this.templates = jPARealm.templates;
                return;
            }
            case 11: {
                this.ticketExpirationPolicy = jPARealm.ticketExpirationPolicy;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPARealm jPARealm = (JPARealm)object;
        if (jPARealm.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPARealm, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm = JPARealm.class$("org.apache.syncope.core.persistence.jpa.entity.JPARealm"));
        return clazz;
    }

    private static final JPAAccessPolicy pcGetaccessPolicy(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.accessPolicy;
        }
        int n = pcInheritedFieldCount + 0;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.accessPolicy;
    }

    private static final void pcSetaccessPolicy(JPARealm jPARealm, JPAAccessPolicy jPAAccessPolicy) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.accessPolicy = jPAAccessPolicy;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 0, (Object)jPARealm.accessPolicy, (Object)jPAAccessPolicy, 0);
    }

    private static final JPAAccountPolicy pcGetaccountPolicy(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.accountPolicy;
        }
        int n = pcInheritedFieldCount + 1;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.accountPolicy;
    }

    private static final void pcSetaccountPolicy(JPARealm jPARealm, JPAAccountPolicy jPAAccountPolicy) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.accountPolicy = jPAAccountPolicy;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 1, (Object)jPARealm.accountPolicy, (Object)jPAAccountPolicy, 0);
    }

    private static final List pcGetactions(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.actions;
        }
        int n = pcInheritedFieldCount + 2;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.actions;
    }

    private static final void pcSetactions(JPARealm jPARealm, List list) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.actions = list;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 2, jPARealm.actions, (Object)list, 0);
    }

    private static final JPAAttrReleasePolicy pcGetattrReleasePolicy(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.attrReleasePolicy;
        }
        int n = pcInheritedFieldCount + 3;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.attrReleasePolicy;
    }

    private static final void pcSetattrReleasePolicy(JPARealm jPARealm, JPAAttrReleasePolicy jPAAttrReleasePolicy) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.attrReleasePolicy = jPAAttrReleasePolicy;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 3, (Object)jPARealm.attrReleasePolicy, (Object)jPAAttrReleasePolicy, 0);
    }

    private static final JPAAuthPolicy pcGetauthPolicy(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.authPolicy;
        }
        int n = pcInheritedFieldCount + 4;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.authPolicy;
    }

    private static final void pcSetauthPolicy(JPARealm jPARealm, JPAAuthPolicy jPAAuthPolicy) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.authPolicy = jPAAuthPolicy;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 4, (Object)jPARealm.authPolicy, (Object)jPAAuthPolicy, 0);
    }

    private static final String pcGetfullPath(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.fullPath;
        }
        int n = pcInheritedFieldCount + 5;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.fullPath;
    }

    private static final void pcSetfullPath(JPARealm jPARealm, String string) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.fullPath = string;
            return;
        }
        jPARealm.pcStateManager.settingStringField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 5, jPARealm.fullPath, string, 0);
    }

    private static final String pcGetname(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.name;
        }
        int n = pcInheritedFieldCount + 6;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.name;
    }

    private static final void pcSetname(JPARealm jPARealm, String string) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.name = string;
            return;
        }
        jPARealm.pcStateManager.settingStringField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 6, jPARealm.name, string, 0);
    }

    private static final JPARealm pcGetparent(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.parent;
        }
        int n = pcInheritedFieldCount + 7;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.parent;
    }

    private static final void pcSetparent(JPARealm jPARealm, JPARealm jPARealm2) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.parent = jPARealm2;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 7, (Object)jPARealm.parent, (Object)jPARealm2, 0);
    }

    private static final JPAPasswordPolicy pcGetpasswordPolicy(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.passwordPolicy;
        }
        int n = pcInheritedFieldCount + 8;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.passwordPolicy;
    }

    private static final void pcSetpasswordPolicy(JPARealm jPARealm, JPAPasswordPolicy jPAPasswordPolicy) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.passwordPolicy = jPAPasswordPolicy;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 8, (Object)jPARealm.passwordPolicy, (Object)jPAPasswordPolicy, 0);
    }

    private static final List pcGetresources(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.resources;
        }
        int n = pcInheritedFieldCount + 9;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.resources;
    }

    private static final void pcSetresources(JPARealm jPARealm, List list) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.resources = list;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 9, jPARealm.resources, (Object)list, 0);
    }

    private static final List pcGettemplates(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.templates;
        }
        int n = pcInheritedFieldCount + 10;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.templates;
    }

    private static final void pcSettemplates(JPARealm jPARealm, List list) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.templates = list;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 10, jPARealm.templates, (Object)list, 0);
    }

    private static final JPATicketExpirationPolicy pcGetticketExpirationPolicy(JPARealm jPARealm) {
        if (jPARealm.pcStateManager == null) {
            return jPARealm.ticketExpirationPolicy;
        }
        int n = pcInheritedFieldCount + 11;
        jPARealm.pcStateManager.accessingField(n);
        return jPARealm.ticketExpirationPolicy;
    }

    private static final void pcSetticketExpirationPolicy(JPARealm jPARealm, JPATicketExpirationPolicy jPATicketExpirationPolicy) {
        if (jPARealm.pcStateManager == null) {
            jPARealm.ticketExpirationPolicy = jPATicketExpirationPolicy;
            return;
        }
        jPARealm.pcStateManager.settingObjectField((PersistenceCapable)jPARealm, pcInheritedFieldCount + 11, (Object)jPARealm.ticketExpirationPolicy, (Object)jPATicketExpirationPolicy, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

