/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.provisioning.api.rules.PasswordRule;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.policy.DefaultPasswordRule;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DefaultPasswordGenerator
implements PasswordGenerator {
    protected static final Logger LOG = LoggerFactory.getLogger(PasswordGenerator.class);
    protected static final int VERY_MIN_LENGTH = 0;
    protected static final int VERY_MAX_LENGTH = 64;
    protected static final int MIN_LENGTH_IF_ZERO = 8;
    protected final Map<String, PasswordRule> perContextPasswordRules = new ConcurrentHashMap<String, PasswordRule>();

    @Override
    @Transactional(readOnly=true)
    public String generate(ExternalResource resource, List<Realm> realms) {
        ArrayList<PasswordPolicy> policies = new ArrayList<PasswordPolicy>();
        Optional.ofNullable(resource.getPasswordPolicy()).ifPresent(policies::add);
        realms.forEach(r -> Optional.ofNullable(r.getPasswordPolicy()).filter(p -> !policies.contains(p)).ifPresent(policies::add));
        return this.generate(policies);
    }

    protected List<PasswordRule> getPasswordRules(PasswordPolicy policy) {
        ArrayList<PasswordRule> result = new ArrayList<PasswordRule>();
        for (Implementation impl : policy.getRules()) {
            try {
                ImplementationManager.buildPasswordRule(impl, () -> this.perContextPasswordRules.get(impl.getKey()), instance -> this.perContextPasswordRules.put(impl.getKey(), (PasswordRule)instance)).ifPresent(result::add);
            }
            catch (Exception e) {
                LOG.warn("While building {}", (Object)impl, (Object)e);
            }
        }
        return result;
    }

    @Override
    public String generate(List<PasswordPolicy> policies) {
        ArrayList<DefaultPasswordRuleConf> ruleConfs = new ArrayList<DefaultPasswordRuleConf>();
        policies.stream().forEach(policy -> this.getPasswordRules((PasswordPolicy)policy).stream().filter(rule -> rule.getConf() instanceof DefaultPasswordRuleConf).forEach(rule -> ruleConfs.add((DefaultPasswordRuleConf)rule.getConf())));
        return this.generate(this.merge(ruleConfs));
    }

    protected DefaultPasswordRuleConf merge(List<DefaultPasswordRuleConf> defaultRuleConfs) {
        DefaultPasswordRuleConf result = new DefaultPasswordRuleConf();
        result.setMinLength(0);
        result.setMaxLength(64);
        defaultRuleConfs.forEach(ruleConf -> {
            if (ruleConf.getMinLength() > result.getMinLength()) {
                result.setMinLength(ruleConf.getMinLength());
            }
            if (ruleConf.getMaxLength() > 0 && ruleConf.getMaxLength() < result.getMaxLength()) {
                result.setMaxLength(ruleConf.getMaxLength());
            }
            if (ruleConf.getAlphabetical() > result.getAlphabetical()) {
                result.setAlphabetical(ruleConf.getAlphabetical());
            }
            if (ruleConf.getUppercase() > result.getUppercase()) {
                result.setUppercase(ruleConf.getUppercase());
            }
            if (ruleConf.getLowercase() > result.getLowercase()) {
                result.setLowercase(ruleConf.getLowercase());
            }
            if (ruleConf.getDigit() > result.getDigit()) {
                result.setDigit(ruleConf.getDigit());
            }
            if (ruleConf.getSpecial() > result.getSpecial()) {
                result.setSpecial(ruleConf.getSpecial());
            }
            if (!ruleConf.getSpecialChars().isEmpty()) {
                result.getSpecialChars().addAll(ruleConf.getSpecialChars().stream().filter(c -> !result.getSpecialChars().contains(c)).collect(Collectors.toList()));
            }
            if (!ruleConf.getIllegalChars().isEmpty()) {
                result.getIllegalChars().addAll(ruleConf.getIllegalChars().stream().filter(c -> !result.getIllegalChars().contains(c)).collect(Collectors.toList()));
            }
            if (ruleConf.getRepeatSame() > result.getRepeatSame()) {
                result.setRepeatSame(ruleConf.getRepeatSame());
            }
            if (!result.isUsernameAllowed()) {
                result.setUsernameAllowed(ruleConf.isUsernameAllowed());
            }
            if (!ruleConf.getWordsNotPermitted().isEmpty()) {
                result.getWordsNotPermitted().addAll(ruleConf.getWordsNotPermitted().stream().filter(w -> !result.getWordsNotPermitted().contains(w)).collect(Collectors.toList()));
            }
        });
        if (result.getMinLength() == 0) {
            result.setMinLength(result.getMaxLength() < 8 ? result.getMaxLength() : 8);
        }
        if (result.getMinLength() > result.getMaxLength()) {
            result.setMaxLength(result.getMinLength());
        }
        return result;
    }

    protected String generate(DefaultPasswordRuleConf ruleConf) {
        List<Object> characterRules = DefaultPasswordRule.conf2Rules(ruleConf).stream().filter(CharacterRule.class::isInstance).map(CharacterRule.class::cast).collect(Collectors.toList());
        if (characterRules.isEmpty()) {
            int halfMinLength = ruleConf.getMinLength() / 2;
            characterRules = List.of(new CharacterRule((CharacterData)EnglishCharacterData.Alphabetical, halfMinLength), new CharacterRule((CharacterData)EnglishCharacterData.Digit, halfMinLength));
        }
        int min = Math.max(ruleConf.getMinLength(), characterRules.stream().mapToInt(CharacterRule::getNumberOfCharacters).sum());
        return SecureRandomUtils.passwordGenerator().generatePassword(min, characterRules);
    }
}

