/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.schema;

import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.schema.ADSchemaBuilder;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.schema.LdapSchema;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.Uid;

public class ADSchema
extends LdapSchema {
    private static final Log LOG = Log.getLog(ADSchema.class);

    public ADSchema(ADConnection connection) {
        super((LdapConnection)connection);
    }

    public Schema schema() {
        if (this.schema == null) {
            this.schema = new ADSchemaBuilder((ADConnection)this.conn).getSchema();
        }
        return this.schema;
    }

    public String getLdapAttribute(ObjectClass oclass, String attrName, boolean transfer) {
        String result = null;
        if (AttributeUtil.namesEqual((String)Uid.NAME, (String)attrName)) {
            result = this.getLdapUidAttribute(oclass);
        } else if (AttributeUtil.namesEqual((String)Name.NAME, (String)attrName)) {
            result = this.getLdapNameAttribute(oclass);
        } else if (OperationalAttributes.PASSWORD_NAME.equals(attrName)) {
            result = this.getLdapPasswordAttribute(oclass);
        }
        if (result == null && !AttributeUtil.isSpecialName((String)attrName)) {
            result = attrName;
        }
        if (result == null && !oclass.equals((Object)ANY_OBJECT_CLASS)) {
            LOG.warn("Attribute {0} of object class {1} is not mapped to an LDAP attribute", new Object[]{attrName, oclass.getObjectClassValue()});
        }
        return result;
    }
}

