/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.keymaster.internal;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.core.keymaster.internal.InternalConfParamHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class SelfKeymasterInternalConfParamOps
implements ConfParamOps {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfParamOps.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final InternalConfParamHelper helper;

    public SelfKeymasterInternalConfParamOps(InternalConfParamHelper helper) {
        this.helper = helper;
    }

    @Transactional(readOnly=true)
    public Map<String, Object> list(String domain) {
        return this.helper.list();
    }

    @Transactional(readOnly=true)
    public <T> T get(String domain, String key, T defaultValue, Class<T> reference) {
        JsonNode valueNode = this.helper.get(key);
        if (valueNode == null) {
            return defaultValue;
        }
        try {
            return (T)MAPPER.treeToValue((TreeNode)valueNode, reference);
        }
        catch (IOException e) {
            LOG.error("Could not deserialize {}", (Object)valueNode, (Object)e);
            return defaultValue;
        }
    }

    @Transactional
    public <T> void set(String domain, String key, T value) {
        if (value == null) {
            this.remove(domain, key);
        } else {
            this.helper.set(key, MAPPER.valueToTree(value));
        }
    }

    @Transactional
    public void remove(String domain, String key) {
        this.helper.remove(key);
    }
}

