/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.UserException;

public class AccessCode {
    public static int UNKNOWN = 0;
    public static int EMPTY = 1;
    public static int FIELD = 2;
    public static int PROPERTY = 4;
    public static int EXPLICIT = 8;
    public static int MIXED = 16;
    private static Localizer _loc = Localizer.forPackage(AccessCode.class);

    public static boolean isValidClassCode(int code) {
        if (code == EMPTY) {
            return true;
        }
        return !(code % 2 != 0 && code != EMPTY || code < UNKNOWN || code > (MIXED | EXPLICIT | PROPERTY) || AccessCode.isProperty(code) && AccessCode.isField(code) || !AccessCode.isProperty(code) && !AccessCode.isField(code) && !AccessCode.isUnknown(code) || (!AccessCode.isMixed(code) || !AccessCode.isExplicit(code)) && AccessCode.isMixed(code));
    }

    public static boolean isValidFieldCode(int code) {
        return !(code % 2 != 0 || code < UNKNOWN || code > (EXPLICIT | PROPERTY) || AccessCode.isProperty(code) && AccessCode.isField(code) || !AccessCode.isProperty(code) && !AccessCode.isField(code) && !AccessCode.isUnknown(code));
    }

    public static boolean isMixed(int code) {
        return (code & MIXED) != 0;
    }

    public static boolean isExplicit(int code) {
        return (code & EXPLICIT) != 0;
    }

    public static boolean isProperty(int code) {
        return (code & PROPERTY) != 0;
    }

    public static boolean isField(int code) {
        return (code & FIELD) != 0;
    }

    public static boolean isUnknown(int code) {
        return code == UNKNOWN;
    }

    public static boolean isEmpty(int code) {
        return code == EMPTY;
    }

    public static boolean isField(ClassMetaData meta) {
        return AccessCode.isField(meta.getAccessType());
    }

    public static boolean isProperty(ClassMetaData meta) {
        return AccessCode.isProperty(meta.getAccessType());
    }

    public static boolean isUnknown(ClassMetaData meta) {
        return AccessCode.isUnknown(meta.getAccessType());
    }

    public static boolean isEmpty(ClassMetaData meta) {
        return AccessCode.isEmpty(meta.getAccessType());
    }

    public static boolean isField(FieldMetaData meta) {
        return AccessCode.isField(meta.getAccessType());
    }

    public static boolean isProperty(FieldMetaData meta) {
        return AccessCode.isProperty(meta.getAccessType());
    }

    public static boolean isUnknown(FieldMetaData meta) {
        return AccessCode.isUnknown(meta.getAccessType());
    }

    public static boolean isCompatibleSuper(int subCode, int superCode) {
        if (AccessCode.isEmpty(superCode)) {
            return true;
        }
        if (AccessCode.isValidClassCode(subCode) && AccessCode.isValidClassCode(superCode)) {
            if (AccessCode.isExplicit(subCode)) {
                return true;
            }
            return subCode == superCode;
        }
        return false;
    }

    public static int mergeFieldCode(ClassMetaData meta, FieldMetaData fmd, int fCode) {
        int cCode = meta.getAccessType();
        try {
            return AccessCode.mergeFieldCode(cCode, fCode);
        }
        catch (IllegalStateException e) {
            throw new UserException(_loc.get("access-illegal-merge", (Object)fmd.getFullName(false), (Object)AccessCode.toFieldString(fCode), (Object)AccessCode.toClassString(cCode)));
        }
    }

    public static int mergeFieldCode(int cCode, int fCode) {
        if (AccessCode.isValidClassCode(cCode) && AccessCode.isValidFieldCode(fCode)) {
            boolean mixed;
            if (AccessCode.isUnknown(cCode)) {
                if (AccessCode.isUnknown(fCode)) {
                    return UNKNOWN;
                }
                return AccessCode.isProperty(fCode) ? PROPERTY : FIELD;
            }
            boolean bl = mixed = AccessCode.isProperty(cCode) != AccessCode.isProperty(fCode);
            if (AccessCode.isExplicit(cCode)) {
                if (mixed) {
                    return MIXED | cCode;
                }
                return cCode;
            }
            if (fCode == cCode) {
                return cCode;
            }
            throw new IllegalStateException(_loc.get("access-cannot-merge", (Object)AccessCode.toFieldString(fCode), (Object)AccessCode.toClassString(cCode)).toString());
        }
        return cCode;
    }

    public static int getMixedCode(int cCode, int fCode) {
        if (AccessCode.isMixed(cCode) || AccessCode.isProperty(cCode) == AccessCode.isProperty(fCode)) {
            return cCode;
        }
        return MIXED | cCode;
    }

    public static int toFieldCode(int code) {
        if (AccessCode.isProperty(code)) {
            return PROPERTY;
        }
        if (AccessCode.isField(code)) {
            return FIELD;
        }
        return UNKNOWN;
    }

    public static String toFieldString(int code) {
        if (!AccessCode.isValidFieldCode(code)) {
            return "invalid code " + code;
        }
        if (code == UNKNOWN) {
            return "unknown access";
        }
        if (code == EMPTY) {
            return "empty access";
        }
        return (AccessCode.isMixed(code) ? "mixed " : "") + (AccessCode.isExplicit(code) ? "explicit " : "implicit ") + (AccessCode.isField(code) ? "field" : "property") + " access";
    }

    public static String toClassString(int code) {
        if (!AccessCode.isValidClassCode(code)) {
            return "invalid code " + code;
        }
        if (code == UNKNOWN) {
            return "unknown access";
        }
        if (code == EMPTY) {
            return "empty access";
        }
        return (AccessCode.isMixed(code) ? "mixed " : "") + (AccessCode.isExplicit(code) ? "explicit " : "implicit ") + (AccessCode.isField(code) ? "field" : "property") + " access";
    }
}

