/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.syncope.common.lib.types.BpmnProcessFormat;
import org.apache.syncope.core.flowable.api.BpmnProcessManager;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class BpmnProcessLogic
extends AbstractTransactionalLogic<BpmnProcess> {
    protected final BpmnProcessManager bpmnProcessManager;

    public BpmnProcessLogic(BpmnProcessManager bpmnProcessManager) {
        this.bpmnProcessManager = bpmnProcessManager;
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<BpmnProcess> list() {
        return this.bpmnProcessManager.getProcesses();
    }

    @PreAuthorize(value="hasRole('BPMN_PROCESS_GET')")
    @Transactional(readOnly=true)
    public void exportDefinition(String key, BpmnProcessFormat format, OutputStream os) {
        this.bpmnProcessManager.exportProcess(key, format, os);
    }

    @PreAuthorize(value="hasRole('BPMN_PROCESS_GET')")
    @Transactional(readOnly=true)
    public void exportDiagram(String key, OutputStream os) {
        this.bpmnProcessManager.exportDiagram(key, os);
    }

    @PreAuthorize(value="hasRole('BPMN_PROCESS_SET')")
    public void importDefinition(String key, BpmnProcessFormat format, String definition) {
        this.bpmnProcessManager.importProcess(key, format, definition);
    }

    @PreAuthorize(value="hasRole('BPMN_PROCESS_DELETE')")
    public void delete(String key) {
        this.bpmnProcessManager.deleteProcess(key);
    }

    protected BpmnProcess resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

