/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.HasVariableServiceConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.types.MutableVariableType;

public class TraceableObject<O, C> {
    protected MutableVariableType<O, C> type;
    protected O tracedObject;
    protected C tracedObjectOriginalValue;
    protected VariableInstanceEntity variableInstanceEntity;

    public TraceableObject(MutableVariableType<O, C> type, O tracedObject, C tracedObjectOriginalValue, VariableInstanceEntity variableInstanceEntity) {
        this.type = type;
        this.tracedObject = tracedObject;
        this.tracedObjectOriginalValue = tracedObjectOriginalValue;
        this.variableInstanceEntity = variableInstanceEntity;
    }

    public void updateIfValueChanged() {
        if (this.tracedObject == this.variableInstanceEntity.getCachedValue() && this.type.updateValueIfChanged(this.tracedObject, this.tracedObjectOriginalValue, this.variableInstanceEntity)) {
            VariableServiceConfiguration variableServiceConfiguration = this.getVariableServiceConfiguration();
            variableServiceConfiguration.getInternalHistoryVariableManager().recordVariableUpdate(this.variableInstanceEntity, variableServiceConfiguration.getClock().getCurrentTime());
        }
    }

    protected VariableServiceConfiguration getVariableServiceConfiguration() {
        String engineType = this.getEngineType(this.variableInstanceEntity.getScopeType());
        Map engineConfigurationMap = Context.getCommandContext().getEngineConfigurations();
        AbstractEngineConfiguration engineConfiguration = (AbstractEngineConfiguration)engineConfigurationMap.get(engineType);
        if (engineConfiguration == null) {
            for (AbstractEngineConfiguration possibleEngineConfiguration : engineConfigurationMap.values()) {
                if (!(possibleEngineConfiguration instanceof HasVariableServiceConfiguration)) continue;
                engineConfiguration = possibleEngineConfiguration;
            }
        }
        if (engineConfiguration == null) {
            throw new FlowableException("Could not find engine configuration with variable service configuration");
        }
        if (!(engineConfiguration instanceof HasVariableServiceConfiguration)) {
            throw new FlowableException("Variable entity engine scope has no variable service configuration " + engineType);
        }
        return (VariableServiceConfiguration)((Object)engineConfiguration.getServiceConfigurations().get("cfg.variableService"));
    }

    protected String getEngineType(String scopeType) {
        if (StringUtils.isNotEmpty((CharSequence)scopeType)) {
            return scopeType;
        }
        return "bpmn";
    }
}

