/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.HasVariableServiceConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.types.MutableVariableType;
import org.flowable.variable.service.impl.types.TraceableObject;
import org.flowable.variable.service.impl.types.TraceableVariablesCommandContextCloseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonType
implements VariableType,
MutableVariableType<JsonNode, JsonNode> {
    public static final String TYPE_NAME = "json";
    protected static final String LONG_JSON_TYPE_NAME = "longJson";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonType.class);
    protected final int maxLength;
    protected final boolean trackObjects;
    protected final String typeName;
    protected ObjectMapper objectMapper;

    public JsonType(int maxLength, ObjectMapper objectMapper, boolean trackObjects) {
        this(maxLength, objectMapper, trackObjects, TYPE_NAME);
    }

    protected JsonType(int maxLength, ObjectMapper objectMapper, boolean trackObjects, String typeName) {
        this.maxLength = maxLength;
        this.trackObjects = trackObjects;
        this.objectMapper = objectMapper;
        this.typeName = typeName;
    }

    public static JsonType longJsonType(int maxLength, ObjectMapper objectMapper, boolean trackObjects) {
        return new JsonType(maxLength, objectMapper, trackObjects, LONG_JSON_TYPE_NAME);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        if (valueFields.getCachedValue() != null) {
            return valueFields.getCachedValue();
        }
        JsonNode jsonValue = null;
        String textValue = valueFields.getTextValue();
        if (textValue != null && textValue.length() > 0) {
            try {
                jsonValue = this.objectMapper.readTree(textValue);
                valueFields.setCachedValue((Object)jsonValue);
                this.traceValue(jsonValue, valueFields);
            }
            catch (Exception e) {
                LOGGER.error("Error reading json variable {}", (Object)valueFields.getName(), (Object)e);
            }
        } else {
            byte[] bytes = valueFields.getBytes();
            if (bytes != null && bytes.length > 0) {
                try {
                    jsonValue = this.objectMapper.readTree(bytes);
                    valueFields.setCachedValue((Object)jsonValue);
                    this.traceValue(jsonValue, valueFields);
                }
                catch (IOException e) {
                    LOGGER.error("Error reading json variable {}", (Object)valueFields.getName(), (Object)e);
                }
            }
        }
        return jsonValue;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value == null) {
            valueFields.setTextValue(null);
            valueFields.setBytes(null);
            valueFields.setCachedValue(null);
        } else {
            JsonNode jsonNode = (JsonNode)value;
            String textValue = value.toString();
            if (textValue.length() <= this.maxLength) {
                valueFields.setTextValue(textValue);
                valueFields.setBytes(null);
            } else {
                valueFields.setBytes(textValue.getBytes(StandardCharsets.UTF_8));
                valueFields.setTextValue(null);
            }
            valueFields.setCachedValue((Object)jsonNode);
            this.traceValue(jsonNode, valueFields);
        }
    }

    @Override
    public boolean updateValueIfChanged(JsonNode originalNode, JsonNode originalCopyNode, VariableInstanceEntity variableInstanceEntity) {
        boolean valueChanged = false;
        if (!Objects.equals(originalNode, originalCopyNode)) {
            String textValue = originalNode.toString();
            if (textValue.length() <= this.maxLength) {
                variableInstanceEntity.setTextValue(textValue);
                if (variableInstanceEntity.getByteArrayRef() != null) {
                    variableInstanceEntity.getByteArrayRef().delete(this.getEngineType(variableInstanceEntity.getScopeType()));
                }
            } else {
                variableInstanceEntity.setTextValue(null);
                variableInstanceEntity.setBytes(textValue.getBytes(StandardCharsets.UTF_8));
            }
            valueChanged = true;
        }
        return valueChanged;
    }

    protected void traceValue(JsonNode value, ValueFields valueFields) {
        VariableServiceConfiguration variableServiceConfiguration;
        CommandContext commandContext;
        if (this.trackObjects && valueFields instanceof VariableInstanceEntity && (commandContext = Context.getCommandContext()) != null && (variableServiceConfiguration = this.getVariableServiceConfiguration(valueFields)) != null) {
            commandContext.addCloseListener((CommandContextCloseListener)new TraceableVariablesCommandContextCloseListener(new TraceableObject<JsonNode, JsonNode>(this, value, value.deepCopy(), (VariableInstanceEntity)valueFields)));
            variableServiceConfiguration.getInternalHistoryVariableManager().initAsyncHistoryCommandContextCloseListener();
        }
    }

    protected VariableServiceConfiguration getVariableServiceConfiguration(ValueFields valueFields) {
        String engineType = this.getEngineType(valueFields.getScopeType());
        Map engineConfigurationMap = Context.getCommandContext().getEngineConfigurations();
        AbstractEngineConfiguration engineConfiguration = (AbstractEngineConfiguration)engineConfigurationMap.get(engineType);
        if (engineConfiguration == null) {
            for (AbstractEngineConfiguration possibleEngineConfiguration : engineConfigurationMap.values()) {
                if (!(possibleEngineConfiguration instanceof HasVariableServiceConfiguration)) continue;
                engineConfiguration = possibleEngineConfiguration;
            }
        }
        if (engineConfiguration == null) {
            return null;
        }
        return (VariableServiceConfiguration)((Object)engineConfiguration.getServiceConfigurations().get("cfg.variableService"));
    }

    protected String getEngineType(String scopeType) {
        if (StringUtils.isNotEmpty((CharSequence)scopeType)) {
            return scopeType;
        }
        return "bpmn";
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof JsonNode;
    }
}

