/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.metadata;

import java.io.File;
import net.shibboleth.tool.xmlsectool.XMLSecTool;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataSigner;

public class XMLSecSAML2MetadataSigner
implements SAML2MetadataSigner {
    private final SAML2Configuration configuration;

    public XMLSecSAML2MetadataSigner(SAML2Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void sign(File metadata) {
        try {
            String[] args = new String[]{"--sign", "--referenceIdAttributeName", "ID", "--signatureAlgorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "--inFile", metadata.getCanonicalPath(), "--keystore", this.configuration.getKeystoreResource().getFile().getCanonicalPath(), "--keystorePassword", this.configuration.getKeystorePassword(), "--keyAlias", this.configuration.getKeyStoreAlias(), "--keyPassword", this.configuration.getPrivateKeyPassword(), "--outFile", metadata.getCanonicalPath()};
            XMLSecTool.main((String[])args);
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }
}

