/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.util.LoggingUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class OidcDefaultJsonWebKeystoreCacheLoader
implements CacheLoader<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDefaultJsonWebKeystoreCacheLoader.class);
    private final OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService;

    private static JsonWebKeySet getJsonWebKeysFromJwks(JsonWebKeySet jwks, OidcJsonWebKeyCacheKey cacheKey) {
        List keys = OidcJsonWebKeyStoreUtils.getJsonWebKeyFromJsonWebKeySet(jwks, Optional.empty(), Optional.of(cacheKey.getUsage())).map(JsonWebKeySet::getJsonWebKeys).orElseGet(ArrayList::new);
        return new JsonWebKeySet(keys.stream().filter(k -> OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState(k).isCurrent()).map(PublicJsonWebKey.class::cast).filter(k -> k.getPrivateKey() != null).collect(Collectors.toList()));
    }

    public Optional<JsonWebKeySet> load(OidcJsonWebKeyCacheKey cacheKey) {
        Optional<JsonWebKeySet> jwks = this.buildJsonWebKeySet(cacheKey);
        if (jwks.isEmpty()) {
            LOGGER.warn("JSON web keystore retrieved is empty for issuer [{}]", (Object)cacheKey.getIssuer());
            return Optional.empty();
        }
        JsonWebKeySet keySet = jwks.get();
        if (keySet.getJsonWebKeys().isEmpty()) {
            LOGGER.warn("JSON web keystore retrieved [{}] contains no JSON web keys", (Object)keySet);
            return Optional.empty();
        }
        JsonWebKeySet keys = OidcDefaultJsonWebKeystoreCacheLoader.getJsonWebKeysFromJwks(keySet, cacheKey);
        LOGGER.debug("Found JSON web key as [{}]", (Object)keys);
        return keys.getJsonWebKeys().isEmpty() ? Optional.empty() : Optional.of(keys);
    }

    protected JsonWebKeySet buildJsonWebKeySet(Resource resource, OidcJsonWebKeyCacheKey cacheKey) throws Exception {
        JsonWebKeySet jsonWebKeySet = OidcJsonWebKeystoreGeneratorService.toJsonWebKeyStore(resource);
        return OidcDefaultJsonWebKeystoreCacheLoader.getJsonWebKeysFromJwks(jsonWebKeySet, cacheKey);
    }

    protected Optional<JsonWebKeySet> buildJsonWebKeySet(OidcJsonWebKeyCacheKey cacheKey) {
        try {
            Resource resource = this.generateJwksResource();
            if (resource == null) {
                LOGGER.warn("Unable to load or generate a JWKS resource");
                return Optional.empty();
            }
            LOGGER.trace("Retrieving default JSON web key from [{}]", (Object)resource);
            JsonWebKeySet jsonWebKeySet = this.buildJsonWebKeySet(resource, cacheKey);
            if (jsonWebKeySet == null || jsonWebKeySet.getJsonWebKeys().isEmpty()) {
                LOGGER.warn("No JSON web keys could be found");
                return Optional.empty();
            }
            long badKeysCount = jsonWebKeySet.getJsonWebKeys().stream().filter(k -> StringUtils.isBlank((CharSequence)k.getAlgorithm()) && StringUtils.isBlank((CharSequence)k.getKeyId()) && StringUtils.isBlank((CharSequence)k.getKeyType())).count();
            if (badKeysCount == (long)jsonWebKeySet.getJsonWebKeys().size()) {
                LOGGER.warn("No valid JSON web keys could be found. The keys that are found in the keystore do not define an algorithm, key id or key type and cannot be used for JWKS operations.");
                return Optional.empty();
            }
            return Optional.of(jsonWebKeySet);
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            return Optional.empty();
        }
    }

    protected Resource generateJwksResource() throws Exception {
        Resource resource = this.getOidcJsonWebKeystoreGeneratorService().generate();
        LOGGER.debug("Loading default JSON web key from [{}]", (Object)resource);
        return resource;
    }

    @Generated
    public OidcDefaultJsonWebKeystoreCacheLoader(OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService) {
        this.oidcJsonWebKeystoreGeneratorService = oidcJsonWebKeystoreGeneratorService;
    }

    @Generated
    public OidcJsonWebKeystoreGeneratorService getOidcJsonWebKeystoreGeneratorService() {
        return this.oidcJsonWebKeystoreGeneratorService;
    }
}

