/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.effect;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.effect.Effect;
import com.googlecode.wicket.jquery.ui.effect.EffectAdapter;
import com.googlecode.wicket.jquery.ui.effect.IEffectListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public class JQueryEffectBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "effect";
    private static final int SPEED = 500;
    private final IEffectListener listener;
    private int speed;
    private String effect;
    private JQueryAjaxBehavior callback = null;

    public static String toString(String selector, Effect effect) {
        return JQueryEffectBehavior.toString(selector, effect.toString());
    }

    public static String toString(String selector, String effect) {
        return new JQueryEffectBehavior(selector, effect, new EffectAdapter()).toString();
    }

    JQueryEffectBehavior(String selector, IEffectListener listener) {
        this(selector, null, new Options(), listener);
    }

    public JQueryEffectBehavior(String selector, String effect, IEffectListener listener) {
        this(selector, effect, new Options(), listener);
    }

    public JQueryEffectBehavior(String selector, String effect, Options options, IEffectListener listener) {
        this(selector, effect, options, 500, listener);
    }

    public JQueryEffectBehavior(String selector, String effect, int speed, IEffectListener listener) {
        this(selector, effect, new Options(), speed, listener);
    }

    public JQueryEffectBehavior(String selector, String effect, Options options, int speed, IEffectListener listener) {
        super(selector, "effect-" + effect, options);
        this.listener = (IEffectListener)Args.notNull((Object)listener, (String)"listener");
        this.effect = effect;
        this.speed = speed;
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isCallbackEnabled()) {
            this.callback = this.newCallbackBehavior();
            component.add(new Behavior[]{this.callback});
        }
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof CallbackEvent) {
            this.listener.onEffectComplete(target);
        }
    }

    protected String $() {
        return this.$(this.effect, this.options.toString());
    }

    public String $(String effect) {
        return this.$(effect, Options.asString((String)""));
    }

    public String $(String effect, String options) {
        return JQueryEffectBehavior.$(this.selector, effect, options, this.speed, String.format("%s", this.callback != null ? this.callback.getCallbackScript() : ""));
    }

    private static String $(String selector, String effect, String options, int speed, String callback) {
        if (effect != null) {
            return String.format("jQuery('%s').%s('%s', %s, %d, function() { %s });", selector, METHOD, effect, options, speed, callback);
        }
        return null;
    }

    protected JQueryAjaxBehavior newCallbackBehavior() {
        return new JQueryAjaxBehavior(this){
            private static final long serialVersionUID = 1L;

            protected JQueryEvent newEvent() {
                return new CallbackEvent();
            }
        };
    }

    protected static class CallbackEvent
    extends JQueryEvent {
        protected CallbackEvent() {
        }
    }
}

