/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.inline;

import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.EngineEventUtils;
import org.thymeleaf.engine.TemplateManager;
import org.thymeleaf.engine.TemplateModel;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.inline.IInliner;
import org.thymeleaf.model.ICDATASection;
import org.thymeleaf.model.IComment;
import org.thymeleaf.model.IText;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.processor.text.ITextProcessor;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.EscapedAttributeUtils;
import org.thymeleaf.util.FastStringWriter;
import org.thymeleaf.util.LazyProcessingCharSequence;
import org.thymeleaf.util.Validate;

public abstract class AbstractStandardInliner
implements IInliner {
    private final TemplateMode templateMode;
    private final boolean writeTextsToOutput;

    protected AbstractStandardInliner(IEngineConfiguration configuration, TemplateMode templateMode) {
        Validate.notNull(configuration, "Engine configuration cannot be null");
        Validate.notNull((Object)templateMode, "Template Mode cannot be null");
        this.templateMode = templateMode;
        Set<IPostProcessor> postProcessors = configuration.getPostProcessors(this.templateMode);
        Set<ITextProcessor> textProcessors = configuration.getTextProcessors(this.templateMode);
        this.writeTextsToOutput = postProcessors.isEmpty() && textProcessors.size() <= 1;
    }

    @Override
    public final String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final CharSequence inline(ITemplateContext context, IText text) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(text, "Text cannot be null");
        if (context.getTemplateMode() != this.templateMode) {
            return this.inlineSwitchTemplateMode(context, text);
        }
        if (!EngineEventUtils.isInlineable(text)) {
            return null;
        }
        int textLen = text.length();
        StringBuilder strBuilder = new StringBuilder(textLen + textLen / 2);
        this.performInlining(context, text, 0, textLen, text.getTemplateName(), text.getLine(), text.getCol(), strBuilder);
        return strBuilder.toString();
    }

    private CharSequence inlineSwitchTemplateMode(ITemplateContext context, IText text) {
        TemplateManager templateManager = context.getConfiguration().getTemplateManager();
        TemplateModel templateModel = templateManager.parseString(context.getTemplateData(), text.getText(), text.getLine(), text.getCol(), this.templateMode, true);
        if (!this.writeTextsToOutput) {
            FastStringWriter stringWriter = new FastStringWriter(50);
            templateManager.process(templateModel, context, stringWriter);
            return ((Object)stringWriter).toString();
        }
        return new LazyProcessingCharSequence(context, templateModel);
    }

    @Override
    public final CharSequence inline(ITemplateContext context, ICDATASection cdataSection) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(cdataSection, "CDATA Section cannot be null");
        if (context.getTemplateMode() != this.templateMode) {
            return this.inlineSwitchTemplateMode(context, cdataSection);
        }
        if (!EngineEventUtils.isInlineable(cdataSection)) {
            return null;
        }
        int cdataSectionLen = cdataSection.length();
        StringBuilder strBuilder = new StringBuilder(cdataSectionLen + cdataSectionLen / 2);
        this.performInlining(context, cdataSection, 9, cdataSectionLen - 12, cdataSection.getTemplateName(), cdataSection.getLine(), cdataSection.getCol(), strBuilder);
        return strBuilder.toString();
    }

    private CharSequence inlineSwitchTemplateMode(ITemplateContext context, ICDATASection cdataSection) {
        TemplateManager templateManager = context.getConfiguration().getTemplateManager();
        TemplateModel templateModel = templateManager.parseString(context.getTemplateData(), cdataSection.getContent(), cdataSection.getLine(), cdataSection.getCol() + 9, this.templateMode, true);
        FastStringWriter stringWriter = new FastStringWriter(50);
        templateManager.process(templateModel, context, stringWriter);
        return ((Object)stringWriter).toString();
    }

    @Override
    public final CharSequence inline(ITemplateContext context, IComment comment) {
        Validate.notNull(context, "Context cannot be null");
        Validate.notNull(comment, "Comment cannot be null");
        if (context.getTemplateMode() != this.templateMode) {
            return this.inlineSwitchTemplateMode(context, comment);
        }
        if (!EngineEventUtils.isInlineable(comment)) {
            return null;
        }
        int commentLen = comment.length();
        StringBuilder strBuilder = new StringBuilder(commentLen + commentLen / 2);
        this.performInlining(context, comment, 4, commentLen - 7, comment.getTemplateName(), comment.getLine(), comment.getCol(), strBuilder);
        return strBuilder.toString();
    }

    private CharSequence inlineSwitchTemplateMode(ITemplateContext context, IComment comment) {
        TemplateManager templateManager = context.getConfiguration().getTemplateManager();
        TemplateModel templateModel = templateManager.parseString(context.getTemplateData(), comment.getContent(), comment.getLine(), comment.getCol() + 4, this.templateMode, true);
        FastStringWriter stringWriter = new FastStringWriter(50);
        templateManager.process(templateModel, context, stringWriter);
        return ((Object)stringWriter).toString();
    }

    private void performInlining(ITemplateContext context, CharSequence text, int offset, int len, String templateName, int line, int col, StringBuilder strBuilder) {
        int i;
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(context.getConfiguration());
        int[] locator = new int[]{line, col};
        int current = i = offset;
        int maxi = offset + len;
        int currentLine = -1;
        int currentCol = -1;
        int innerClosingChar = 0;
        boolean inExpression = false;
        while (i < maxi) {
            currentLine = locator[0];
            currentCol = locator[1];
            if (!inExpression) {
                int expStart = AbstractStandardInliner.findNextStructureStart(text, i, maxi, locator);
                if (expStart == -1) {
                    strBuilder.append(text, current, maxi);
                    return;
                }
                inExpression = true;
                if (expStart > current) {
                    strBuilder.append(text, current, expStart);
                }
                innerClosingChar = text.charAt(expStart + 1) == '[' ? 93 : 41;
                current = expStart;
                i = current + 2;
                continue;
            }
            int expEnd = AbstractStandardInliner.findNextStructureEndAvoidQuotes(text, i, maxi, (char)innerClosingChar, locator);
            if (expEnd < 0) {
                strBuilder.append(text, current, maxi);
                return;
            }
            String expression = text.subSequence(current + 2, expEnd).toString();
            boolean escape = innerClosingChar == 93;
            strBuilder.append(this.processExpression(context, expressionParser, expression, escape, templateName, currentLine, currentCol + 2));
            AbstractStandardInliner.countChar(locator, text.charAt(expEnd));
            AbstractStandardInliner.countChar(locator, text.charAt(expEnd + 1));
            inExpression = false;
            i = current = expEnd + 2;
        }
        if (inExpression) {
            strBuilder.append(text, current, maxi);
        }
    }

    private static void countChar(int[] locator, char c) {
        if (c == '\n') {
            locator[0] = locator[0] + 1;
            locator[1] = 1;
            return;
        }
        locator[1] = locator[1] + 1;
    }

    private static int findNextStructureStart(CharSequence text, int offset, int maxi, int[] locator) {
        int colIndex = offset;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text.charAt(i);
            if (c == '\n') {
                colIndex = i;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (c == '[' && n > 0 && ((c = text.charAt(i + 1)) == '[' || c == '(')) {
                locator[1] = locator[1] + (i - colIndex);
                return i;
            }
            ++i;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    private static int findNextStructureEndAvoidQuotes(CharSequence text, int offset, int maxi, char innerClosingChar, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int colIndex = offset;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text.charAt(i);
            if (c == '\n') {
                colIndex = i;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (c == '\"' && !inApos) {
                inQuotes = !inQuotes;
            } else if (c == '\'' && !inQuotes) {
                inApos = !inApos;
            } else if (c == innerClosingChar && !inQuotes && !inApos && n > 0 && (c = text.charAt(i + 1)) == ']') {
                locator[1] = locator[1] + (i - colIndex);
                return i;
            }
            ++i;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    private String processExpression(ITemplateContext context, IStandardExpressionParser expressionParser, String expression, boolean escape, String templateName, int line, int col) {
        try {
            Object expressionResult;
            String unescapedExpression = EscapedAttributeUtils.unescapeAttribute(context.getTemplateMode(), expression);
            if (unescapedExpression != null) {
                IStandardExpression expressionObj = expressionParser.parseExpression(context, unescapedExpression);
                expressionResult = expressionObj.execute(context);
            } else {
                expressionResult = null;
            }
            if (escape) {
                return this.produceEscapedOutput(expressionResult);
            }
            return expressionResult == null ? "" : expressionResult.toString();
        }
        catch (TemplateProcessingException e) {
            if (!e.hasTemplateName()) {
                e.setTemplateName(templateName);
            }
            if (!e.hasLineAndCol()) {
                e.setLineAndCol(line, col);
            }
            throw e;
        }
        catch (Exception e) {
            throw new TemplateProcessingException("Error during execution of inlined expression '" + expression + "'", templateName, line, col, e);
        }
    }

    protected abstract String produceEscapedOutput(Object var1);
}

