/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.consent.ConsentEngine;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.AbstractConsentAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CheckConsentRequiredAction
extends AbstractConsentAction {
    public static final String EVENT_ID_CONSENT_REQUIRED = "consentRequired";
    private final ConsentActivationStrategy consentActivationStrategy;

    public CheckConsentRequiredAction(ServicesManager servicesManager, AuthenticationServiceSelectionPlan strategies, ConsentEngine consentEngine, CasConfigurationProperties casProperties, AttributeDefinitionStore attributeDefinitionStore, ConfigurableApplicationContext applicationContext, ConsentActivationStrategy consentActivationStrategy) {
        super(casProperties, servicesManager, strategies, consentEngine, attributeDefinitionStore, applicationContext);
        this.consentActivationStrategy = consentActivationStrategy;
    }

    public Event doExecute(RequestContext requestContext) {
        String consentEvent = this.determineConsentEvent(requestContext);
        if (StringUtils.isBlank((CharSequence)consentEvent)) {
            return null;
        }
        this.prepareConsentForRequestContext(requestContext);
        return new EventFactorySupport().event((Object)this, consentEvent);
    }

    protected String determineConsentEvent(RequestContext requestContext) {
        WebApplicationService webService = WebUtils.getService((RequestContext)requestContext);
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)webService);
        if (service == null) {
            return null;
        }
        RegisteredService registeredService = this.getRegisteredServiceForConsent(requestContext, service);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        if (authentication == null) {
            return null;
        }
        return this.isConsentRequired(service, registeredService, authentication, requestContext);
    }

    protected String isConsentRequired(Service service, RegisteredService registeredService, Authentication authentication, RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        boolean required = this.consentActivationStrategy.isConsentRequired(service, registeredService, authentication, request);
        return required ? EVENT_ID_CONSENT_REQUIRED : null;
    }
}

