/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation.checker;

import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.revocation.RevokedCertificateException;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.RevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.DenyRevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.ThresholdExpiredCRLRevocationPolicy;
import org.apereo.cas.util.crypto.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCRLRevocationChecker
implements RevocationChecker {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCRLRevocationChecker.class);
    protected final boolean checkAll;
    private final RevocationPolicy<Void> unavailableCRLPolicy;
    private final RevocationPolicy<X509CRL> expiredCRLPolicy;

    protected AbstractCRLRevocationChecker(boolean checkAll, RevocationPolicy<Void> unavailableCRLPolicy, RevocationPolicy<X509CRL> expiredCRLPolicy) {
        this.checkAll = checkAll;
        this.unavailableCRLPolicy = Objects.requireNonNullElseGet(unavailableCRLPolicy, DenyRevocationPolicy::new);
        this.expiredCRLPolicy = Objects.requireNonNullElseGet(expiredCRLPolicy, () -> new ThresholdExpiredCRLRevocationPolicy(0));
    }

    @Override
    public void check(@Nonnull X509Certificate cert) throws GeneralSecurityException {
        LOGGER.debug("Evaluating certificate revocation status for [{}]", (Object)CertUtils.toString((X509Certificate)cert));
        Collection<X509CRL> crls = this.getCRLs(cert);
        if (crls == null || crls.isEmpty()) {
            LOGGER.warn("CRL data is not available for [{}]", (Object)CertUtils.toString((X509Certificate)cert));
            this.unavailableCRLPolicy.apply(null);
            return;
        }
        ArrayList expiredCrls = new ArrayList(crls.size());
        crls.stream().filter(CertUtils::isExpired).forEach(crl -> {
            LOGGER.warn("CRL data expired on [{}]", (Object)crl.getNextUpdate());
            expiredCrls.add(crl);
        });
        if (crls.size() == expiredCrls.size()) {
            LOGGER.warn("All CRLs retrieved have expired. Applying CRL expiration policy...");
            for (X509CRL crl2 : expiredCrls) {
                this.expiredCRLPolicy.apply(crl2);
            }
        } else {
            crls.removeAll(expiredCrls);
            LOGGER.debug("Valid CRLs [{}] found that are not expired yet", crls);
            List revokedCrls = crls.stream().map(crl -> crl.getRevokedCertificate(cert)).filter(Objects::nonNull).collect(Collectors.toList());
            if (revokedCrls.size() == crls.size()) {
                X509CRLEntry entry = (X509CRLEntry)revokedCrls.get(0);
                LOGGER.warn("All CRL entries have been revoked. Rejecting the first entry [{}]", (Object)entry);
                throw new RevokedCertificateException(entry);
            }
        }
    }

    protected abstract boolean addCRL(Object var1, X509CRL var2);

    protected abstract Collection<X509CRL> getCRLs(X509Certificate var1);

    @Generated
    public boolean isCheckAll() {
        return this.checkAll;
    }

    @Generated
    public RevocationPolicy<Void> getUnavailableCRLPolicy() {
        return this.unavailableCRLPolicy;
    }

    @Generated
    public RevocationPolicy<X509CRL> getExpiredCRLPolicy() {
        return this.expiredCRLPolicy;
    }
}

