/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.kendo.ui.form.autocomplete;

import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.kendo.ui.form.autocomplete.AbstractAutoCompleteTextField;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class AutoCompleteTextField<T>
extends AbstractAutoCompleteTextField<T, T> {
    private static final long serialVersionUID = 1L;
    private final IConverter<T> converter = this.newConverter();

    protected AutoCompleteTextField(String id) {
        super(id);
    }

    protected AutoCompleteTextField(String id, ITextRenderer<? super T> renderer) {
        super(id, renderer);
    }

    protected AutoCompleteTextField(String id, Class<T> type) {
        super(id, type);
    }

    protected AutoCompleteTextField(String id, ITextRenderer<? super T> renderer, Class<T> type) {
        super(id, renderer, type);
    }

    protected AutoCompleteTextField(String id, IModel<T> model) {
        super(id, model);
    }

    protected AutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super T> renderer) {
        super(id, model, renderer);
    }

    protected AutoCompleteTextField(String id, IModel<T> model, Class<T> type) {
        super(id, model, type);
    }

    protected AutoCompleteTextField(String id, IModel<T> model, ITextRenderer<? super T> renderer, Class<T> type) {
        super(id, model, renderer, type);
    }

    protected final String getModelValue() {
        return this.renderer.getText(this.getModelObject());
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (type != null && type.isAssignableFrom(this.getType())) {
            return this.converter;
        }
        return super.getConverter(type);
    }

    @Override
    protected final void onSelected(AjaxRequestTarget target, T choice) {
        this.setModelObject(choice);
        this.onSelected(target);
    }

    protected void onSelected(AjaxRequestTarget target) {
    }

    private final IConverter<T> newConverter() {
        return new IConverter<T>(){
            private static final long serialVersionUID = 1L;

            public T convertToObject(String value, Locale locale) {
                if (value != null) {
                    if (value.equals(AutoCompleteTextField.this.getModelValue())) {
                        return AutoCompleteTextField.this.getModelObject();
                    }
                    List choices = AutoCompleteTextField.this.getChoices(value);
                    if (!choices.isEmpty()) {
                        for (Object choice : choices) {
                            if (!AutoCompleteTextField.this.renderer.getText(choice).equals(value)) continue;
                            return choice;
                        }
                    }
                }
                return null;
            }

            public String convertToString(T value, Locale locale) {
                return AutoCompleteTextField.this.renderer.getText(value);
            }
        };
    }
}

