/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.engine.impl.lock.LockManagerImpl;
import org.flowable.job.service.impl.asyncexecutor.AcquireAsyncJobsDueLifecycleListener;
import org.flowable.job.service.impl.asyncexecutor.AcquireJobsRunnableConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.cmd.AcquireJobsCmd;
import org.flowable.job.service.impl.cmd.AcquireJobsWithGlobalAcquireLockCmd;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireAsyncJobsDueRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcquireAsyncJobsDueRunnable.class);
    private static final String ACQUIRE_ASYNC_JOBS_GLOBAL_LOCK = "acquireAsyncJobsLock";
    private static final AcquireAsyncJobsDueLifecycleListener NOOP_LIFECYCLE_LISTENER = new AcquireAsyncJobsDueLifecycleListener(){

        @Override
        public void startAcquiring(String engineName, int remainingCapacity, int maxAsyncJobsDuePerAcquisition) {
        }

        @Override
        public void stopAcquiring(String engineName) {
        }

        @Override
        public void acquiredJobs(String engineName, int jobsAcquired, int maxAsyncJobsDuePerAcquisition) {
        }

        @Override
        public void rejectedJobs(String engineName, int jobsRejected, int jobsAcquired, int maxAsyncJobsDuePerAcquisition) {
        }

        @Override
        public void optimistLockingException(String engineName, int maxAsyncJobsDuePerAcquisition) {
        }

        @Override
        public void startWaiting(String engineName, long millisToWait) {
        }
    };
    protected String name;
    protected final AsyncExecutor asyncExecutor;
    protected final JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected AcquireAsyncJobsDueLifecycleListener lifecycleListener;
    protected AcquireJobsRunnableConfiguration configuration;
    protected LockManager lockManager;
    protected volatile boolean isInterrupted;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public AcquireAsyncJobsDueRunnable(String name, AsyncExecutor asyncExecutor, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager, AcquireAsyncJobsDueLifecycleListener lifecycleListener, AcquireJobsRunnableConfiguration configuration) {
        this.name = name;
        this.asyncExecutor = asyncExecutor;
        this.jobEntityManager = jobEntityManager;
        this.lifecycleListener = lifecycleListener != null ? lifecycleListener : NOOP_LIFECYCLE_LISTENER;
        this.configuration = configuration;
    }

    @Override
    public synchronized void run() {
        this.lockManager = this.createLockManager(this.asyncExecutor.getJobServiceConfiguration().getCommandExecutor());
        LOGGER.info("starting to acquire async jobs due for engine {}", (Object)this.getEngineName());
        Thread.currentThread().setName(this.name);
        CommandExecutor commandExecutor = this.asyncExecutor.getJobServiceConfiguration().getCommandExecutor();
        long millisToWait = 0L;
        while (!this.isInterrupted) {
            if (this.configuration.isGlobalAcquireLockEnabled()) {
                block6: {
                    try {
                        millisToWait = (Long)this.lockManager.waitForLockRunAndRelease(this.configuration.getLockWaitTime(), () -> this.executeAcquireCycle(commandExecutor));
                    }
                    catch (Exception e) {
                        millisToWait = this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
                        if (e instanceof FlowableException) break block6;
                        LOGGER.warn("Error while waiting for global acquire lock for engine {}", (Object)this.getEngineName(), (Object)e);
                    }
                }
                if (millisToWait == 0L) {
                    millisToWait = this.configuration.getLockPollRate().toMillis();
                }
            } else {
                millisToWait = this.executeAcquireCycle(commandExecutor);
            }
            if (millisToWait <= 0L) continue;
            this.sleep(millisToWait);
        }
        LOGGER.info("stopped async job due acquisition for engine {}", (Object)this.getEngineName());
    }

    protected LockManager createLockManager(CommandExecutor commandExecutor) {
        return new LockManagerImpl(commandExecutor, this.configuration.getGlobalAcquireLockPrefix() + ACQUIRE_ASYNC_JOBS_GLOBAL_LOCK, this.configuration.getLockPollRate(), this.configuration.getLockForceAcquireAfter(), this.getEngineName());
    }

    protected long executeAcquireCycle(CommandExecutor commandExecutor) {
        long millisToWait;
        int remainingCapacity = this.asyncExecutor.getTaskExecutor().getRemainingCapacity();
        this.lifecycleListener.startAcquiring(this.getEngineName(), remainingCapacity, this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition());
        if (remainingCapacity > 0) {
            millisToWait = this.acquireAndExecuteJobs(commandExecutor, remainingCapacity);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("acquired and queued new jobs for engine {}; sleeping for {} ms", (Object)this.getEngineName(), (Object)millisToWait);
            }
        } else {
            millisToWait = this.asyncExecutor.getDefaultQueueSizeFullWaitTimeInMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("queue is full for engine {}; sleeping for {} ms", (Object)this.getEngineName(), (Object)millisToWait);
            }
        }
        this.lifecycleListener.stopAcquiring(this.getEngineName());
        return millisToWait;
    }

    protected long acquireAndExecuteJobs(CommandExecutor commandExecutor, int remainingCapacity) {
        boolean globalAcquireLockEnabled = this.configuration.isGlobalAcquireLockEnabled();
        try {
            List acquiredJobs = globalAcquireLockEnabled ? (List)commandExecutor.execute((Command)new AcquireJobsWithGlobalAcquireLockCmd(this.asyncExecutor, remainingCapacity, this.jobEntityManager)) : (List)commandExecutor.execute((Command)new AcquireJobsCmd(this.asyncExecutor, remainingCapacity, this.jobEntityManager));
            this.lifecycleListener.acquiredJobs(this.getEngineName(), acquiredJobs.size(), this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition());
            List<JobInfoEntity> rejectedJobs = this.offerJobs(acquiredJobs);
            LOGGER.debug("Jobs acquired: {}, rejected: {}, for engine {}", new Object[]{acquiredJobs.size(), rejectedJobs.size(), this.getEngineName()});
            if (rejectedJobs.size() > 0) {
                this.lifecycleListener.rejectedJobs(this.getEngineName(), rejectedJobs.size(), acquiredJobs.size(), this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition());
                return this.asyncExecutor.getDefaultQueueSizeFullWaitTimeInMillis();
            }
            if (acquiredJobs.size() >= this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition()) {
                return 0L;
            }
        }
        catch (FlowableOptimisticLockingException optimisticLockingException) {
            this.lifecycleListener.optimistLockingException(this.getEngineName(), this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition());
            if (globalAcquireLockEnabled) {
                LOGGER.warn("Optimistic locking exception (using global acquire lock) for engine {}", (Object)this.getEngineName(), (Object)optimisticLockingException);
            } else {
                LOGGER.debug("Optimistic locking exception during async job acquisition. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire a due async job, which already was acquired by another async executor acquisition thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple async executor acquisition threads running against the same database. For engine {}. Exception message: {}", (Object)this.getEngineName(), (Object)optimisticLockingException.getMessage());
            }
        }
        catch (Throwable e) {
            LOGGER.warn("exception for engine {} during async job acquisition: {}", new Object[]{this.getEngineName(), e.getMessage(), e});
        }
        return this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
    }

    protected List<JobInfoEntity> offerJobs(List<? extends JobInfoEntity> acquiredJobs) {
        ArrayList<JobInfoEntity> rejected = new ArrayList<JobInfoEntity>();
        for (JobInfoEntity jobInfoEntity : acquiredJobs) {
            boolean jobSuccessFullyOffered = this.asyncExecutor.executeAsyncJob(jobInfoEntity);
            if (jobSuccessFullyOffered) continue;
            rejected.add(jobInfoEntity);
        }
        return rejected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(long millisToWait) {
        if (millisToWait > 0L) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("async job acquisition for engine {}, thread sleeping for {} millis", (Object)this.getEngineName(), (Object)millisToWait);
                }
                Object object = this.MONITOR;
                synchronized (object) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.lifecycleListener.startWaiting(this.getEngineName(), millisToWait);
                        this.MONITOR.wait(millisToWait);
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("async job acquisition for engine {}, thread woke up", (Object)this.getEngineName());
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("async job acquisition for engine {}, wait interrupted", (Object)this.getEngineName());
                }
            }
            finally {
                this.isWaiting.set(false);
            }
        }
    }

    protected String getEngineName() {
        return this.asyncExecutor.getJobServiceConfiguration().getEngineName();
    }

    public AcquireAsyncJobsDueLifecycleListener getLifecycleListener() {
        return this.lifecycleListener;
    }

    public void setLifecycleListener(AcquireAsyncJobsDueLifecycleListener lifecycleListener) {
        this.lifecycleListener = lifecycleListener;
    }

    public void setConfiguration(AcquireJobsRunnableConfiguration configuration) {
        this.configuration = configuration;
    }
}

