/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncRegionLocatorHelper;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.MetaCacheUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncRegionLocationCache {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRegionLocationCache.class);
    private final ConcurrentNavigableMap<byte[], RegionLocations> cache = new ConcurrentSkipListMap<byte[], RegionLocations>(Bytes.BYTES_COMPARATOR);
    private final TableName tableName;

    public AsyncRegionLocationCache(TableName tableName) {
        this.tableName = tableName;
    }

    public synchronized RegionLocations add(RegionLocations locs) {
        byte[] startKey = locs.getRegionLocation().getRegion().getStartKey();
        RegionLocations oldLocs = this.cache.putIfAbsent(startKey, locs);
        if (oldLocs == null) {
            MetaCacheUtil.cleanProblematicOverlappedRegions(locs, this.cache);
            return locs;
        }
        RegionInfo region = locs.getRegionLocation().getRegion();
        RegionInfo oldRegion = oldLocs.getRegionLocation().getRegion();
        if (region.getEncodedName().equals(oldRegion.getEncodedName())) {
            RegionLocations mergedLocs = oldLocs.mergeLocations(locs);
            if (this.isEqual(mergedLocs, oldLocs)) {
                LOG.trace("Will not add {} to cache because the old value {}  is newer than us or has the same server name. Maybe it is updated before we replace it", (Object)locs, (Object)oldLocs);
                return oldLocs;
            }
            locs = mergedLocs;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("The newly fetch region {} is different from the old one {} for row '{}', try replaying the old one...", new Object[]{region, oldRegion, Bytes.toStringBinary((byte[])startKey)});
        }
        this.cache.put(startKey, locs);
        MetaCacheUtil.cleanProblematicOverlappedRegions(locs, this.cache);
        return locs;
    }

    private boolean isEqual(RegionLocations locs1, RegionLocations locs2) {
        HRegionLocation[] locArr2;
        HRegionLocation[] locArr1 = locs1.getRegionLocations();
        if (locArr1.length != (locArr2 = locs2.getRegionLocations()).length) {
            return false;
        }
        for (int i = 0; i < locArr1.length; ++i) {
            HRegionLocation loc1 = locArr1[i];
            HRegionLocation loc2 = locArr2[i];
            if (loc1 == null) {
                if (loc2 == null) continue;
                return false;
            }
            if (loc2 == null) {
                return false;
            }
            if (loc1.getSeqNum() != loc2.getSeqNum()) {
                return false;
            }
            if (Objects.equal((Object)loc1.getServerName(), (Object)loc2.getServerName())) continue;
            return false;
        }
        return true;
    }

    public Collection<RegionLocations> getAll() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    public RegionLocations get(byte[] startKey) {
        return (RegionLocations)this.cache.get(startKey);
    }

    public RegionLocations findForRow(byte[] row, int replicaId) {
        Map.Entry entry = this.cache.floorEntry(row);
        if (entry == null) {
            return null;
        }
        RegionLocations locs = (RegionLocations)entry.getValue();
        if (locs == null) {
            return null;
        }
        HRegionLocation loc = locs.getRegionLocation(replicaId);
        if (loc == null) {
            return null;
        }
        byte[] endKey = loc.getRegion().getEndKey();
        if (ConnectionUtils.isEmptyStopRow(endKey) || Bytes.compareTo((byte[])row, (byte[])endKey) < 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found {} in cache for {}, row='{}', locateType={}, replicaId={}", new Object[]{loc, this.tableName, Bytes.toStringBinary((byte[])row), RegionLocateType.CURRENT, replicaId});
            }
            return locs;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Requested row {} comes after region end key of {} for cached location {}", new Object[]{Bytes.toStringBinary((byte[])row), Bytes.toStringBinary((byte[])endKey), locs});
        }
        return null;
    }

    public RegionLocations findForBeforeRow(byte[] row, int replicaId) {
        Map.Entry entry;
        boolean isEmptyStopRow = ConnectionUtils.isEmptyStopRow(row);
        Map.Entry entry2 = entry = isEmptyStopRow ? this.cache.lastEntry() : this.cache.lowerEntry(row);
        if (entry == null) {
            return null;
        }
        RegionLocations locs = (RegionLocations)entry.getValue();
        if (locs == null) {
            return null;
        }
        HRegionLocation loc = locs.getRegionLocation(replicaId);
        if (loc == null) {
            return null;
        }
        if (ConnectionUtils.isEmptyStopRow(loc.getRegion().getEndKey()) || !isEmptyStopRow && Bytes.compareTo((byte[])loc.getRegion().getEndKey(), (byte[])row) >= 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found {} in cache for {}, row='{}', locateType={}, replicaId={}", new Object[]{loc, this.tableName, Bytes.toStringBinary((byte[])row), RegionLocateType.BEFORE, replicaId});
            }
            return locs;
        }
        return null;
    }

    public synchronized boolean remove(HRegionLocation loc) {
        byte[] startKey = loc.getRegion().getStartKey();
        RegionLocations oldLocs = (RegionLocations)this.cache.get(startKey);
        if (oldLocs == null) {
            return false;
        }
        HRegionLocation oldLoc = oldLocs.getRegionLocation(loc.getRegion().getReplicaId());
        if (!AsyncRegionLocatorHelper.canUpdateOnError(loc, oldLoc)) {
            return false;
        }
        RegionLocations newLocs = AsyncRegionLocatorHelper.removeRegionLocation(oldLocs, loc.getRegion().getReplicaId());
        if (newLocs == null) {
            return this.cache.remove(startKey, oldLocs);
        }
        this.cache.put(startKey, newLocs);
        return true;
    }

    public int size() {
        return this.cache.size();
    }

    public synchronized void removeForServer(ServerName serverName) {
        for (Map.Entry entry : this.cache.entrySet()) {
            RegionLocations newLocs;
            byte[] regionName = (byte[])entry.getKey();
            RegionLocations locs = (RegionLocations)entry.getValue();
            if (locs == (newLocs = locs.removeByServer(serverName))) continue;
            if (newLocs.isEmpty()) {
                this.cache.remove(regionName, locs);
                continue;
            }
            this.cache.put(regionName, newLocs);
        }
    }
}

