/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyServerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class JettyModernServerAdapter
extends JettyServerAdapter {
    public JettyModernServerAdapter(Request jettyRequest, Response jettyResponse) {
        super(jettyRequest, jettyResponse);
    }

    @Override
    public long getContentLength() {
        return Response.getContentBytesWritten((Response)this.response);
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatus();
    }

    @Override
    public long getRequestTimestamp() {
        return Request.getTimeStamp((Request)this.request);
    }

    @Override
    public Map<String, String> buildResponseHeaderMap() {
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        HttpFields.Mutable httpFields = this.response.getHeaders();
        for (HttpField field : httpFields) {
            String key = field.getName();
            String value = field.getValue();
            responseHeaderMap.put(key, value);
        }
        return responseHeaderMap;
    }
}

