/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.alg;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.shade.org.jgrapht.graph.DirectedSubgraph;
import org.apache.storm.shade.org.jgrapht.graph.EdgeReversedGraph;

public class StrongConnectivityInspector<V, E> {
    private final DirectedGraph<V, E> graph;
    private LinkedList<VertexData<V>> orderedVertices;
    private List<Set<V>> stronglyConnectedSets;
    private List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs;
    private Map<V, VertexData<V>> vertexToVertexData;

    public StrongConnectivityInspector(DirectedGraph<V, E> directedGraph) {
        if (directedGraph == null) {
            throw new IllegalArgumentException("null not allowed for graph!");
        }
        this.graph = directedGraph;
        this.vertexToVertexData = null;
        this.orderedVertices = null;
        this.stronglyConnectedSets = null;
        this.stronglyConnectedSubgraphs = null;
    }

    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    public boolean isStronglyConnected() {
        return this.stronglyConnectedSets().size() == 1;
    }

    public List<Set<V>> stronglyConnectedSets() {
        if (this.stronglyConnectedSets == null) {
            this.orderedVertices = new LinkedList();
            this.stronglyConnectedSets = new Vector<Set<V>>();
            this.createVertexData();
            for (VertexData<V> data : this.vertexToVertexData.values()) {
                if (((VertexData)data).isDiscovered()) continue;
                this.dfsVisit(this.graph, data, null);
            }
            EdgeReversedGraph<V, E> inverseGraph = new EdgeReversedGraph<V, E>(this.graph);
            this.resetVertexData();
            for (VertexData vertexData : this.orderedVertices) {
                if (vertexData.isDiscovered()) continue;
                HashSet set = new HashSet();
                this.stronglyConnectedSets.add(set);
                this.dfsVisit(inverseGraph, vertexData, set);
            }
            this.orderedVertices = null;
            this.vertexToVertexData = null;
        }
        return this.stronglyConnectedSets;
    }

    public List<DirectedSubgraph<V, E>> stronglyConnectedSubgraphs() {
        if (this.stronglyConnectedSubgraphs == null) {
            List<Set<V>> sets = this.stronglyConnectedSets();
            this.stronglyConnectedSubgraphs = new Vector<DirectedSubgraph<V, E>>(sets.size());
            for (Set<V> set : sets) {
                this.stronglyConnectedSubgraphs.add(new DirectedSubgraph<V, E>(this.graph, set, null));
            }
        }
        return this.stronglyConnectedSubgraphs;
    }

    private void createVertexData() {
        this.vertexToVertexData = new HashMap<V, VertexData<V>>(this.graph.vertexSet().size());
        for (Object vertex : this.graph.vertexSet()) {
            this.vertexToVertexData.put(vertex, new VertexData2(vertex, false, false));
        }
    }

    private void dfsVisit(DirectedGraph<V, E> visitedGraph, VertexData<V> vertexData, Set<V> vertices) {
        ArrayDeque<VertexData<V>> stack = new ArrayDeque<VertexData<V>>();
        stack.add(vertexData);
        while (!stack.isEmpty()) {
            VertexData data = (VertexData)stack.removeLast();
            if (!data.isDiscovered()) {
                data.setDiscovered(true);
                if (vertices != null) {
                    vertices.add(data.getVertex());
                }
                stack.add(new VertexData1(data, true, true));
                for (E edge : visitedGraph.outgoingEdgesOf(data.getVertex())) {
                    VertexData<V> targetData = this.vertexToVertexData.get(visitedGraph.getEdgeTarget(edge));
                    if (((VertexData)targetData).isDiscovered()) continue;
                    stack.add(targetData);
                }
                continue;
            }
            if (!data.isFinished() || vertices != null) continue;
            this.orderedVertices.addFirst(data.getFinishedData());
        }
    }

    private void resetVertexData() {
        for (VertexData<V> data : this.vertexToVertexData.values()) {
            ((VertexData)data).setDiscovered(false);
            ((VertexData)data).setFinished(false);
        }
    }

    private static final class VertexData2<V>
    extends VertexData<V> {
        private final V vertex;

        private VertexData2(V vertex, boolean discovered, boolean finished) {
            super(discovered, finished);
            this.vertex = vertex;
        }

        @Override
        VertexData<V> getFinishedData() {
            return null;
        }

        @Override
        V getVertex() {
            return this.vertex;
        }
    }

    private static final class VertexData1<V>
    extends VertexData<V> {
        private final VertexData<V> finishedData;

        private VertexData1(VertexData<V> finishedData, boolean discovered, boolean finished) {
            super(discovered, finished);
            this.finishedData = finishedData;
        }

        @Override
        VertexData<V> getFinishedData() {
            return this.finishedData;
        }

        @Override
        V getVertex() {
            return null;
        }
    }

    private static abstract class VertexData<V> {
        private byte bitfield = 0;

        private VertexData(boolean discovered, boolean finished) {
            this.setDiscovered(discovered);
            this.setFinished(finished);
        }

        private boolean isDiscovered() {
            return (this.bitfield & 1) == 1;
        }

        private boolean isFinished() {
            return (this.bitfield & 2) == 2;
        }

        private void setDiscovered(boolean discovered) {
            this.bitfield = discovered ? (byte)(this.bitfield | 1) : (byte)(this.bitfield & 0xFFFFFFFE);
        }

        private void setFinished(boolean finished) {
            this.bitfield = finished ? (byte)(this.bitfield | 2) : (byte)(this.bitfield & 0xFFFFFFFD);
        }

        abstract VertexData<V> getFinishedData();

        abstract V getVertex();
    }
}

