/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class RoutingHandler
extends Handler.AbstractContainer {
    private final Entry[] entries;

    public RoutingHandler(Map<Connector, Handler> handlers) {
        this.entries = new Entry[handlers.size()];
        int i = 0;
        for (Map.Entry<Connector, Handler> entry : handlers.entrySet()) {
            this.entries[i++] = new Entry(entry.getKey(), entry.getValue());
            this.addBean(entry.getValue());
        }
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Connector connector = request.getConnectionMetaData().getConnector();
        for (Entry entry : this.entries) {
            if (entry.connector != connector || !entry.handler.handle(request, response, callback)) continue;
            return true;
        }
        return false;
    }

    public List<Handler> getHandlers() {
        return Arrays.stream(this.entries).map(Entry::handler).toList();
    }

    private record Entry(Connector connector, Handler handler) {
    }
}

