/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import org.apache.storm.messaging.netty.SaslNettyServer;
import org.apache.storm.messaging.netty.SaslNettyServerState;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslStormServerAuthorizeHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SaslStormServerAuthorizeHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg == null) {
            return;
        }
        LOG.debug("messageReceived: Checking whether the client is authorized to send messages to the server ");
        SaslNettyServer saslNettyServer = (SaslNettyServer)ctx.channel().attr(SaslNettyServerState.SASL_NETTY_SERVER).get();
        if (saslNettyServer == null) {
            LOG.warn("messageReceived: This client is *NOT* authorized to perform this action since there's no saslNettyServer to authenticate the client: refusing to perform requested action: " + String.valueOf(msg));
            return;
        }
        if (!saslNettyServer.isComplete()) {
            LOG.warn("messageReceived: This client is *NOT* authorized to perform this action because SASL authentication did not complete: refusing to perform requested action: " + String.valueOf(msg));
            return;
        }
        LOG.debug("messageReceived: authenticated client: " + saslNettyServer.getUserName() + " is authorized to do request on server.");
        ctx.fireChannelRead(msg);
    }
}

