/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.alg;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.UndirectedGraph;
import org.apache.storm.shade.org.jgrapht.alg.util.VertexDegreeComparator;
import org.apache.storm.shade.org.jgrapht.graph.UndirectedSubgraph;

public abstract class ChromaticNumber {
    public static <V, E> int findGreedyChromaticNumber(UndirectedGraph<V, E> g) {
        Map<Integer, Set<V>> coloredGroups = ChromaticNumber.findGreedyColoredGroups(g);
        return coloredGroups.keySet().size();
    }

    public static <V, E> Map<Integer, Set<V>> findGreedyColoredGroups(UndirectedGraph<V, E> g) {
        UndirectedSubgraph sg = new UndirectedSubgraph(g, null, null);
        VertexDegreeComparator<V, E> comp = new VertexDegreeComparator<V, E>(sg);
        LinkedList sortedVertices = new LinkedList(sg.vertexSet());
        Collections.sort(sortedVertices, comp);
        Collections.reverse(sortedVertices);
        HashMap coloredGroups = new HashMap();
        int color = 0;
        while (sg.vertexSet().size() > 0) {
            HashSet currentColor = new HashSet();
            Iterator iter2 = sortedVertices.iterator();
            while (iter2.hasNext()) {
                Object v = iter2.next();
                boolean flag = true;
                for (Object temp : currentColor) {
                    if (!sg.containsEdge(temp, v)) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                currentColor.add(v);
                iter2.remove();
            }
            coloredGroups.put(color, currentColor);
            sg.removeAllVertices(currentColor);
            ++color;
        }
        return coloredGroups;
    }
}

