/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.windowing;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.storm.serialization.SerializationFactory;

public class WindowKryoSerializer {
    private final Kryo kryo;
    private final Output output;
    private final Input input;

    public WindowKryoSerializer(Map<String, Object> topoConf) {
        this.kryo = SerializationFactory.getKryo(topoConf);
        this.output = new Output(2000, 2000000000);
        this.input = new Input();
    }

    public byte[] serialize(Object obj) {
        this.output.reset();
        this.kryo.writeClassAndObject(this.output, obj);
        return this.output.toBytes();
    }

    public ByteBuffer serializeToByteBuffer(Object obj) {
        this.output.reset();
        this.kryo.writeClassAndObject(this.output, obj);
        return ByteBuffer.wrap(this.output.getBuffer(), 0, this.output.position());
    }

    public Object deserialize(byte[] buff) {
        this.input.setBuffer(buff);
        return this.kryo.readClassAndObject(this.input);
    }

    public Object deserialize(ByteBuffer byteBuffer) {
        this.input.setBuffer(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.position());
        return this.kryo.readClassAndObject(this.input);
    }
}

