/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.text;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.LocalTransformations;
import org.sparkproject.dmg.pmml.MathContext;
import org.sparkproject.dmg.pmml.MiningFunction;
import org.sparkproject.dmg.pmml.MiningSchema;
import org.sparkproject.dmg.pmml.Model;
import org.sparkproject.dmg.pmml.ModelExplanation;
import org.sparkproject.dmg.pmml.ModelStats;
import org.sparkproject.dmg.pmml.ModelVerification;
import org.sparkproject.dmg.pmml.Output;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Targets;
import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.sparkproject.dmg.pmml.text.DocumentTermMatrix;
import org.sparkproject.dmg.pmml.text.PMMLAttributes;
import org.sparkproject.dmg.pmml.text.PMMLElements;
import org.sparkproject.dmg.pmml.text.TextCorpus;
import org.sparkproject.dmg.pmml.text.TextDictionary;
import org.sparkproject.dmg.pmml.text.TextModelNormalization;
import org.sparkproject.dmg.pmml.text.TextModelSimiliarity;
import org.sparkproject.jpmml.model.MissingAttributeException;
import org.sparkproject.jpmml.model.MissingElementException;
import org.sparkproject.jpmml.model.annotations.Added;
import org.sparkproject.jpmml.model.annotations.CollectionElementType;
import org.sparkproject.jpmml.model.annotations.Deprecated;
import org.sparkproject.jpmml.model.annotations.Property;
import org.sparkproject.jpmml.model.annotations.Since;
import org.sparkproject.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="TextModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "textDictionary", "textCorpus", "documentTermMatrix", "textModelNormalization", "textModelSimiliarity", "modelVerification"})
@JsonRootName(value="TextModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "numberOfTerms", "numberOfDocuments", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "textDictionary", "textCorpus", "documentTermMatrix", "textModelNormalization", "textModelSimiliarity", "modelVerification"})
@Deprecated(value=Version.PMML_4_2)
public class TextModel
extends Model
implements HasExtensions<TextModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="numberOfTerms", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfTerms")
    private Integer numberOfTerms;
    @XmlAttribute(name="numberOfDocuments", required=true)
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="numberOfDocuments")
    private Integer numberOfDocuments;
    @XmlAttribute(name="isScorable")
    @JsonProperty(value="isScorable")
    @Added(value=Version.PMML_4_1, removable=true)
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @JsonProperty(value="x-mathContext")
    @Added(value=Version.XPMML, removable=true)
    @Since(value="1.3.7")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelExplanation")
    @Added(value=Version.PMML_4_0, removable=true)
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="TextDictionary", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="TextDictionary")
    private TextDictionary textDictionary;
    @XmlElement(name="TextCorpus", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="TextCorpus")
    private TextCorpus textCorpus;
    @XmlElement(name="DocumentTermMatrix", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="DocumentTermMatrix")
    private DocumentTermMatrix documentTermMatrix;
    @XmlElement(name="TextModelNormalization", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TextModelNormalization")
    private TextModelNormalization textModelNormalization;
    @XmlElement(name="TextModelSimiliarity", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="TextModelSimiliarity")
    private TextModelSimiliarity textModelSimiliarity;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371272L;

    public TextModel() {
    }

    @ValueConstructor
    public TextModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="numberOfTerms") Integer numberOfTerms, @Property(value="numberOfDocuments") Integer numberOfDocuments, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="textDictionary") TextDictionary textDictionary, @Property(value="textCorpus") TextCorpus textCorpus, @Property(value="documentTermMatrix") DocumentTermMatrix documentTermMatrix) {
        this.miningFunction = miningFunction;
        this.numberOfTerms = numberOfTerms;
        this.numberOfDocuments = numberOfDocuments;
        this.miningSchema = miningSchema;
        this.textDictionary = textDictionary;
        this.textCorpus = textCorpus;
        this.documentTermMatrix = documentTermMatrix;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public TextModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TEXTMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public TextModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public TextModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer requireNumberOfTerms() {
        if (this.numberOfTerms == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TEXTMODEL_NUMBEROFTERMS);
        }
        return this.numberOfTerms;
    }

    public Integer getNumberOfTerms() {
        return this.numberOfTerms;
    }

    public TextModel setNumberOfTerms(@Property(value="numberOfTerms") Integer numberOfTerms) {
        this.numberOfTerms = numberOfTerms;
        return this;
    }

    public Integer requireNumberOfDocuments() {
        if (this.numberOfDocuments == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TEXTMODEL_NUMBEROFDOCUMENTS);
        }
        return this.numberOfDocuments;
    }

    public Integer getNumberOfDocuments() {
        return this.numberOfDocuments;
    }

    public TextModel setNumberOfDocuments(@Property(value="numberOfDocuments") Integer numberOfDocuments) {
        this.numberOfDocuments = numberOfDocuments;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public TextModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public TextModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TextModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.TEXTMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public TextModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public TextModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public TextModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public TextModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public TextModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public TextModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public TextDictionary requireTextDictionary() {
        if (this.textDictionary == null) {
            throw new MissingElementException(this, PMMLElements.TEXTMODEL_TEXTDICTIONARY);
        }
        return this.textDictionary;
    }

    public TextDictionary getTextDictionary() {
        return this.textDictionary;
    }

    public TextModel setTextDictionary(@Property(value="textDictionary") TextDictionary textDictionary) {
        this.textDictionary = textDictionary;
        return this;
    }

    public TextCorpus requireTextCorpus() {
        if (this.textCorpus == null) {
            throw new MissingElementException(this, PMMLElements.TEXTMODEL_TEXTCORPUS);
        }
        return this.textCorpus;
    }

    public TextCorpus getTextCorpus() {
        return this.textCorpus;
    }

    public TextModel setTextCorpus(@Property(value="textCorpus") TextCorpus textCorpus) {
        this.textCorpus = textCorpus;
        return this;
    }

    public DocumentTermMatrix requireDocumentTermMatrix() {
        if (this.documentTermMatrix == null) {
            throw new MissingElementException(this, PMMLElements.TEXTMODEL_DOCUMENTTERMMATRIX);
        }
        return this.documentTermMatrix;
    }

    public DocumentTermMatrix getDocumentTermMatrix() {
        return this.documentTermMatrix;
    }

    public TextModel setDocumentTermMatrix(@Property(value="documentTermMatrix") DocumentTermMatrix documentTermMatrix) {
        this.documentTermMatrix = documentTermMatrix;
        return this;
    }

    public TextModelNormalization getTextModelNormalization() {
        return this.textModelNormalization;
    }

    public TextModel setTextModelNormalization(@Property(value="textModelNormalization") TextModelNormalization textModelNormalization) {
        this.textModelNormalization = textModelNormalization;
        return this;
    }

    public TextModelSimiliarity getTextModelSimiliarity() {
        return this.textModelSimiliarity;
    }

    public TextModel setTextModelSimiliarity(@Property(value="textModelSimiliarity") TextModelSimiliarity textModelSimiliarity) {
        this.textModelSimiliarity = textModelSimiliarity;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public TextModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getTextDictionary(), this.getTextCorpus(), this.getDocumentTermMatrix(), this.getTextModelNormalization(), this.getTextModelSimiliarity(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

