/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Sequence;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Integral;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Sequence$
implements Serializable {
    public static final Sequence$ MODULE$ = new Sequence$();

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    private String prettyName() {
        return "sequence";
    }

    public int sequenceLength(long start, long stop, long step) {
        int n;
        try {
            long len;
            long delta = Math.subtractExact(stop, start);
            if (delta == Long.MIN_VALUE && step == -1L) {
                throw new ArithmeticException("Long overflow (Long.MinValue / -1)");
            }
            long l = len = stop == start ? 1L : Math.addExact(1L, delta / step);
            if (len > 0x7FFFFFF0L) {
                throw QueryExecutionErrors$.MODULE$.createArrayWithElementsExceedLimitError(this.prettyName(), BoxesRunTime.boxToLong((long)len));
            }
            n = (int)len;
        }
        catch (ArithmeticException arithmeticException) {
            BigInt safeLen = package$.MODULE$.BigInt().apply(1).$plus(package$.MODULE$.BigInt().apply(stop).$minus(package$.MODULE$.BigInt().apply(start)).$div(package$.MODULE$.BigInt().apply(step)));
            if (safeLen.$greater((Object)BigInt$.MODULE$.int2bigInt(0x7FFFFFF0))) {
                throw QueryExecutionErrors$.MODULE$.createArrayWithElementsExceedLimitError(this.prettyName(), safeLen);
            }
            throw SparkException$.MODULE$.internalError("Unreachable code reached.");
        }
        catch (Exception e) {
            throw e;
        }
        return n;
    }

    public <U> int org$apache$spark$sql$catalyst$expressions$Sequence$$getSequenceLength(U start, U stop, Object step, U estimatedStep, Integral<U> num) {
        Predef$.MODULE$.require(num.mkOrderingOps(estimatedStep).$greater(num.zero()) && num.mkOrderingOps(start).$less$eq(stop) || num.mkOrderingOps(estimatedStep).$less(num.zero()) && num.mkOrderingOps(start).$greater$eq(stop) || BoxesRunTime.equals(estimatedStep, (Object)num.zero()) && BoxesRunTime.equals(start, stop), (Function0 & Serializable)() -> "Illegal sequence boundaries: " + start + " to " + stop + " by " + step);
        return this.sequenceLength(num.mkNumericOps(start).toLong(), num.mkNumericOps(stop).toLong(), num.mkNumericOps(estimatedStep).toLong());
    }

    public String org$apache$spark$sql$catalyst$expressions$Sequence$$genSequenceLengthCode(CodegenContext ctx, String start, String stop, String step, String estimatedStep, String len) {
        String calcFn = Sequence.class.getName() + ".sequenceLength";
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |if (!((" + estimatedStep + " > 0 && " + start + " <= " + stop + ") ||\n       |  (" + estimatedStep + " < 0 && " + start + " >= " + stop + ") ||\n       |  (" + estimatedStep + " == 0 && " + start + " == " + stop + "))) {\n       |  java.util.Map<String, String> params = new java.util.HashMap<String, String>();\n       |  params.put(\"start\", " + start + ");\n       |  params.put(\"stop\", " + stop + ");\n       |  params.put(\"step\", " + step + ");\n       |  throw new org.apache.spark.SparkIllegalArgumentException(\n       |    \"_LEGACY_ERROR_TEMP_3243\", params);\n       |}\n       |int " + len + " = " + calcFn + "((long) " + start + ", (long) " + stop + ", (long) " + estimatedStep + ");\n       "));
    }

    public Sequence apply(Expression start, Expression stop, Option<Expression> stepOpt, Option<String> timeZoneId) {
        return new Sequence(start, stop, stepOpt, timeZoneId);
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Tuple4<Expression, Expression, Option<Expression>, Option<String>>> unapply(Sequence x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.start(), (Object)x$0.stop(), x$0.stepOpt(), x$0.timeZoneId()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Sequence$.class);
    }

    private Sequence$() {
    }
}

