/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.Concat$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(col1, col2, ..., colN) - Returns the concatenation of col1, col2, ..., colN.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 'SQL');\n       SparkSQL\n      > SELECT _FUNC_(array(1, 2, 3), array(4, 5), array(6));\n       [1,2,3,4,5,6]\n  ", note="\n    Concat logic for arrays is available since 2.4.0.\n  ", group="collection_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t]d\u0001B\u0013'\u0001NB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\")\u0011\f\u0001C\u00015\")Q\f\u0001C\u0005=\"9a\r\u0001b\u0001\n\u000b:\u0007B\u0002@\u0001A\u00035\u0001\u000e\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\u000b\u0003\u001f\u0001\u0001R1A\u0005B\u0005E\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\ty\u0004\u0001C!\u0003GAq!!\u0011\u0001\t\u0003\n\u0019\u0003C\u0004\u0002D\u0001!\t%!\u0012\t\u0015\u0005e\u0003\u0001#b\u0001\n\u0013\tY\u0006C\u0004\u0002f\u0001!\t&a\u001a\t\u000f\u0005\r\u0005\u0001\"\u0003\u0002\u0006\"9\u0011q\u0012\u0001\u0005\n\u0005E\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\u0007W\u0001!\t%!\f\t\u000f\u0005\u0005\u0006\u0001\"\u0015\u0002$\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003k\u0003\u0011\u0013!C\u0001\u0003oC\u0011\"!4\u0001\u0003\u0003%\t%a4\t\u0013\u0005}\u0007!!A\u0005\u0002\u0005\u0005\b\"CAu\u0001\u0005\u0005I\u0011AAv\u0011%\t\t\u0010AA\u0001\n\u0003\n\u0019\u0010C\u0005\u0003\u0002\u0001\t\t\u0011\"\u0001\u0003\u0004!I!q\u0001\u0001\u0002\u0002\u0013\u0005#\u0011\u0002\u0005\n\u0005\u001b\u0001\u0011\u0011!C!\u0005\u001f9\u0011B!\u000f'\u0003\u0003E\tAa\u000f\u0007\u0011\u00152\u0013\u0011!E\u0001\u0005{Aa!W\u0010\u0005\u0002\tU\u0003\"CAO?\u0005\u0005IQ\tB,\u0011%\u0011IfHA\u0001\n\u0003\u0013Y\u0006C\u0005\u0003`}\t\t\u0011\"!\u0003b!I!QN\u0010\u0002\u0002\u0013%!q\u000e\u0002\u0007\u0007>t7-\u0019;\u000b\u0005\u001dB\u0013aC3yaJ,7o]5p]NT!!\u000b\u0016\u0002\u0011\r\fG/\u00197zgRT!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u001b9w\u0005;\u0005CA\u001b7\u001b\u00051\u0013BA\u001c'\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003keJ!A\u000f\u0014\u00039\r{W\u000e\u001d7fqRK\b/Z'fe\u001eLgnZ#yaJ,7o]5p]B\u0011AhP\u0007\u0002{)\u0011aHK\u0001\u0007KJ\u0014xN]:\n\u0005\u0001k$aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001\n\u0015\b\u0003\u0013:s!AS'\u000e\u0003-S!\u0001\u0014\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0015BA(D\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0015*\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005=\u001b\u0015\u0001C2iS2$'/\u001a8\u0016\u0003U\u00032\u0001\u0013,5\u0013\t9&KA\u0002TKF\f\u0011b\u00195jY\u0012\u0014XM\u001c\u0011\u0002\rqJg.\u001b;?)\tYF\f\u0005\u00026\u0001!)1k\u0001a\u0001+\u0006a\u0011\r\u001c7po\u0016$G+\u001f9fgV\tq\fE\u0002I-\u0002\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u0016\u0002\u000bQL\b/Z:\n\u0005\u0015\u0014'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u00031qw\u000eZ3QCR$XM\u001d8t+\u0005A\u0007c\u0001%WSB\u0011!n\u001f\b\u0003Wbt!\u0001\u001c<\u000f\u00055,hB\u00018u\u001d\ty7O\u0004\u0002qe:\u0011!*]\u0005\u0002c%\u0011q\u0006M\u0005\u0003[9J!a\u000b\u0017\n\u0005%R\u0013BA<)\u0003\u0015!(/Z3t\u0013\tI(0A\u0006Ue\u0016,\u0007+\u0019;uKJt'BA<)\u0013\taXPA\u0006Ue\u0016,\u0007+\u0019;uKJt'BA={\u00035qw\u000eZ3QCR$XM\u001d8tA\u0005\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u00111\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0015\u0002\u0011\u0005t\u0017\r\\=tSNLA!!\u0004\u0002\b\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0005eCR\fG+\u001f9f+\t\t\u0019\u0002E\u0002b\u0003+I1!a\u0006c\u0005!!\u0015\r^1UsB,\u0007f\u0001\u0005\u0002\u001cA\u0019!)!\b\n\u0007\u0005}1IA\u0005ue\u0006t7/[3oi\u0006Q\"/Z:vYR\f%O]1z\u000b2,W.\u001a8u\u001dVdG.\u00192mKV\u0011\u0011Q\u0005\t\u0004\u0005\u0006\u001d\u0012bAA\u0015\u0007\n9!i\\8mK\u0006t\u0017\u0001\u00036bm\u0006$\u0016\u0010]3\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003sqA!a\r\u00026A\u0011!jQ\u0005\u0004\u0003o\u0019\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002<\u0005u\"AB*ue&twMC\u0002\u00028\r\u000b\u0001B\\;mY\u0006\u0014G.Z\u0001\tM>dG-\u00192mK\u0006!QM^1m)\u0011\t9%!\u0014\u0011\u0007\t\u000bI%C\u0002\u0002L\r\u00131!\u00118z\u0011%\ty%\u0004I\u0001\u0002\u0004\t\t&A\u0003j]B,H\u000f\u0005\u0003\u0002T\u0005US\"\u0001\u0015\n\u0007\u0005]\u0003FA\u0006J]R,'O\\1m%><\u0018\u0001\u00033p\u0007>t7-\u0019;\u0016\u0005\u0005u\u0003c\u0002\"\u0002`\u0005E\u0013qI\u0005\u0004\u0003C\u001a%!\u0003$v]\u000e$\u0018n\u001c82Q\rq\u00111D\u0001\nI><UM\\\"pI\u0016$b!!\u001b\u0002v\u0005}\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=d%A\u0004d_\u0012,w-\u001a8\n\t\u0005M\u0014Q\u000e\u0002\t\u000bb\u0004(oQ8eK\"9\u0011qO\bA\u0002\u0005e\u0014aA2uqB!\u00111NA>\u0013\u0011\ti(!\u001c\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011Q\bA\u0002\u0005%\u0014AA3w\u0003i9WM\\\"pI\u00164uN\u001d(v[\n,'o\u00144FY\u0016lWM\u001c;t)\u0011\t9)!$\u0011\u000f\t\u000bI)a\f\u00020%\u0019\u00111R\"\u0003\rQ+\b\u000f\\33\u0011\u001d\t9\b\u0005a\u0001\u0003s\n\u0001cZ3o\u0007>$WMR8s\u0003J\u0014\u0018-_:\u0015\u0011\u0005=\u00121SAK\u00033Cq!a\u001e\u0012\u0001\u0004\tI\bC\u0004\u0002\u0018F\u0001\r!a\u0005\u0002\u0017\u0015dW-\\3oiRK\b/\u001a\u0005\b\u00037\u000b\u0002\u0019AA\u0013\u00031\u0019\u0007.Z2l\r>\u0014h*\u001e7m\u0003!!xn\u0015;sS:<GCAA\u0018\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002\\\u0003KCq!a*\u0015\u0001\u0004\tI+A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007\u0003\u0002%\u0002,RJ1!!,S\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010F\u0002\\\u0003gCqaU\u000b\u0011\u0002\u0003\u0007Q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e&fA+\u0002<.\u0012\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003%)hn\u00195fG.,GMC\u0002\u0002H\u000e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY-!1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0004B!a5\u0002^6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.\u0001\u0003mC:<'BAAn\u0003\u0011Q\u0017M^1\n\t\u0005m\u0012Q[\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003G\u00042AQAs\u0013\r\t9o\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000f\ni\u000fC\u0005\u0002pf\t\t\u00111\u0001\u0002d\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!>\u0011\r\u0005]\u0018Q`A$\u001b\t\tIPC\u0002\u0002|\u000e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty0!?\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003K\u0011)\u0001C\u0005\u0002pn\t\t\u00111\u0001\u0002H\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\tNa\u0003\t\u0013\u0005=H$!AA\u0002\u0005\r\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002&\tE\u0001\"CAx;\u0005\u0005\t\u0019AA$Q]\u0001!Q\u0003B\u000e\u0005;\u0011\tCa\t\u0003(\t%\"Q\u0006B\u0018\u0005g\u0011)\u0004E\u00026\u0005/I1A!\u0007'\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\b\u0002'~3UKT\"`Q\r|G.\r\u0017!G>d'\u0007\f\u0011/]9b\u0003eY8m\u001d&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043m\u001c8dCR,g.\u0019;j_:\u0004sN\u001a\u0011d_2\fD\u0006I2pYJb\u0003E\f\u0018/Y\u0001\u001aw\u000e\u001c(/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\u0013\u0003\u0005]\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148n\n\u0017!OM\u000bFjJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001a\u0014\u0006\f\u0011beJ\f\u0017\u0010\u000b\u001b-AUJC\u0006I1se\u0006L\bFN\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0016\u0007\f\u001a-g1\"D&\u000e\u00177;*\u0001\u0003%\u0001\u0003o_R,\u0017E\u0001B\u0016\u0003eR\u0001\u0005\t\u0011!\u0007>t7-\u0019;!Y><\u0017n\u0019\u0011g_J\u0004\u0013M\u001d:bsN\u0004\u0013n\u001d\u0011bm\u0006LG.\u00192mK\u0002\u001a\u0018N\\2fAIrCG\f\u0019/\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B\u0019\u0003A\u0019w\u000e\u001c7fGRLwN\\0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u00038\u0005)\u0011GL\u001b/a\u000511i\u001c8dCR\u0004\"!N\u0010\u0014\u000b}\u0011yDa\u0013\u0011\r\t\u0005#qI+\\\u001b\t\u0011\u0019EC\u0002\u0003F\r\u000bqA];oi&lW-\u0003\u0003\u0003J\t\r#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!!Q\nB*\u001b\t\u0011yE\u0003\u0003\u0003R\u0005e\u0017AA5p\u0013\r\t&q\n\u000b\u0003\u0005w!\"!!5\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007m\u0013i\u0006C\u0003TE\u0001\u0007Q+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r$\u0011\u000e\t\u0005\u0005\n\u0015T+C\u0002\u0003h\r\u0013aa\u00149uS>t\u0007\u0002\u0003B6G\u0005\u0005\t\u0019A.\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003rA!\u00111\u001bB:\u0013\u0011\u0011)(!6\u0003\r=\u0013'.Z2u\u0001")
public class Concat
extends Expression
implements ComplexTypeMergingExpression,
QueryErrorsBase,
Serializable {
    private transient DataType dataType;
    private transient Function1<InternalRow, Object> doConcat;
    private final Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(Concat x$0) {
        return Concat$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<Concat, A> g) {
        return Concat$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Concat> compose(Function1<A$, Seq<Expression>> g) {
        return Concat$.MODULE$.compose(g);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.inputTypesForMerging$lzycompute();
        }
        return this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        if (!this.bitmap$0) {
            return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute();
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public Seq<AbstractDataType> org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().isEmpty()) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        Option dataTypeMismatch = ((IterableOnceOps)this.children().zipWithIndex()).collectFirst((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Concat $outer;

            public final <A1 extends Tuple2<Expression, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int idx = A1._2$mcI$sp();
                    if (!this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes().exists((Function1 & Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$applyOrElse$1(e, x$40)))) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.$outer.ordinalNumber(idx)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.$outer.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply(this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.$outer.toSQLExpr(e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)e.dataType()))}))));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Expression, Object> x1) {
                Tuple2<Expression, Object> tuple2 = x1;
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    if (!this.$outer.org$apache$spark$sql$catalyst$expressions$Concat$$allowedTypes().exists((Function1 & Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$1.$anonfun$isDefinedAt$1(e, x$40)))) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(Expression e$1, AbstractDataType x$40) {
                return x$40.acceptsType(e$1.dataType());
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(Expression e$2, AbstractDataType x$40) {
                return x$40.acceptsType(e$2.dataType());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.types.AbstractDataType ), $anonfun$isDefinedAt$1$adapted(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.types.AbstractDataType )}, serializedLambda);
            }
        });
        Option option = dataTypeMismatch;
        if (option instanceof Some) {
            Some some = (Some)option;
            TypeCheckResult.DataTypeMismatch mismatch = (TypeCheckResult.DataTypeMismatch)some.value();
            return mismatch;
        }
        return TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)((Seq)this.children().map((Function1 & Serializable)x$41 -> x$41.dataType())), this.prettyName());
    }

    private DataType dataType$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.dataType = this.children().isEmpty() ? StringType$.MODULE$ : ComplexTypeMergingExpression.dataType$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    private String javaType() {
        return CodeGenerator$.MODULE$.javaType(this.dataType());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)x$42.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)x$43.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        return this.doConcat().apply((Object)input);
    }

    private Function1<InternalRow, Object> doConcat$lzycompute() {
        Concat concat = this;
        synchronized (concat) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Function1 & Serializable intersect;
                DataType dataType = this.dataType();
                if (BinaryType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable)input -> {
                        Seq inputs = (Seq)this.children().map((Function1 & Serializable)x$44 -> (byte[])x$44.eval((InternalRow)input));
                        return ByteArray.concat((byte[][])((byte[][])inputs.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))));
                    };
                } else if (dataType instanceof StringType) {
                    intersect = (Function1 & Serializable)input -> {
                        Seq inputs = (Seq)this.children().map((Function1 & Serializable)x$45 -> (UTF8String)x$45.eval((InternalRow)input));
                        return UTF8String.concat((UTF8String[])((UTF8String[])inputs.toArray(ClassTag$.MODULE$.apply(UTF8String.class))));
                    };
                } else if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable)input -> {
                        LazyList inputs = ((LazyList)this.children().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.LazyList()))).map((Function1 & Serializable)x$46 -> x$46.eval((InternalRow)input));
                        if (inputs.contains(null)) {
                            return null;
                        }
                        LazyList arrayData = inputs.map((Function1 & Serializable)x$47 -> (ArrayData)x$47);
                        long numberOfElements = BoxesRunTime.unboxToLong((Object)arrayData.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(sum, ad) -> BoxesRunTime.boxToLong((long)Concat.$anonfun$doConcat$8(BoxesRunTime.unboxToLong((Object)sum), ad))));
                        if (numberOfElements > 0x7FFFFFF0L) {
                            throw QueryExecutionErrors$.MODULE$.arrayFunctionWithElementsExceedLimitError(this.prettyName(), numberOfElements);
                        }
                        Object[] finalData = new Object[(int)numberOfElements];
                        IntRef position = IntRef.create((int)0);
                        arrayData.foreach((Function1 & Serializable)ad -> {
                            Concat.$anonfun$doConcat$9(elementType, finalData, position, ad);
                            return BoxedUnit.UNIT;
                        });
                        return new GenericArrayData((Object)finalData);
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doConcat = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.doConcat;
    }

    private Function1<InternalRow, Object> doConcat() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.doConcat$lzycompute();
        }
        return this.doConcat;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Tuple2 tuple2;
        Seq evals = (Seq)this.children().map((Function1 & Serializable)x$48 -> x$48.genCode(ctx));
        String args = ctx.freshName("args");
        String hasNull = ctx.freshName("hasNull");
        Seq inputs = (Seq)((IterableOps)((IterableOps)evals.zip((IterableOnce)this.children().map((Function1 & Serializable)x$49 -> BoxesRunTime.boxToBoolean((boolean)x$49.nullable())))).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    ExprCode eval = (ExprCode)tuple22._1();
                    boolean bl = tuple22._2$mcZ$sp();
                    if (bl) {
                        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + hasNull + ") {\n           |  " + eval.code() + "\n           |  if (!" + eval.isNull() + ") {\n           |    " + args + "[" + index + "] = " + eval.value() + ";\n           |  } else {\n           |    " + hasNull + " = true;\n           |  }\n           |}\n         "));
                    }
                }
            }
            if (tuple2 != null) {
                Tuple2 tuple23 = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (tuple23 != null) {
                    ExprCode eval = (ExprCode)tuple23._1();
                    boolean bl = tuple23._2$mcZ$sp();
                    if (!bl) {
                        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (!" + hasNull + ") {\n           |  " + eval.code() + "\n           |  " + args + "[" + index + "] = " + eval.value() + ";\n           |}\n         "));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple2 tuple22 = new Tuple2((Object)(this.javaType() + "[]"), (Object)args);
        Tuple2 tuple23 = new Tuple2((Object)"boolean", (Object)hasNull);
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)inputs, "valueConcat", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22), "boolean", (Function1<String, String>)(Function1 & Serializable)body -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + body + "\n           |return " + hasNull + ";\n         ")), (Function1<Seq<String>, String>)(Function1 & Serializable)x$50 -> ((IterableOnceOps)x$50.map((Function1 & Serializable)funcCall -> hasNull + " = " + funcCall + ";")).mkString("\n"));
        DataType dataType = this.dataType();
        if (BinaryType$.MODULE$.equals(dataType)) {
            tuple2 = new Tuple2((Object)(ByteArray.class.getName() + ".concat"), (Object)("byte[][] " + args + " = new byte[" + evals.length() + "][];"));
        } else if (dataType instanceof StringType) {
            tuple2 = new Tuple2((Object)"UTF8String.concat", (Object)("UTF8String[] " + args + " = new UTF8String[" + evals.length() + "];"));
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            String concat = this.genCodeForArrays(ctx, elementType, containsNull);
            tuple2 = new Tuple2((Object)concat, (Object)("ArrayData[] " + args + " = new ArrayData[" + evals.length() + "];"));
        } else {
            throw new MatchError((Object)dataType);
        }
        Tuple2 tuple24 = tuple2;
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        String concat = (String)tuple24._1();
        String initCode = (String)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)concat, (Object)initCode);
        String concat2 = (String)tuple25._1();
        String initCode2 = (String)tuple25._2();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |boolean ", " = false;\n         |", "\n         |", "\n         |", " ", " = null;\n         |if (!", ") {\n         |  ", " = ", "(", ");\n         |}\n         |boolean ", " = ", " == null;\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{hasNull, initCode2, codes, this.javaType(), ev.value(), hasNull, ev.value(), concat2, args, ev.isNull(), ev.value()})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    private Tuple2<String, String> genCodeForNumberOfElements(CodegenContext ctx) {
        String numElements = ctx.freshName("numElements");
        String z = ctx.freshName("z");
        String code = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |long " + numElements + " = 0L;\n        |for (int " + z + " = 0; " + z + " < " + this.children().length() + "; " + z + "++) {\n        |  " + numElements + " += args[" + z + "].numElements();\n        |}\n      "));
        return new Tuple2((Object)code, (Object)numElements);
    }

    private String genCodeForArrays(CodegenContext ctx, DataType elementType, boolean checkForNull) {
        String counter = ctx.freshName("counter");
        String arrayData = ctx.freshName("arrayData");
        String y = ctx.freshName("y");
        String z = ctx.freshName("z");
        Tuple2<String, String> tuple2 = this.genCodeForNumberOfElements(ctx);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String numElemCode = (String)tuple2._1();
        String numElemName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)numElemCode, (Object)numElemName);
        String numElemCode2 = (String)tuple22._1();
        String numElemName2 = (String)tuple22._2();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElemName2, " " + this.prettyName() + " failed.");
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, "args[" + y + "]", counter, z, this.resultArrayElementNullable());
        String concat = ctx.freshName("concat");
        String concatDef = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |private ArrayData " + concat + "(ArrayData[] args) {\n         |  " + numElemCode2 + "\n         |  " + initialization + "\n         |  int " + counter + " = 0;\n         |  for (int " + y + " = 0; " + y + " < " + this.children().length() + "; " + y + "++) {\n         |    for (int " + z + " = 0; " + z + " < args[" + y + "].numElements(); " + z + "++) {\n         |      " + assignment + "\n         |      " + counter + "++;\n         |    }\n         |  }\n         |  return " + arrayData + ";\n         |}\n       "));
        return ctx.addNewFunction(concat, concatDef, ctx.addNewFunction$default$3());
    }

    @Override
    public String toString() {
        return "concat(" + this.children().mkString(", ") + ")";
    }

    @Override
    public String sql() {
        return "concat(" + ((IterableOnceOps)this.children().map((Function1 & Serializable)x$53 -> x$53.sql())).mkString(", ") + ")";
    }

    @Override
    public Concat withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren);
    }

    public Concat copy(Seq<Expression> children2) {
        return new Concat(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "Concat";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Concat;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Concat)) return false;
        boolean bl = true;
        if (!bl) return false;
        Concat concat = (Concat)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = concat.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!concat.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$doConcat$8(long sum, ArrayData ad) {
        return sum + (long)ad.numElements();
    }

    public static final /* synthetic */ void $anonfun$doConcat$9(DataType elementType$2, Object[] finalData$1, IntRef position$1, ArrayData ad) {
        Object[] arr = ad.toObjectArray(elementType$2);
        Array$.MODULE$.copy((Object)arr, 0, (Object)finalData$1, position$1.elem, arr.length);
        position$1.elem += arr.length;
    }

    public Concat(Seq<Expression> children2) {
        this.children = children2;
        ComplexTypeMergingExpression.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.CONCAT(), (List)Nil$.MODULE$);
    }
}

