/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolutionValidator;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.ArraysZip;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\b\u0010\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006U\u0001!\ta\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u001d\u0002!Ia\u0014\u0005\u0006+\u0002!IA\u0016\u0005\u00069\u0002!I!\u0018\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006U\u0002!Ia\u001b\u0005\u0006c\u0002!IA\u001d\u0005\u0006q\u0002!I!\u001f\u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\tiR\t\u001f9sKN\u001c\u0018n\u001c8SKN|G.\u001e;j_:4\u0016\r\\5eCR|'O\u0003\u0002\u0011#\u0005A!/Z:pYZ,'O\u0003\u0002\u0013'\u0005A\u0011M\\1msNL7O\u0003\u0002\u0015+\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\u0017/\u0005\u00191/\u001d7\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\f1C]3t_2,H/[8o-\u0006d\u0017\u000eZ1u_J\u0004\"a\n\u0015\u000e\u0003=I!!K\b\u0003'I+7o\u001c7vi&|gNV1mS\u0012\fGo\u001c:\u0002\rqJg.\u001b;?)\taS\u0006\u0005\u0002(\u0001!)QE\u0001a\u0001M\u0005Aa/\u00197jI\u0006$X\r\u0006\u00021gA\u0011\u0001%M\u0005\u0003e\u0005\u0012A!\u00168ji\")Ag\u0001a\u0001k\u0005QQ\r\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005YJT\"A\u001c\u000b\u0005a\u001a\u0012aC3yaJ,7o]5p]NL!AO\u001c\u0003\u0015\u0015C\bO]3tg&|g.A\nwC2LG-\u0019;f!J|'.Z2u\u0019&\u001cH\u000f\u0006\u00021{!)a\b\u0002a\u0001\u007f\u0005Y\u0001O]8kK\u000e$H*[:u!\r\u0001\u0005j\u0013\b\u0003\u0003\u001as!AQ#\u000e\u0003\rS!\u0001R\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013BA$\"\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u0007M+\u0017O\u0003\u0002HCA\u0011a\u0007T\u0005\u0003\u001b^\u0012qBT1nK\u0012,\u0005\u0010\u001d:fgNLwN\\\u0001\u0012m\u0006d\u0017\u000eZ1uKB\u0013X\rZ5dCR,GC\u0001\u0019Q\u0011\u0015\tV\u00011\u0001S\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u00027'&\u0011Ak\u000e\u0002\n!J,G-[2bi\u0016\f!D^1mS\u0012\fG/Z!uiJL'-\u001e;f%\u00164WM]3oG\u0016$\"\u0001M,\t\u000ba3\u0001\u0019A-\u0002%\u0005$HO]5ckR,'+\u001a4fe\u0016t7-\u001a\t\u0003miK!aW\u001c\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-Z\u0001\u000em\u0006d\u0017\u000eZ1uK\u0006c\u0017.Y:\u0015\u0005Ar\u0006\"B0\b\u0001\u0004\u0001\u0017!B1mS\u0006\u001c\bC\u0001\u001cb\u0013\t\u0011wGA\u0003BY&\f7/\u0001\rwC2LG-\u0019;f\u0005&t\u0017M]=FqB\u0014Xm]:j_:$\"\u0001M3\t\u000b\u0019D\u0001\u0019A4\u0002!\tLg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001ci\u0013\tIwG\u0001\tCS:\f'/_#yaJ,7o]5p]\u0006ya/\u00197jI\u0006$X\rT5uKJ\fG\u000e\u0006\u00021Y\")Q.\u0003a\u0001]\u00069A.\u001b;fe\u0006d\u0007C\u0001\u001cp\u0013\t\u0001xGA\u0004MSR,'/\u00197\u0002#Y\fG.\u001b3bi\u0016\f%O]1zgjK\u0007\u000f\u0006\u00021g\")AO\u0003a\u0001k\u0006I\u0011M\u001d:bsNT\u0016\u000e\u001d\t\u0003mYL!a^\u001c\u0003\u0013\u0005\u0013(/Y=t5&\u0004\u0018A\u0007<bY&$\u0017\r^3US6,'p\u001c8f\u000bb\u0004(/Z:tS>tGC\u0001\u0019{\u0011\u0015Y8\u00021\u0001}\u0003I!\u0018.\\3{_:,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005Yj\u0018B\u0001@8\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g.\u0001\nwC2LG-\u0019;f\u000bb\u0004(/Z:tS>tGc\u0001\u0019\u0002\u0004!)A\u0007\u0004a\u0001k\u00051b/\u00197jI\u0006$X-\u00138qkR$\u0015\r^1UsB,7\u000fF\u00021\u0003\u0013AQ\u0001N\u0007A\u0002U\u0002")
public class ExpressionResolutionValidator {
    private final ResolutionValidator resolutionValidator;

    public void validate(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression2;
            this.validateAttributeReference(attributeReference);
            return;
        }
        if (expression2 instanceof Alias) {
            Alias alias = (Alias)expression2;
            this.validateAlias(alias);
            return;
        }
        if (expression2 instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression2;
            this.validateBinaryExpression(binaryExpression);
            return;
        }
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            this.validateLiteral(literal);
            return;
        }
        if (expression2 instanceof Predicate) {
            Predicate predicate = (Predicate)((Object)expression2);
            this.validatePredicate(predicate);
            return;
        }
        if (expression2 instanceof ArraysZip) {
            ArraysZip arraysZip = (ArraysZip)expression2;
            this.validateArraysZip(arraysZip);
            return;
        }
        if (expression2 instanceof TimeZoneAwareExpression) {
            TimeZoneAwareExpression timeZoneAwareExpression = (TimeZoneAwareExpression)((Object)expression2);
            this.validateTimezoneExpression(timeZoneAwareExpression);
            return;
        }
        if (expression2 != null) {
            Expression expression3 = expression2;
            this.validateExpression(expression3);
            return;
        }
        throw new MatchError((Object)expression2);
    }

    public void validateProjectList(Seq<NamedExpression> projectList) {
        projectList.foreach((Function1 & Serializable)x0$1 -> {
            ExpressionResolutionValidator.$anonfun$validateProjectList$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void validatePredicate(Predicate predicate) {
        ((TreeNode)((Object)predicate)).children().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        DataType dataType = predicate.dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null), (Function0 & Serializable)() -> "Output type of a predicate must be a boolean, but got: " + predicate.dataType().typeName());
        this.validateInputDataTypes((Expression)((Object)predicate));
    }

    private void validateAttributeReference(AttributeReference attributeReference) {
        Predef$.MODULE$.assert(this.resolutionValidator.attributeScopeStack().top().contains(attributeReference), (Function0 & Serializable)() -> "Attribute " + attributeReference + " is missing from attribute scope: " + $this.resolutionValidator.attributeScopeStack().top());
    }

    private void validateAlias(Alias alias) {
        this.validate(alias.child());
    }

    private void validateBinaryExpression(BinaryExpression binaryExpression) {
        this.validate((Expression)binaryExpression.left());
        this.validate((Expression)binaryExpression.right());
        this.validateInputDataTypes(binaryExpression);
        BinaryExpression binaryExpression2 = binaryExpression;
        if (binaryExpression2 instanceof TimeZoneAwareExpression) {
            BinaryExpression binaryExpression3 = binaryExpression2;
            Predef$.MODULE$.assert(((TimeZoneAwareExpression)((Object)binaryExpression3)).timeZoneId().nonEmpty(), (Function0 & Serializable)() -> "Timezone expression must have a timezone");
            return;
        }
    }

    private void validateLiteral(Literal literal) {
    }

    private void validateArraysZip(ArraysZip arraysZip) {
        arraysZip.children().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        arraysZip.names().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        this.validateInputDataTypes(arraysZip);
    }

    private void validateTimezoneExpression(TimeZoneAwareExpression timezoneExpression) {
        ((TreeNode)((Object)timezoneExpression)).children().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(timezoneExpression.timeZoneId().nonEmpty(), (Function0 & Serializable)() -> "Timezone expression must have a timezone");
    }

    private void validateExpression(Expression expression2) {
        expression2.children().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        this.validateInputDataTypes(expression2);
    }

    private void validateInputDataTypes(Expression expression) {
        Predef$.MODULE$.assert(expression.checkInputDataTypes().isSuccess(), (Function0 & Serializable)() -> "Input types of " + expression.getClass().getName() + " must be valid, but got: " + ((IterableOnceOps)expression.children().map((Function1 & Serializable)x$1 -> x$1.dataType().typeName())).mkString(", "));
    }

    public static final /* synthetic */ void $anonfun$validateProjectList$1(ExpressionResolutionValidator $this, NamedExpression x0$1) {
        NamedExpression namedExpression = x0$1;
        if (namedExpression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)namedExpression;
            $this.validateAttributeReference(attributeReference);
            return;
        }
        if (namedExpression instanceof Alias) {
            Alias alias = (Alias)namedExpression;
            $this.validateAlias(alias);
            return;
        }
        throw new MatchError((Object)namedExpression);
    }

    public ExpressionResolutionValidator(ResolutionValidator resolutionValidator) {
        this.resolutionValidator = resolutionValidator;
    }
}

