/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi;

public interface Logger {
    public static final EventType SECURITY_SUCCESS = new EventType("SECURITY SUCCESS", true);
    public static final EventType SECURITY_FAILURE = new EventType("SECURITY FAILURE", false);
    public static final EventType SECURITY_AUDIT = new EventType("SECURITY AUDIT", null);
    public static final EventType EVENT_SUCCESS = new EventType("EVENT SUCCESS", true);
    public static final EventType EVENT_FAILURE = new EventType("EVENT FAILURE", false);
    public static final EventType EVENT_UNSPECIFIED = new EventType("EVENT UNSPECIFIED", null);
    public static final int OFF = Integer.MAX_VALUE;
    public static final int FATAL = 1000;
    public static final int ERROR = 800;
    public static final int WARNING = 600;
    public static final int INFO = 400;
    public static final int DEBUG = 200;
    public static final int TRACE = 100;
    public static final int ALL = Integer.MIN_VALUE;

    public void setLevel(int var1);

    public int getESAPILevel();

    public void fatal(EventType var1, String var2);

    public void fatal(EventType var1, String var2, Throwable var3);

    public boolean isFatalEnabled();

    public void error(EventType var1, String var2);

    public void error(EventType var1, String var2, Throwable var3);

    public boolean isErrorEnabled();

    public void warning(EventType var1, String var2);

    public void warning(EventType var1, String var2, Throwable var3);

    public boolean isWarningEnabled();

    public void info(EventType var1, String var2);

    public void info(EventType var1, String var2, Throwable var3);

    public boolean isInfoEnabled();

    public void debug(EventType var1, String var2);

    public void debug(EventType var1, String var2, Throwable var3);

    public boolean isDebugEnabled();

    public void trace(EventType var1, String var2);

    public void trace(EventType var1, String var2, Throwable var3);

    public boolean isTraceEnabled();

    public void always(EventType var1, String var2);

    public void always(EventType var1, String var2, Throwable var3);

    public static class EventType {
        private String type;
        private Boolean success = null;

        public EventType(String name, Boolean newSuccess) {
            this.type = name;
            this.success = newSuccess;
        }

        public Boolean isSuccess() {
            return this.success;
        }

        public String toString() {
            return this.type;
        }
    }
}

