/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.commons.jdkcompat.Java23Subject;
import org.apache.jackrabbit.oak.security.authentication.CallbackHandlerImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.ConfigurationUtil;
import org.apache.jackrabbit.oak.spi.security.authentication.JaasLoginContext;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContext;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginContextProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMonitor;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthContext;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoginContextProviderImpl
implements LoginContextProvider {
    private static final Logger log = LoggerFactory.getLogger(LoginContextProviderImpl.class);
    private final String appName;
    private final ConfigurationParameters params;
    private final ContentRepository contentRepository;
    private final SecurityProvider securityProvider;
    private final Whiteboard whiteboard;
    private final LoginModuleMonitor loginModuleMonitor;
    private Configuration configuration;

    LoginContextProviderImpl(String appName, ConfigurationParameters params, ContentRepository contentRepository, SecurityProvider securityProvider, Whiteboard whiteboard, LoginModuleMonitor loginModuleMonitor) {
        this.appName = appName;
        this.params = params;
        this.contentRepository = contentRepository;
        this.securityProvider = securityProvider;
        this.whiteboard = whiteboard;
        this.loginModuleMonitor = loginModuleMonitor;
    }

    @Override
    @NotNull
    public LoginContext getLoginContext(Credentials credentials, String workspaceName) throws LoginException {
        Subject subject = LoginContextProviderImpl.getSubject();
        if (subject != null && credentials == null) {
            log.debug("Found pre-authenticated subject: No further login actions required.");
            return new PreAuthContext(subject);
        }
        if (subject == null) {
            subject = new Subject();
        }
        CallbackHandler handler = this.getCallbackHandler(credentials, workspaceName);
        return new JaasLoginContext(this.appName, subject, handler, this.getConfiguration());
    }

    @Nullable
    private static Subject getSubject() {
        Subject subject = null;
        try {
            subject = Java23Subject.getSubject();
        }
        catch (SecurityException e) {
            log.debug("Can't check for pre-authenticated subject. Reason: {}", (Object)e.getMessage());
        }
        return subject;
    }

    @NotNull
    private CallbackHandler getCallbackHandler(Credentials credentials, String workspaceName) {
        return new CallbackHandlerImpl(credentials, workspaceName, this.contentRepository, this.securityProvider, this.whiteboard, this.loginModuleMonitor);
    }

    @NotNull
    private Configuration getConfiguration() {
        if (this.configuration == null) {
            Configuration loginConfig = null;
            String configSpiName = this.params.getConfigValue("org.apache.jackrabbit.oak.authentication.configSpiName", null, String.class);
            if (configSpiName != null) {
                try {
                    loginConfig = Configuration.getInstance("JavaLoginConfig", null, configSpiName);
                    if (loginConfig.getAppConfigurationEntry(this.appName) == null) {
                        log.warn("No configuration found for application {} though fetching JAAS configuration from SPI {} is enabled.", (Object)this.appName, (Object)configSpiName);
                    }
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    log.warn("Error fetching JAAS config from SPI {}", (Object)configSpiName, (Object)e);
                }
            }
            if (loginConfig == null) {
                try {
                    loginConfig = Configuration.getConfiguration();
                    if (loginConfig.getAppConfigurationEntry(this.appName) == null) {
                        loginConfig = null;
                    }
                }
                catch (SecurityException e) {
                    log.info("Failed to retrieve login configuration: using default. {}", (Throwable)e);
                }
            }
            if (loginConfig == null) {
                log.debug("No login configuration available for {}; using default", (Object)this.appName);
                loginConfig = ConfigurationUtil.getDefaultConfiguration(this.params);
            }
            this.configuration = loginConfig;
        }
        return this.configuration;
    }
}

