/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.netty;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.RpcConstants;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.AbstractChannel;
import com.alipay.sofa.rpc.transport.ServerTransportConfig;
import com.alipay.sofa.rpc.transport.netty.NettyChannel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NettyHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHelper.class);
    private static ConcurrentMap<String, EventLoopGroup> serverBossGroups = new ConcurrentHashMap<String, EventLoopGroup>();
    private static ConcurrentMap<String, EventLoopGroup> serverIoGroups = new ConcurrentHashMap<String, EventLoopGroup>();
    private static ConcurrentMap<EventLoopGroup, AtomicInteger> refCounter = new ConcurrentHashMap<EventLoopGroup, AtomicInteger>();
    private static volatile EventLoopGroup clientIOEventLoopGroup;
    private static AdaptiveRecvByteBufAllocator recvByteBufAllocator;
    private static ByteBufAllocator byteBufAllocator;
    private static final AttributeKey<AbstractChannel> CHANNEL_KEY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static EventLoopGroup getServerBossEventLoopGroup(ServerTransportConfig config) {
        String type = config.getProtocolType();
        EventLoopGroup bossGroup = (EventLoopGroup)serverBossGroups.get(type);
        if (bossGroup == null) {
            Class<NettyHelper> clazz = NettyHelper.class;
            // MONITORENTER : com.alipay.sofa.rpc.transport.netty.NettyHelper.class
            bossGroup = (EventLoopGroup)serverBossGroups.get(config.getProtocolType());
            if (bossGroup == null) {
                int bossThreads = config.getBossThreads();
                bossThreads = bossThreads <= 0 ? Math.max(4, SystemInfo.getCpuCores() / 2) : bossThreads;
                NamedThreadFactory threadName = new NamedThreadFactory("SEV-BOSS-" + config.getPort(), config.isDaemon());
                bossGroup = config.isUseEpoll() ? new EpollEventLoopGroup(bossThreads, (ThreadFactory)threadName) : new NioEventLoopGroup(bossThreads, (ThreadFactory)threadName);
                serverBossGroups.put(type, bossGroup);
                refCounter.putIfAbsent(bossGroup, new AtomicInteger(0));
            }
            // MONITOREXIT : clazz
        }
        ((AtomicInteger)refCounter.get(bossGroup)).incrementAndGet();
        return bossGroup;
    }

    public static void closeServerBossEventLoopGroup(ServerTransportConfig config) {
        EventLoopGroup bossGroup = (EventLoopGroup)serverBossGroups.get(config.getProtocolType());
        if (NettyHelper.closeEventLoopGroupIfNoRef(bossGroup)) {
            serverBossGroups.remove(config.getProtocolType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static EventLoopGroup getServerIoEventLoopGroup(ServerTransportConfig config) {
        String type = config.getProtocolType();
        EventLoopGroup ioGroup = (EventLoopGroup)serverIoGroups.get(type);
        if (ioGroup == null) {
            Class<NettyHelper> clazz = NettyHelper.class;
            // MONITORENTER : com.alipay.sofa.rpc.transport.netty.NettyHelper.class
            ioGroup = (EventLoopGroup)serverIoGroups.get(config.getProtocolType());
            if (ioGroup == null) {
                int ioThreads = config.getIoThreads();
                ioThreads = ioThreads <= 0 ? Math.max(8, SystemInfo.getCpuCores() + 1) : ioThreads;
                NamedThreadFactory threadName = new NamedThreadFactory("SEV-IO-" + config.getPort(), config.isDaemon());
                ioGroup = config.isUseEpoll() ? new EpollEventLoopGroup(ioThreads, (ThreadFactory)threadName) : new NioEventLoopGroup(ioThreads, (ThreadFactory)threadName);
                serverIoGroups.put(type, ioGroup);
                refCounter.putIfAbsent(ioGroup, new AtomicInteger(0));
            }
            // MONITOREXIT : clazz
        }
        ((AtomicInteger)refCounter.get(ioGroup)).incrementAndGet();
        return ioGroup;
    }

    public static void closeServerIoEventLoopGroup(ServerTransportConfig config) {
        EventLoopGroup ioGroup = (EventLoopGroup)serverIoGroups.get(config.getProtocolType());
        if (NettyHelper.closeEventLoopGroupIfNoRef(ioGroup)) {
            serverIoGroups.remove(config.getProtocolType());
        }
    }

    private static boolean closeEventLoopGroupIfNoRef(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup != null && ((AtomicInteger)refCounter.get(eventLoopGroup)).decrementAndGet() <= 0) {
            if (!eventLoopGroup.isShuttingDown() && !eventLoopGroup.isShutdown()) {
                eventLoopGroup.shutdownGracefully();
            }
            refCounter.remove(eventLoopGroup);
            return true;
        }
        return false;
    }

    public static synchronized EventLoopGroup getClientIOEventLoopGroup() {
        if (clientIOEventLoopGroup != null && clientIOEventLoopGroup.isShutdown()) {
            clientIOEventLoopGroup = null;
        }
        if (clientIOEventLoopGroup == null) {
            int clientIoThreads = RpcConfigs.getIntValue("transport.client.io.threads");
            int threads = clientIoThreads > 0 ? clientIoThreads : Math.max(4, SystemInfo.getCpuCores() + 1);
            NamedThreadFactory threadName = new NamedThreadFactory("CLI-IO", true);
            boolean useEpoll = RpcConfigs.getBooleanValue("transport.use.epoll");
            clientIOEventLoopGroup = useEpoll ? new EpollEventLoopGroup(threads, (ThreadFactory)threadName) : new NioEventLoopGroup(threads, (ThreadFactory)threadName);
            refCounter.putIfAbsent(clientIOEventLoopGroup, new AtomicInteger(0));
        }
        ((AtomicInteger)refCounter.get(clientIOEventLoopGroup)).incrementAndGet();
        return clientIOEventLoopGroup;
    }

    public static synchronized void closeClientIOEventGroup() {
        if (clientIOEventLoopGroup != null) {
            AtomicInteger ref = (AtomicInteger)refCounter.get(clientIOEventLoopGroup);
            if (ref.decrementAndGet() <= 0) {
                if (!clientIOEventLoopGroup.isShutdown() && !clientIOEventLoopGroup.isShuttingDown()) {
                    clientIOEventLoopGroup.shutdownGracefully();
                }
                refCounter.remove(clientIOEventLoopGroup);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing Client EventLoopGroup, ref : 0");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Client EventLoopGroup still has ref : {}", ref.get());
            }
        }
        clientIOEventLoopGroup = null;
    }

    public static EventLoopGroup getServerBizEventLoopGroup(ServerTransportConfig config, Executor executor) {
        int bizThreads = config.getBizMaxThreads();
        return config.isUseEpoll() ? new EpollEventLoopGroup(config.getBizMaxThreads(), executor) : new NioEventLoopGroup(bizThreads, executor);
    }

    public static ByteBufAllocator getByteBufAllocator() {
        return byteBufAllocator;
    }

    public static ByteBuf getBuffer() {
        return byteBufAllocator.buffer();
    }

    public static ByteBuf getBuffer(int size) {
        return byteBufAllocator.buffer(size);
    }

    public static AdaptiveRecvByteBufAllocator getRecvByteBufAllocator() {
        return recvByteBufAllocator;
    }

    public static AbstractChannel getChannel(ChannelHandlerContext ctx) {
        AbstractChannel old;
        Attribute attr = ctx.channel().attr(CHANNEL_KEY);
        AbstractChannel sofaChannel = (AbstractChannel)attr.get();
        if (sofaChannel == null && (old = (AbstractChannel)attr.setIfAbsent((Object)(sofaChannel = new NettyChannel(ctx)))) != null) {
            sofaChannel = old;
        }
        return sofaChannel;
    }

    public static String toString(ByteBuf byteBuf) {
        byte[] bs;
        if (byteBuf == null) {
            return null;
        }
        int readIndex = byteBuf.readerIndex();
        if (byteBuf.hasArray()) {
            bs = byteBuf.array();
        } else {
            bs = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(bs);
        }
        byteBuf.readerIndex(readIndex);
        return new String(bs, RpcConstants.DEFAULT_CHARSET);
    }

    static {
        recvByteBufAllocator = AdaptiveRecvByteBufAllocator.DEFAULT;
        byteBufAllocator = ByteBufAllocator.DEFAULT;
        CHANNEL_KEY = AttributeKey.newInstance((String)"sofa-channel");
    }
}

