/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.alipay.hessian.ClassNameResolver;
import com.alipay.hessian.ClassNameResolverBuilder;
import com.caucho.burlap.io.BurlapRemoteObject;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.AbstractStringBuilderDeserializer;
import com.caucho.hessian.io.AbstractStringBuilderSerializer;
import com.caucho.hessian.io.ArrayDeserializer;
import com.caucho.hessian.io.ArraySerializer;
import com.caucho.hessian.io.BasicDeserializer;
import com.caucho.hessian.io.BasicSerializer;
import com.caucho.hessian.io.CalendarSerializer;
import com.caucho.hessian.io.ClassDeserializer;
import com.caucho.hessian.io.ClassSerializer;
import com.caucho.hessian.io.CollectionDeserializer;
import com.caucho.hessian.io.CollectionSerializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.EnumDeserializer;
import com.caucho.hessian.io.EnumSerializer;
import com.caucho.hessian.io.EnumerationDeserializer;
import com.caucho.hessian.io.EnumerationSerializer;
import com.caucho.hessian.io.HessianHandle;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.InputStreamDeserializer;
import com.caucho.hessian.io.InputStreamSerializer;
import com.caucho.hessian.io.IteratorSerializer;
import com.caucho.hessian.io.JavaDeserializer;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.LocaleSerializer;
import com.caucho.hessian.io.MapDeserializer;
import com.caucho.hessian.io.MapSerializer;
import com.caucho.hessian.io.RemoteSerializer;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SqlDateDeserializer;
import com.caucho.hessian.io.SqlDateSerializer;
import com.caucho.hessian.io.StringValueDeserializer;
import com.caucho.hessian.io.StringValueSerializer;
import com.caucho.hessian.io.atomic.AtomicDeserializer;
import com.caucho.hessian.io.atomic.AtomicSerializer;
import com.caucho.hessian.io.java17.base.JavaCurrencyDeserializer;
import com.caucho.hessian.io.java17.base.JavaCurrencySerializer;
import com.caucho.hessian.io.java8.DurationHandle;
import com.caucho.hessian.io.java8.InstantHandle;
import com.caucho.hessian.io.java8.Java8TimeSerializer;
import com.caucho.hessian.io.java8.LocalDateHandle;
import com.caucho.hessian.io.java8.LocalDateTimeHandle;
import com.caucho.hessian.io.java8.LocalTimeHandle;
import com.caucho.hessian.io.java8.MonthDayHandle;
import com.caucho.hessian.io.java8.OffsetDateTimeHandle;
import com.caucho.hessian.io.java8.OffsetTimeHandle;
import com.caucho.hessian.io.java8.PeriodHandle;
import com.caucho.hessian.io.java8.YearHandle;
import com.caucho.hessian.io.java8.YearMonthHandle;
import com.caucho.hessian.io.java8.ZoneIdSerializer;
import com.caucho.hessian.io.java8.ZoneOffsetHandle;
import com.caucho.hessian.io.java8.ZonedDateTimeHandle;
import com.caucho.hessian.io.throwable.StackTraceElementDeserializer;
import com.caucho.hessian.io.throwable.StackTraceElementSerializer;
import com.caucho.hessian.io.throwable.ThrowableHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerializerFactory
extends AbstractSerializerFactory {
    private static final Logger log = Logger.getLogger(SerializerFactory.class.getName());
    protected static Deserializer OBJECT_DESERIALIZER = new BasicDeserializer(13);
    protected static ConcurrentMap _staticSerializerMap;
    protected static ConcurrentMap _staticDeserializerMap;
    protected static ConcurrentMap _staticTypeMap;
    protected Serializer _defaultSerializer;
    protected ArrayList _factories = new ArrayList();
    protected CollectionSerializer _collectionSerializer;
    protected Deserializer _hashMapDeserializer;
    protected ConcurrentMap _cachedSerializerMap = new ConcurrentHashMap();
    protected ConcurrentMap _cachedDeserializerMap = new ConcurrentHashMap();
    protected ConcurrentMap _cachedTypeDeserializerMap = new ConcurrentHashMap();
    protected boolean _isAllowNonSerializable;
    protected ClassNameResolver classNameResolver = ClassNameResolverBuilder.buildDefault();
    protected static final boolean isHigherThanJdk8;
    protected static final boolean isHigherThanJdk17;
    private Map<ClassLoader, Map<String, Object>> _typeNotFoundMap = new ConcurrentHashMap<ClassLoader, Map<String, Object>>(8);
    private static final Object NOT_FOUND;
    public static final String DYNAMIC_LOAD_ENABLE_KEY = "sofa.serialize.dynamic.load.enable";
    private boolean dynamicLoadEnable = Boolean.parseBoolean(System.getProperty("sofa.serialize.dynamic.load.enable", Boolean.FALSE.toString()));

    public void setSendCollectionType(boolean isSendType) {
        if (this._collectionSerializer == null) {
            this._collectionSerializer = new CollectionSerializer();
        }
        this._collectionSerializer.setSendJavaType(isSendType);
    }

    public void addFactory(AbstractSerializerFactory factory) {
        this._factories.add(factory);
    }

    public void setAllowNonSerializable(boolean allow) {
        this._isAllowNonSerializable = allow;
    }

    public boolean isAllowNonSerializable() {
        return this._isAllowNonSerializable;
    }

    public ClassNameResolver getClassNameResolver() {
        return this.classNameResolver;
    }

    public void setClassNameResolver(ClassNameResolver classNameResolver) {
        this.classNameResolver = classNameResolver;
    }

    @Override
    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        Serializer serializer = (Serializer)_staticSerializerMap.get(cl);
        if (serializer != null) {
            return serializer;
        }
        if (SerializerFactory.isZoneId(cl)) {
            serializer = ZoneIdSerializer.getInstance();
            return serializer;
        }
        serializer = (Serializer)this._cachedSerializerMap.get(cl);
        if (serializer != null) {
            return serializer;
        }
        if (this.classNameResolver != null) {
            try {
                this.classNameResolver.resolve(cl.getName());
            }
            catch (Exception e) {
                throw new HessianProtocolException(e);
            }
        }
        for (int i = 0; serializer == null && this._factories != null && i < this._factories.size(); ++i) {
            AbstractSerializerFactory factory = (AbstractSerializerFactory)this._factories.get(i);
            serializer = factory.getSerializer(cl);
        }
        if (serializer == null) {
            if (HessianRemoteObject.class.isAssignableFrom(cl)) {
                serializer = new RemoteSerializer();
            } else if (BurlapRemoteObject.class.isAssignableFrom(cl)) {
                serializer = new RemoteSerializer();
            } else if (Map.class.isAssignableFrom(cl)) {
                serializer = new MapSerializer();
            } else if (Collection.class.isAssignableFrom(cl)) {
                if (this._collectionSerializer == null) {
                    this._collectionSerializer = new CollectionSerializer();
                }
                serializer = this._collectionSerializer;
            } else if (cl.isArray()) {
                serializer = new ArraySerializer();
            } else if (Throwable.class.isAssignableFrom(cl)) {
                serializer = ThrowableHelper.getSerializer(cl);
            } else if (InputStream.class.isAssignableFrom(cl)) {
                serializer = new InputStreamSerializer();
            } else if (Iterator.class.isAssignableFrom(cl)) {
                serializer = IteratorSerializer.create();
            } else if (Enumeration.class.isAssignableFrom(cl)) {
                serializer = EnumerationSerializer.create();
            } else if (Calendar.class.isAssignableFrom(cl)) {
                serializer = CalendarSerializer.create();
            } else if (Locale.class.isAssignableFrom(cl)) {
                serializer = LocaleSerializer.create();
            } else if (Enum.class.isAssignableFrom(cl)) {
                serializer = new EnumSerializer(cl);
            }
        }
        if (serializer == null) {
            serializer = this.getDefaultSerializer(cl);
        }
        this._cachedSerializerMap.put(cl, serializer);
        return serializer;
    }

    protected Serializer getDefaultSerializer(Class cl) {
        if (this._defaultSerializer != null) {
            return this._defaultSerializer;
        }
        if (!Serializable.class.isAssignableFrom(cl) && !this._isAllowNonSerializable) {
            throw new IllegalStateException("Serialized class " + cl.getName() + " must implement java.io.Serializable");
        }
        return new JavaSerializer(cl);
    }

    @Override
    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        Deserializer deserializer = (Deserializer)_staticDeserializerMap.get(cl);
        if (deserializer != null) {
            return deserializer;
        }
        deserializer = (Deserializer)this._cachedDeserializerMap.get(cl);
        if (deserializer != null) {
            return deserializer;
        }
        if (this.classNameResolver != null) {
            try {
                this.classNameResolver.resolve(cl.getName());
            }
            catch (Exception e) {
                throw new HessianProtocolException(e);
            }
        }
        for (int i = 0; deserializer == null && this._factories != null && i < this._factories.size(); ++i) {
            AbstractSerializerFactory factory = (AbstractSerializerFactory)this._factories.get(i);
            deserializer = factory.getDeserializer(cl);
        }
        if (deserializer == null) {
            deserializer = Collection.class.isAssignableFrom(cl) ? new CollectionDeserializer(cl) : (Map.class.isAssignableFrom(cl) ? new MapDeserializer(cl) : (cl.isInterface() ? OBJECT_DESERIALIZER : (cl.isArray() ? new ArrayDeserializer(this.getDeserializer(cl.getComponentType())) : (Enumeration.class.isAssignableFrom(cl) ? EnumerationDeserializer.create() : (Enum.class.isAssignableFrom(cl) ? new EnumDeserializer(cl) : (Throwable.class.isAssignableFrom(cl) ? ThrowableHelper.getDeserializer(cl) : this.getDefaultDeserializer(cl)))))));
        }
        this._cachedDeserializerMap.put(cl, deserializer);
        return deserializer;
    }

    protected Deserializer getDefaultDeserializer(Class cl) {
        return new JavaDeserializer(cl);
    }

    public Object readList(AbstractHessianInput in, int length, String type) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readList(in, length);
        }
        return new CollectionDeserializer(ArrayList.class).readList(in, length);
    }

    public Object readMap(AbstractHessianInput in, String type) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readMap(in);
        }
        if (this._hashMapDeserializer != null) {
            return this._hashMapDeserializer.readMap(in);
        }
        this._hashMapDeserializer = new MapDeserializer(HashMap.class);
        return this._hashMapDeserializer.readMap(in);
    }

    public Object readObject(AbstractHessianInput in, String type, String[] fieldNames) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readObject(in, fieldNames);
        }
        if (this._hashMapDeserializer != null) {
            return this._hashMapDeserializer.readObject(in, fieldNames);
        }
        this._hashMapDeserializer = new MapDeserializer(HashMap.class);
        return this._hashMapDeserializer.readObject(in, fieldNames);
    }

    public Deserializer getObjectDeserializer(String type, Class cl) throws HessianProtocolException {
        Deserializer reader = this.getObjectDeserializer(type);
        if (cl == null || cl == reader.getType() || HessianHandle.class.isAssignableFrom(reader.getType()) || cl.isAssignableFrom(reader.getType())) {
            return reader;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("hessian: expected '" + cl.getName() + "' at '" + type + "'");
        }
        return this.getDeserializer(cl);
    }

    public Deserializer getObjectDeserializer(String type) throws HessianProtocolException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (this._hashMapDeserializer != null) {
            return this._hashMapDeserializer;
        }
        this._hashMapDeserializer = new MapDeserializer(HashMap.class);
        return this._hashMapDeserializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deserializer getDeserializer(String type) throws HessianProtocolException {
        Deserializer deserializer;
        if (type == null || type.equals("")) {
            return null;
        }
        if (this.classNameResolver != null) {
            try {
                type = this.classNameResolver.resolve(type);
            }
            catch (Exception e) {
                throw new HessianProtocolException(e);
            }
        }
        if ((deserializer = (Deserializer)this._cachedTypeDeserializerMap.get(type)) != null) {
            return deserializer;
        }
        deserializer = (Deserializer)_staticTypeMap.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type.startsWith("[")) {
            Deserializer subDeserializer = this.getDeserializer(type.substring(1));
            deserializer = new ArrayDeserializer(subDeserializer);
        } else {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Map<String, Object> typeMap;
                if (!this.dynamicLoadEnable && (typeMap = this._typeNotFoundMap.get(loader)) != null && typeMap.containsKey(type)) {
                    return null;
                }
                Class<?> cl = Class.forName(type, false, loader);
                deserializer = this.getDeserializer(cl);
            }
            catch (Exception e) {
                if (!this.dynamicLoadEnable) {
                    Map<String, Object> typeMap = this._typeNotFoundMap.get(loader);
                    if (typeMap == null) {
                        SerializerFactory serializerFactory = this;
                        synchronized (serializerFactory) {
                            typeMap = this._typeNotFoundMap.get(loader);
                            if (typeMap == null) {
                                this._typeNotFoundMap.put(loader, new ConcurrentHashMap(8));
                                typeMap = this._typeNotFoundMap.get(loader);
                            }
                        }
                    }
                    typeMap.put(type, NOT_FOUND);
                }
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (deserializer != null) {
            this._cachedTypeDeserializerMap.put(type, deserializer);
        }
        return deserializer;
    }

    protected static void addBasic(Class cl, String typeName, int type) {
        _staticSerializerMap.put(cl, new BasicSerializer(type));
        BasicDeserializer deserializer = new BasicDeserializer(type);
        _staticDeserializerMap.put(cl, deserializer);
        _staticTypeMap.put(typeName, deserializer);
    }

    private static boolean isJava8() {
        String javaVersion = System.getProperty("java.specification.version");
        return Double.valueOf(javaVersion) >= 1.8;
    }

    private static boolean isJava17() {
        String javaVersion = System.getProperty("java.specification.version");
        return Double.valueOf(javaVersion) >= 17.0;
    }

    protected static void addCurrencySupport() {
        try {
            JavaCurrencySerializer currencySerializer = new JavaCurrencySerializer(Currency.class);
            JavaCurrencyDeserializer currencyDeserializer = new JavaCurrencyDeserializer();
            _staticSerializerMap.put(Currency.class, currencySerializer);
            _staticDeserializerMap.put(Currency.class, currencyDeserializer);
        }
        catch (Throwable t) {
            log.warning(String.valueOf(t.getCause()));
        }
    }

    protected static void addAbstractStringBuilderSupport() {
        try {
            if (AbstractStringBuilderSerializer.isEnable()) {
                _staticSerializerMap.put(StringBuilder.class, new AbstractStringBuilderSerializer((Class)StringBuilder.class));
                _staticSerializerMap.put(StringBuffer.class, new AbstractStringBuilderSerializer((Class)StringBuffer.class));
            }
            if (AbstractStringBuilderDeserializer.isEnable()) {
                _staticDeserializerMap.put(StringBuilder.class, new AbstractStringBuilderDeserializer(StringBuilder.class));
                _staticDeserializerMap.put(StringBuffer.class, new AbstractStringBuilderDeserializer(StringBuffer.class));
            }
        }
        catch (Throwable t) {
            log.info(String.valueOf(t.getCause()));
        }
    }

    private static boolean isZoneId(Class cl) {
        try {
            return isHigherThanJdk8 && Class.forName("java.time.ZoneId").isAssignableFrom(cl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    static {
        isHigherThanJdk8 = SerializerFactory.isJava8();
        isHigherThanJdk17 = SerializerFactory.isJava17();
        NOT_FOUND = new Object();
        _staticSerializerMap = new ConcurrentHashMap();
        _staticDeserializerMap = new ConcurrentHashMap();
        _staticTypeMap = new ConcurrentHashMap();
        SerializerFactory.addBasic(Void.TYPE, "void", 0);
        SerializerFactory.addBasic(Boolean.class, "boolean", 1);
        SerializerFactory.addBasic(Byte.class, "byte", 2);
        SerializerFactory.addBasic(Short.class, "short", 3);
        SerializerFactory.addBasic(Integer.class, "int", 4);
        SerializerFactory.addBasic(Long.class, "long", 5);
        SerializerFactory.addBasic(Float.class, "float", 6);
        SerializerFactory.addBasic(Double.class, "double", 7);
        SerializerFactory.addBasic(Character.class, "char", 9);
        SerializerFactory.addBasic(String.class, "string", 10);
        SerializerFactory.addBasic(Object.class, "object", 13);
        SerializerFactory.addBasic(Date.class, "date", 11);
        SerializerFactory.addBasic(Boolean.TYPE, "boolean", 1);
        SerializerFactory.addBasic(Byte.TYPE, "byte", 2);
        SerializerFactory.addBasic(Short.TYPE, "short", 3);
        SerializerFactory.addBasic(Integer.TYPE, "int", 4);
        SerializerFactory.addBasic(Long.TYPE, "long", 5);
        SerializerFactory.addBasic(Float.TYPE, "float", 6);
        SerializerFactory.addBasic(Double.TYPE, "double", 7);
        SerializerFactory.addBasic(Character.TYPE, "char", 8);
        SerializerFactory.addBasic(boolean[].class, "[boolean", 14);
        SerializerFactory.addBasic(byte[].class, "[byte", 15);
        SerializerFactory.addBasic(short[].class, "[short", 16);
        SerializerFactory.addBasic(int[].class, "[int", 17);
        SerializerFactory.addBasic(long[].class, "[long", 18);
        SerializerFactory.addBasic(float[].class, "[float", 19);
        SerializerFactory.addBasic(double[].class, "[double", 20);
        SerializerFactory.addBasic(char[].class, "[char", 21);
        SerializerFactory.addBasic(String[].class, "[string", 22);
        SerializerFactory.addBasic(Object[].class, "[object", 23);
        _staticSerializerMap.put(Class.class, new ClassSerializer());
        _staticDeserializerMap.put(Class.class, new ClassDeserializer());
        _staticDeserializerMap.put(Number.class, new BasicDeserializer(12));
        _staticSerializerMap.put(BigDecimal.class, new StringValueSerializer());
        try {
            _staticDeserializerMap.put(BigDecimal.class, new StringValueDeserializer(BigDecimal.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _staticSerializerMap.put(File.class, new StringValueSerializer());
        try {
            _staticDeserializerMap.put(File.class, new StringValueDeserializer(File.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _staticSerializerMap.put(java.sql.Date.class, new SqlDateSerializer());
        _staticSerializerMap.put(Time.class, new SqlDateSerializer());
        _staticSerializerMap.put(Timestamp.class, new SqlDateSerializer());
        _staticSerializerMap.put(InputStream.class, new InputStreamSerializer());
        _staticDeserializerMap.put(InputStream.class, new InputStreamDeserializer());
        try {
            _staticDeserializerMap.put(java.sql.Date.class, new SqlDateDeserializer(java.sql.Date.class));
            _staticDeserializerMap.put(Time.class, new SqlDateDeserializer(Time.class));
            _staticDeserializerMap.put(Timestamp.class, new SqlDateDeserializer(Timestamp.class));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Class<?> stackTrace = Class.forName("java.lang.StackTraceElement");
            _staticSerializerMap.put(stackTrace, new StackTraceElementSerializer());
            _staticDeserializerMap.put(stackTrace, new StackTraceElementDeserializer());
        }
        catch (Throwable stackTrace) {
            // empty catch block
        }
        try {
            if (isHigherThanJdk8) {
                _staticSerializerMap.put(Class.forName("java.time.LocalTime"), Java8TimeSerializer.create(LocalTimeHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.LocalDate"), Java8TimeSerializer.create(LocalDateHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.LocalDateTime"), Java8TimeSerializer.create(LocalDateTimeHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.Instant"), Java8TimeSerializer.create(InstantHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.Duration"), Java8TimeSerializer.create(DurationHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.Period"), Java8TimeSerializer.create(PeriodHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.Year"), Java8TimeSerializer.create(YearHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.YearMonth"), Java8TimeSerializer.create(YearMonthHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.MonthDay"), Java8TimeSerializer.create(MonthDayHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.OffsetDateTime"), Java8TimeSerializer.create(OffsetDateTimeHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.ZoneOffset"), Java8TimeSerializer.create(ZoneOffsetHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.OffsetTime"), Java8TimeSerializer.create(OffsetTimeHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.ZonedDateTime"), Java8TimeSerializer.create(ZonedDateTimeHandle.class));
                _staticSerializerMap.put(Class.forName("java.time.ZonedDateTime"), Java8TimeSerializer.create(ZonedDateTimeHandle.class));
            }
        }
        catch (Throwable t) {
            log.warning(String.valueOf(t.getCause()));
        }
        try {
            AtomicSerializer atomicSerializer = new AtomicSerializer();
            _staticSerializerMap.put(AtomicInteger.class, atomicSerializer);
            _staticSerializerMap.put(AtomicLong.class, atomicSerializer);
            _staticSerializerMap.put(AtomicBoolean.class, atomicSerializer);
            _staticSerializerMap.put(AtomicReference.class, atomicSerializer);
            _staticSerializerMap.put(AtomicLongArray.class, atomicSerializer);
            _staticSerializerMap.put(AtomicIntegerArray.class, atomicSerializer);
            _staticSerializerMap.put(AtomicReferenceArray.class, atomicSerializer);
            _staticDeserializerMap.put(AtomicInteger.class, new AtomicDeserializer(AtomicInteger.class));
            _staticDeserializerMap.put(AtomicLong.class, new AtomicDeserializer(AtomicLong.class));
            _staticDeserializerMap.put(AtomicBoolean.class, new AtomicDeserializer(AtomicBoolean.class));
            _staticDeserializerMap.put(AtomicReference.class, new AtomicDeserializer(AtomicReference.class));
            _staticDeserializerMap.put(AtomicLongArray.class, new AtomicDeserializer(AtomicLongArray.class));
            _staticDeserializerMap.put(AtomicIntegerArray.class, new AtomicDeserializer(AtomicIntegerArray.class));
            _staticDeserializerMap.put(AtomicReferenceArray.class, new AtomicDeserializer(AtomicReferenceArray.class));
        }
        catch (Throwable t) {
            log.warning(String.valueOf(t.getCause()));
        }
        if (isHigherThanJdk17) {
            SerializerFactory.addCurrencySupport();
        }
        SerializerFactory.addAbstractStringBuilderSupport();
    }
}

