/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.common.model;

import com.tencent.polaris.plugins.stat.common.util.SignatureUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class StatMetric {
    private final String metricName;
    private final Map<String, String> labels;
    private final Long signature;
    private final AtomicLong value;

    public StatMetric(String metricName, Map<String, String> labels) {
        this(metricName, labels, SignatureUtil.labelsToSignature(labels));
    }

    public StatMetric(String metricName, Map<String, String> labels, Long signature) {
        this.metricName = metricName;
        this.labels = labels;
        this.signature = signature;
        this.value = new AtomicLong();
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public double getValue() {
        return this.value.doubleValue();
    }

    public void setValue(long value) {
        this.value.set(value);
    }

    public long addValue(long value) {
        return this.value.addAndGet(value);
    }

    public long incValue() {
        return this.addValue(1L);
    }

    public boolean compareAndSet(long expect, long update) {
        return this.value.compareAndSet(expect, update);
    }

    public Long getSignature() {
        return this.signature;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.signature.equals(((StatMetric)that).signature);
    }

    public int hashCode() {
        return this.signature.intValue();
    }
}

