/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.rpc.cluster.router.RouterSnapshotSwitcher;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;

@Cmd(name="enableRouterSnapshot", summary="Enable Dubbo Invocation Level Router Snapshot Print", example={"enableRouterSnapshot xx.xx.xxx.service"})
public class EnableRouterSnapshot
implements BaseCommand {
    private final RouterSnapshotSwitcher routerSnapshotSwitcher;
    private final FrameworkModel frameworkModel;

    public EnableRouterSnapshot(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.routerSnapshotSwitcher = frameworkModel.getBeanFactory().getBean(RouterSnapshotSwitcher.class);
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        if (args.length != 1) {
            return "args count should be 1. example enableRouterSnapshot xx.xx.xxx.service";
        }
        String servicePattern = args[0];
        int count = 0;
        for (ConsumerModel consumerModel : this.frameworkModel.getServiceRepository().allConsumerModels()) {
            try {
                ServiceMetadata metadata = consumerModel.getServiceMetadata();
                if (!metadata.getServiceKey().matches(servicePattern) && !metadata.getDisplayServiceKey().matches(servicePattern)) continue;
                this.routerSnapshotSwitcher.addEnabledService(metadata.getServiceKey());
                ++count;
            }
            catch (Throwable throwable) {}
        }
        return "OK. Found service count: " + count + ". This will cause performance degradation, please be careful!";
    }
}

