/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;

public class DefaultMultipleSerialization
implements MultipleSerialization {
    @Override
    public void serialize(URL url, String serializeType, Class<?> clz, Object obj, OutputStream os) throws IOException {
        serializeType = this.convertHessian(serializeType);
        Serialization serialization = url.getOrDefaultFrameworkModel().getExtensionLoader(Serialization.class).getExtension(serializeType);
        ObjectOutput serialize = serialization.serialize(null, os);
        serialize.writeObject(obj);
        serialize.flushBuffer();
    }

    @Override
    public Object deserialize(URL url, String serializeType, Class<?> clz, InputStream os) throws IOException, ClassNotFoundException {
        serializeType = this.convertHessian(serializeType);
        Serialization serialization = url.getOrDefaultFrameworkModel().getExtensionLoader(Serialization.class).getExtension(serializeType);
        ObjectInput in = serialization.deserialize(null, os);
        return in.readObject(clz);
    }

    private String convertHessian(String ser) {
        if (ser.equals("hessian4")) {
            return "hessian2";
        }
        return ser;
    }
}

