/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.support;

import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.client.rpc.ServantClient;
import com.qq.tars.common.util.concurrent.TaskQueue;
import com.qq.tars.common.util.concurrent.TaskThreadFactory;
import com.qq.tars.common.util.concurrent.TaskThreadPoolExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ClientThreadPoolManager {
    private static ConcurrentHashMap<String, ThreadPoolExecutor> clientThreadPoolMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor getClientThreadPoolExecutor(CommunicatorConfig communicatorConfig) {
        String contextIdentity = ClientThreadPoolManager.resolveCurrentContextIdentity();
        ThreadPoolExecutor clientPoolExecutor = clientThreadPoolMap.get(contextIdentity);
        if (clientPoolExecutor != null) return clientPoolExecutor;
        Class<ServantClient> clazz = ServantClient.class;
        synchronized (ServantClient.class) {
            clientPoolExecutor = clientThreadPoolMap.get(contextIdentity);
            if (clientPoolExecutor != null) return clientPoolExecutor;
            clientThreadPoolMap.put(contextIdentity, ClientThreadPoolManager.createThreadPool(communicatorConfig));
            return clientThreadPoolMap.get(contextIdentity);
        }
    }

    private static ThreadPoolExecutor createThreadPool(CommunicatorConfig communicatorConfig) {
        int corePoolSize = communicatorConfig.getCorePoolSize();
        int maxPoolSize = communicatorConfig.getMaxPoolSize();
        int keepAliveTime = communicatorConfig.getKeepAliveTime();
        int queueSize = communicatorConfig.getQueueSize();
        TaskQueue taskqueue = new TaskQueue(queueSize);
        String namePrefix = "tars-client-executor-";
        TaskThreadPoolExecutor executor = new TaskThreadPoolExecutor(corePoolSize, maxPoolSize, (long)keepAliveTime, TimeUnit.SECONDS, (BlockingQueue<Runnable>)taskqueue, new TaskThreadFactory(namePrefix));
        taskqueue.setParent(executor);
        return executor;
    }

    private static String resolveCurrentContextIdentity() {
        ClassLoader selfClassLoader = ClientThreadPoolManager.class.getClassLoader();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String contextIdentity = ClientThreadPoolManager.class.getName();
        if (selfClassLoader != null && contextClassLoader != null && selfClassLoader != contextClassLoader) {
            contextIdentity = contextClassLoader.toString();
        }
        return contextIdentity;
    }
}

