/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.mode.cluster.service;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.mode.ShenyuRunningModeService;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.apache.shenyu.admin.service.impl.InstanceCheckService;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.admin.service.manager.LoadServiceDocEntry;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShenyuClusterService
implements ShenyuRunningModeService {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuClusterService.class);
    private final ClusterSelectMasterService shenyuClusterSelectMasterService;
    private final UpstreamCheckService upstreamCheckService;
    private final LoadServiceDocEntry loadServiceDocEntry;
    private final ScheduledExecutorService executorService;
    private final ClusterProperties clusterProperties;
    private final InstanceCheckService instanceCheckService;

    public ShenyuClusterService(ClusterSelectMasterService shenyuClusterSelectMasterService, UpstreamCheckService upstreamCheckService, InstanceCheckService instanceCheckService, LoadServiceDocEntry loadServiceDocEntry, ClusterProperties clusterProperties) {
        this.shenyuClusterSelectMasterService = shenyuClusterSelectMasterService;
        this.upstreamCheckService = upstreamCheckService;
        this.loadServiceDocEntry = loadServiceDocEntry;
        this.clusterProperties = clusterProperties;
        this.executorService = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"master-selector", (boolean)true));
        this.instanceCheckService = instanceCheckService;
    }

    public void startSelectMasterTask(String host, String port, String contextPath) {
        LOG.info("starting select master task");
        this.executorService.scheduleAtFixedRate(() -> this.doSelectMaster(host, port, contextPath), 0L, this.clusterProperties.getSelectPeriod(), TimeUnit.SECONDS);
    }

    private void doSelectMaster(String host, String port, String contextPath) {
        try {
            boolean selected = this.shenyuClusterSelectMasterService.selectMaster(host, port, contextPath);
            if (!selected) {
                LOG.info("select master fail, wait for next period");
                return;
            }
            LOG.info("select master success");
            this.upstreamCheckService.setup();
            this.instanceCheckService.setup();
            boolean renewed = this.shenyuClusterSelectMasterService.checkMasterStatus();
            while (renewed) {
                TimeUnit.SECONDS.sleep(this.clusterProperties.getSelectPeriod());
                renewed = this.shenyuClusterSelectMasterService.checkMasterStatus();
                if (!renewed || !LOG.isDebugEnabled()) continue;
                LOG.debug("renew master success");
            }
        }
        catch (Exception e) {
            LOG.error("select master error", (Throwable)e);
            this.upstreamCheckService.close();
            this.instanceCheckService.close();
            String message = String.format("renew master fail, %s", e.getMessage());
            throw new ShenyuException(message);
        }
        finally {
            try {
                this.shenyuClusterSelectMasterService.releaseMaster();
            }
            catch (Exception e) {
                LOG.error("release master error", (Throwable)e);
            }
        }
    }

    @Override
    public void start(String host, int port, String contextPath) {
        this.startSelectMasterTask(host, String.valueOf(port), contextPath);
    }

    @Override
    public void shutdown() {
    }
}

