/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.aspect.controller;

import com.google.common.base.Stopwatch;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.shenyu.admin.aspect.controller.ControllerMethodAdvice;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.exception.ShenyuException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RestControllerAspect {
    private final List<ControllerMethodAdvice> methodAdviceList;

    public RestControllerAspect(List<ControllerMethodAdvice> methodAdviceList) {
        this.methodAdviceList = methodAdviceList;
    }

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController) || @within(org.apache.shenyu.admin.aspect.annotation.RestApi)")
    public void controller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="controller()")
    public Object logAround(ProceedingJoinPoint point) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        Object target = point.getTarget();
        try {
            this.doExec(a -> a.doPreProcess(target, method, stopwatch));
            Object object = point.proceed();
            return object;
        }
        catch (Throwable throwable) {
            this.doExec(a -> a.doThrowable(target, method, stopwatch, throwable));
            if (throwable instanceof ShenyuException) {
                throw (ShenyuException)throwable;
            }
            throw new ShenyuAdminException(throwable);
        }
        finally {
            try {
                this.doExec(a -> a.doFinally(target, method, stopwatch));
            }
            finally {
                SessionUtil.clean();
            }
        }
    }

    void doExec(Call call) {
        for (ControllerMethodAdvice advice : this.methodAdviceList) {
            call.call(advice);
        }
    }

    static interface Call {
        public void call(ControllerMethodAdvice var1);
    }
}

