/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.peer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shell.cli.CliUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.util.Preconditions;

public class AddCommand
extends AbstractRatisCommand {
    public static final String ADDRESS_OPTION_NAME = "address";
    public static final String PEER_ID_OPTION_NAME = "peerId";
    public static final String CLIENT_ADDRESS_OPTION_NAME = "clientAddress";
    public static final String ADMIN_ADDRESS_OPTION_NAME = "adminAddress";

    public AddCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "add";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        List<Object> ids;
        super.run(cl);
        HashMap peersInfo = new HashMap();
        HashMap clientAddressInfo = new HashMap();
        HashMap adminAddressInfo = new HashMap();
        if (cl.hasOption(ADDRESS_OPTION_NAME) && cl.hasOption(PEER_ID_OPTION_NAME)) {
            int i;
            ids = Arrays.stream(cl.getOptionValue(PEER_ID_OPTION_NAME).split(",")).map(RaftPeerId::getRaftPeerId).collect(Collectors.toList());
            List addresses = Arrays.stream(cl.getOptionValue(ADDRESS_OPTION_NAME).split(",")).map(CliUtils::parseInetSocketAddress).collect(Collectors.toList());
            Preconditions.assertSame((int)ids.size(), (int)addresses.size(), (String)"size");
            for (int i2 = 0; i2 < ids.size(); ++i2) {
                peersInfo.put(ids.get(i2), addresses.get(i2));
            }
            if (cl.hasOption(CLIENT_ADDRESS_OPTION_NAME)) {
                List clientAddresses = Arrays.stream(cl.getOptionValue(CLIENT_ADDRESS_OPTION_NAME).split(",")).map(CliUtils::parseInetSocketAddress).collect(Collectors.toList());
                Preconditions.assertSame((int)ids.size(), (int)clientAddresses.size(), (String)"clientAddress size");
                for (i = 0; i < ids.size(); ++i) {
                    clientAddressInfo.put(ids.get(i), clientAddresses.get(i));
                }
            }
            if (cl.hasOption(ADMIN_ADDRESS_OPTION_NAME)) {
                List adminAddresses = Arrays.stream(cl.getOptionValue(ADMIN_ADDRESS_OPTION_NAME).split(",")).map(CliUtils::parseInetSocketAddress).collect(Collectors.toList());
                Preconditions.assertSame((int)ids.size(), (int)adminAddresses.size(), (String)"adminAddress size");
                for (i = 0; i < ids.size(); ++i) {
                    adminAddressInfo.put(ids.get(i), adminAddresses.get(i));
                }
            }
        } else if (cl.hasOption(ADDRESS_OPTION_NAME)) {
            ids = this.getIds(cl.getOptionValue(ADDRESS_OPTION_NAME).split(","), peersInfo::put);
            if (cl.hasOption(CLIENT_ADDRESS_OPTION_NAME) || cl.hasOption(ADMIN_ADDRESS_OPTION_NAME)) {
                throw new IllegalArgumentException("When using auto-generated peer IDs, clientAddress and adminAddress are not supported.");
            }
        } else {
            throw new IllegalArgumentException("Both peerId and address options are missing.");
        }
        try (RaftClient client = this.newRaftClient();){
            Stream<RaftPeer> remaining = this.getPeerStream(RaftProtos.RaftPeerRole.FOLLOWER);
            Stream<RaftPeer> adding = ids.stream().map(raftPeerId -> {
                RaftPeer.Builder builder = RaftPeer.newBuilder().setId(raftPeerId).setAddress((InetSocketAddress)peersInfo.get(raftPeerId)).setPriority(0);
                if (clientAddressInfo.containsKey(raftPeerId)) {
                    builder.setClientAddress((InetSocketAddress)clientAddressInfo.get(raftPeerId));
                }
                if (adminAddressInfo.containsKey(raftPeerId)) {
                    builder.setAdminAddress((InetSocketAddress)adminAddressInfo.get(raftPeerId));
                }
                return builder.build();
            });
            List peers = Stream.concat(remaining, adding).collect(Collectors.toList());
            List listeners = this.getPeerStream(RaftProtos.RaftPeerRole.LISTENER).collect(Collectors.toList());
            System.out.println("New peer list: " + peers);
            System.out.println("New listener list:  " + listeners);
            RaftClientReply reply = client.admin().setConfiguration(peers, listeners);
            this.processReply(reply, () -> "Failed to change raft peer");
        }
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>] <[-%s <PEER0_HOST:PEER0_PORT>]|[-%s <peerId>]> [-%s <CLIENT_ADDRESS1,CLIENT_ADDRESS2,...>] [-%s <ADMIN_ADDRESS1,ADMIN_ADDRESS2,...>]", this.getCommandName(), "peers", "groupid", ADDRESS_OPTION_NAME, PEER_ID_OPTION_NAME, CLIENT_ADDRESS_OPTION_NAME, ADMIN_ADDRESS_OPTION_NAME);
    }

    @Override
    public String getDescription() {
        return AddCommand.description();
    }

    @Override
    public Options getOptions() {
        return super.getOptions().addOption(Option.builder().option(ADDRESS_OPTION_NAME).hasArg().desc("The address information of ratis peers").build()).addOption(Option.builder().option(PEER_ID_OPTION_NAME).hasArg().desc("The peer id of ratis peers").build()).addOption(Option.builder().option(CLIENT_ADDRESS_OPTION_NAME).hasArg().desc("The client address information of ratis peers").build()).addOption(Option.builder().option(ADMIN_ADDRESS_OPTION_NAME).hasArg().desc("The admin address information of ratis peers").build());
    }

    public static String description() {
        return "Add peers to a ratis group";
    }
}

